<?php

/**
 * ARRAYKEY:
 * easy_fundraisers_singlecol_settings_arraykey
 * 
 * ARRAYKEY-USE:
 * get_option('easy_fundraisers_singlecol_settings_arraykey')
 * 
 * OPTIONS:
 * SHOW CATEGORIES:         show_categories
 * FIRST NAME:              default_first_name
 * LAST NAME:               default_last_name
 * E-MAIL:                  default_email
 * AMOUNT:                  default_amount
 * DONATE REPLY:            donate_reply
 * CHECKBOX TEXT:           checkbox_text
 * 
 * OPTIONS-USE:
 * $options['show_categories']
**/

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('easy_fundraisers_singlecol_settings')) {

	class easy_fundraisers_singlecol_settings {

		public function __construct() {
		}
		
		public function easy_fundraisers_initSettings() {
			$options = get_option('easy_fundraisers_singlecol_settings_arraykey');
			if (!isset($options['show_categories']) || empty($options['show_categories']) || $options['show_categories'] == null) {
				$options['show_categories'] = 'false';
				update_option('easy_fundraisers_singlecol_settings_arraykey', $options);
			}
			if (!isset($options['default_first_name']) || empty($options['default_first_name']) || $options['default_first_name'] == null) {
				$options['default_first_name'] = __('Firstname', 'fpdomain');
				update_option('easy_fundraisers_singlecol_settings_arraykey', $options);
			}
			if (!isset($options['default_last_name']) || empty($options['default_last_name']) || $options['default_last_name'] == null) {
				$options['default_last_name'] = __('Lastname', 'fpdomain');
				update_option('easy_fundraisers_singlecol_settings_arraykey', $options);
			}
			if (!isset($options['default_email']) || empty($options['default_email']) || $options['default_email'] == null) {
				$options['default_email'] = __('my@email.com', 'fpdomain');
				update_option('easy_fundraisers_singlecol_settings_arraykey', $options);
			}
			if (!isset($options['default_amount']) || empty($options['default_amount']) || $options['default_amount'] == null) {
				$options['default_amount'] = '100';
				update_option('easy_fundraisers_singlecol_settings_arraykey', $options);
			}
			if (!isset($options['donate_reply']) || empty($options['donate_reply']) || $options['donate_reply'] == null) {
				$options['donate_reply'] = __('Thank you for your donation!', 'fpdomain');
				update_option('easy_fundraisers_singlecol_settings_arraykey', $options);
			}
			if (!isset($options['checkbox_text']) || empty($options['checkbox_text']) || $options['checkbox_text'] == null) {
				$options['checkbox_text'] = '<a href="#">' . __('Terms of Service!', 'fpdomain') . '</a>';
				update_option('easy_fundraisers_singlecol_settings_arraykey', $options);
			}
		}
			
		public function easy_fundraisers_registerSettings() {

			$this->easy_fundraisers_addFirstSection();
			$this->easy_fundraisers_addSecondSection();
            
			// register_setting( $option_group, $option_name, $sanitize_callback )
			register_setting( 'singlecol-settings-group', 'easy_fundraisers_singlecol_settings_arraykey', array($this, 'easy_fundraisers_singlecol_settings_validate') );
		}
        
        private function easy_fundraisers_addFirstSection() {
			// add_settings_section( $id, $title, $callback, $page )
			add_settings_section(
				'singlecol_section',
				esc_html__('Single Collection Settings', 'fpdomain'),
				array($this, 'easy_fundraisers_print_singlecol_section_info'),
				'donation-plugin-singlecol-group'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'show_categories', 
				esc_html__('Show categories:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_show_categories_setting'), 
				'donation-plugin-singlecol-group', 
				'singlecol_section'
			);
        }
        
        private function easy_fundraisers_addSecondSection() {
            $payex_options = get_option('easy_fundraisers_payex_settings_arraykey');
                    
			// add_settings_section( $id, $title, $callback, $page )
			add_settings_section(
				'singlecol_donation_section',
				esc_html__('Donation Form', 'fpdomain'),
				array($this, 'easy_fundraisers_print_singlecol_donation_section_info'),
				'donation-plugin-singlecol-group'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'default_first_name', 
				esc_html__('Default first name:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_default_f_name_setting'), 
				'donation-plugin-singlecol-group', 
				'singlecol_donation_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'default_last_name', 
				esc_html__('Default last name:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_default_l_name_setting'), 
				'donation-plugin-singlecol-group', 
				'singlecol_donation_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'default_email', 
				esc_html__('Default e-mail:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_default_email_setting'), 
				'donation-plugin-singlecol-group', 
				'singlecol_donation_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'default_amount', 
				esc_html__('Default amount', 'fpdomain') . ' (' . esc_html($payex_options['payex_currency']) . '):', 
				array($this, 'easy_fundraisers_create_input_default_amount_setting'), 
				'donation-plugin-singlecol-group', 
				'singlecol_donation_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'donate_reply', 
				esc_html__('Donation reply:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_donate_reply_setting'), 
				'donation-plugin-singlecol-group', 
				'singlecol_donation_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'checkbox_text', 
				esc_html__('Checkbox text:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_checkbox_text_setting'), 
				'donation-plugin-singlecol-group', 
				'singlecol_donation_section'
			);
        }

		public function easy_fundraisers_print_singlecol_section_info() {
			echo '<p>' .  esc_html__('Settings for the single collections.', 'fpdomain') . '</p>';
		}

		public function easy_fundraisers_create_input_show_categories_setting() {
			$options = get_option('easy_fundraisers_singlecol_settings_arraykey');
            
			if ($options['show_categories'] == 'true') {
				echo '<input type="checkbox" name="easy_fundraisers_singlecol_settings_arraykey[show_categories]" value="true" checked />';
			} else {
				echo '<input type="checkbox" name="easy_fundraisers_singlecol_settings_arraykey[show_categories]" value="true" />';
			}
            echo '<p>' . esc_html__( 'Enable this option to show categories on a single collection.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_print_singlecol_donation_section_info() {
			echo '<p>' .  esc_html__('Settings for single collection donation form.', 'fpdomain') . '</p>';
		}

		public function easy_fundraisers_create_input_default_f_name_setting() {
			$options = get_option('easy_fundraisers_singlecol_settings_arraykey');
            ?>
                <input type="text" name="easy_fundraisers_singlecol_settings_arraykey[default_first_name]" value="<?php echo esc_html($options['default_first_name']); ?>" />
            <?php
		}

		public function easy_fundraisers_create_input_default_l_name_setting() {
			$options = get_option('easy_fundraisers_singlecol_settings_arraykey');
            ?>
                <input type="text" name="easy_fundraisers_singlecol_settings_arraykey[default_last_name]" value="<?php echo esc_html($options['default_last_name']); ?>" />
            <?php
		}

		public function easy_fundraisers_create_input_default_email_setting() {
			$options = get_option('easy_fundraisers_singlecol_settings_arraykey');
            ?>
                <input type="email" name="easy_fundraisers_singlecol_settings_arraykey[default_email]" value="<?php echo esc_html($options['default_email']); ?>" />
            <?php
		}
        
		public function easy_fundraisers_create_input_default_amount_setting() {
			$options = get_option('easy_fundraisers_singlecol_settings_arraykey');
            ?>
                <input type="number" name="easy_fundraisers_singlecol_settings_arraykey[default_amount]" value="<?php echo esc_html($options['default_amount']); ?>" />
            <?php
		}
        
		public function easy_fundraisers_create_input_donate_reply_setting() {
			$options = get_option('easy_fundraisers_singlecol_settings_arraykey');
            ?>
                <textarea name="easy_fundraisers_singlecol_settings_arraykey[donate_reply]" rows="10" cols="80"><?php echo esc_html($options['donate_reply']); ?></textarea>
            <?php
		}
        
		public function easy_fundraisers_create_input_checkbox_text_setting() {
			$options = get_option('easy_fundraisers_singlecol_settings_arraykey');
            ?>
                <input type="text" name="easy_fundraisers_singlecol_settings_arraykey[checkbox_text]" value="<?php echo esc_html($options['checkbox_text']); ?>" />
            <?php
		}

		public function easy_fundraisers_singlecol_settings_validate($arr_input) {
            $new_show_categories = trim($arr_input['show_categories']);
            $new_default_first_name = trim($arr_input['default_first_name']);
            $new_default_last_name = trim($arr_input['default_last_name']);
            $new_default_email = trim($arr_input['default_email']);
            $new_default_amount = trim($arr_input['default_amount']);
            $new_donate_reply = trim($arr_input['donate_reply']);
            $new_checkbox_text = trim($arr_input['checkbox_text']);
            $fails = false;
            
            $new_show_categories = sanitize_text_field($new_show_categories);
            $new_default_first_name = sanitize_text_field($new_default_first_name);
            $new_default_last_name = sanitize_text_field($new_default_last_name);
            $new_default_email = sanitize_text_field($new_default_email);
            $new_default_amount = sanitize_text_field($new_default_amount);
            $new_donate_reply = wp_kses($new_donate_reply, $easy_fundraisers_html_tags);
            $new_checkbox_text = wp_kses($new_checkbox_text, $easy_fundraisers_html_tags);
            
            $options = get_option('easy_fundraisers_singlecol_settings_arraykey');
            
            // Checkbox == null when unchecked
            if (!isset($new_show_categories) || empty($new_show_categories) || $new_show_categories == null) {
                $new_show_categories = 'false';
            }
            
			$options['show_categories'] = $new_show_categories;
			$options['default_first_name'] = $new_default_first_name;
			$options['default_last_name'] = $new_default_last_name;
            
            if (!isset($new_default_email) ||
                empty($new_default_email) ||
                strlen($new_default_email) < 3 ||
                strlen($new_default_email) > 100 ||
                !filter_var($new_default_email, FILTER_VALIDATE_EMAIL)) {
                add_settings_error('singlecol_section', 'singlecol_settings_general_notice', esc_html__('The chosen e-mail is invalid!', 'fpdomain'), 'error');
                $fails = true;
            } else {
                $options['default_email'] = $new_default_email;
            }
            
            if (!is_numeric($new_default_amount) || intval($new_default_amount) < 1) {
                add_settings_error('singlecol_section', 'singlecol_settings_general_notice', esc_html__('The chosen amount is invalid!', 'fpdomain'), 'error');
                $fails = true;
                $options['default_amount'] = '100';
            } else {
                $options['default_amount'] = $new_default_amount;
            }
            
			$options['donate_reply'] = $new_donate_reply;
			$options['checkbox_text'] = $new_checkbox_text;
            
            if ($fails) {
                add_settings_error('singlecol_section', 'singlecol_settings_general_notice', esc_html__('Settings was saved with errors!', 'fpdomain'), 'error');
            } else {
                add_settings_error('singlecol_section', 'singlecol_settings_general_notice', esc_html__('Settings saved.', 'fpdomain'), 'updated');
            }
            
			return $options;
		}

    	public function easy_fundraisers_create_settings_page() {
            settings_errors('singlecol_section');
        	?>
            <div class="wrap">
                <form method="post" action="options.php">
                <?php
            		// This prints out all hidden setting fields
            		// settings_fields( $option_group )
            		settings_fields( 'singlecol-settings-group' );
            		// do_settings_sections( $page )
            		do_settings_sections( 'donation-plugin-singlecol-group' );
                ?>
                <?php submit_button('Save Changes'); ?>
                </form>
            </div>
        	<?php
	   }
	}
}

?>
