<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('easy_fundraisers_settings')) {

	class easy_fundraisers_settings {

		public function __construct() {
			$this->easy_fundraisers_settings_init();
		}

		public function easy_fundraisers_settings_init() {
			$active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'general';

			?>
			<div class="wrap">
				<h2><?php esc_html_e('Settings', 'fpdomain'); ?></h2>
				<h2 class="nav-tab-wrapper">
					<a href="?post_type=collection&page=collections-settings-menu&tab=general" class="nav-tab <?php echo $active_tab == 'general' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('General', 'fpdomain'); ?></a>
					<a href="?post_type=collection&page=collections-settings-menu&tab=payex" class="nav-tab <?php echo $active_tab == 'payex' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('PayEx', 'fpdomain'); ?></a>
					<a href="?post_type=collection&page=collections-settings-menu&tab=email" class="nav-tab <?php echo $active_tab == 'email' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('Email', 'fpdomain'); ?></a>
					<a href="?post_type=collection&page=collections-settings-menu&tab=archive" class="nav-tab <?php echo $active_tab == 'archive' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('Collections Archive', 'fpdomain'); ?></a>
					<a href="?post_type=collection&page=collections-settings-menu&tab=newcol" class="nav-tab <?php echo $active_tab == 'newcol' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('New Collection Form', 'fpdomain'); ?></a>
					<a href="?post_type=collection&page=collections-settings-menu&tab=singlecol" class="nav-tab <?php echo $active_tab == 'singlecol' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('Single Collection', 'fpdomain'); ?></a>
					<a href="?post_type=collection&page=collections-settings-menu&tab=3colwidget" class="nav-tab <?php echo $active_tab == '3colwidget' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('3 Column Widget', 'fpdomain'); ?></a>
				</h2>
				<div class="postbox">
					<div class="inside">
					<?php

						if ($active_tab == 'general') {
							include_once('class-easy-fundraisers-general-settings.php');
							$easy_fundraisers_general_settings = new easy_fundraisers_general_settings();
							$easy_fundraisers_general_settings->easy_fundraisers_create_settings_page();
						} else if ($active_tab == 'payex') {
							include_once('class-easy-fundraisers-payex-settings.php');
							$easy_fundraisers_sfl_payex_settings = new easy_fundraisers_sfl_payex_settings();
							$easy_fundraisers_sfl_payex_settings->easy_fundraisers_create_settings_page();
						} else if ($active_tab == 'email') {
							include_once('class-easy-fundraisers-email-settings.php');
							$easy_fundraisers_email_settings = new easy_fundraisers_email_settings();
							$easy_fundraisers_email_settings->easy_fundraisers_create_settings_page();
						} else if ($active_tab == 'newcol') {
							include_once('class-easy-fundraisers-newcol-settings.php');
							$easy_fundraisers_newcol_settings = new easy_fundraisers_newcol_settings();
							$easy_fundraisers_newcol_settings->easy_fundraisers_create_settings_page();
						} else if ($active_tab == '3colwidget') {
							include_once('class-easy-fundraisers-3colwidget-settings.php');
							$easy_fundraisers_3colwidget_settings = new easy_fundraisers_3colwidget_settings();
							$easy_fundraisers_3colwidget_settings->easy_fundraisers_create_settings_page();
						} else if ($active_tab == 'archive') {
							include_once('class-easy-fundraisers-archive-settings.php');
							$easy_fundraisers_archive_settings = new easy_fundraisers_archive_settings();
							$easy_fundraisers_archive_settings->easy_fundraisers_create_settings_page();
						} else {
							include_once('class-easy-fundraisers-singlecol-settings.php');
							$easy_fundraisers_singlecol_settings = new easy_fundraisers_singlecol_settings();
							$easy_fundraisers_singlecol_settings->easy_fundraisers_create_settings_page();
						}

					?>
					</div>
				</div>
			</div>
			<?php
		}
	}
}

?>
