<?php

/**
 * ARRAYKEY:
 * easy_fundraisers_payex_settings_arraykey
 * 
 * ARRAYKEY-USE:
 * get_option('easy_fundraisers_payex_settings_arraykey')
 * 
 * OPTIONS:
 * SERVER:      payex_server
 * ACC.NR:      payex_account_number
 * ENCR.KEY:    payex_encryption_key
 * CURRENCY:    payex_currency
 * 
 * OPTIONS-USE:
 * $options['payex_server']
**/

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('easy_fundraisers_sfl_payex_settings')) {

	class easy_fundraisers_sfl_payex_settings {

		public function __construct() {
		}
		
		public function easy_fundraisers_initSettings() {
			$options = get_option('easy_fundraisers_payex_settings_arraykey');
			if (!isset($options['payex_server']) || empty($options['payex_server']) || $options['payex_server'] == null) {
				$options['payex_server'] = 'test';
				update_option('easy_fundraisers_payex_settings_arraykey', $options);
			}
			if (!isset($options['payex_currency']) || empty($options['payex_currency']) || $options['payex_currency'] == null) {
				$options['payex_currency'] = 'USD';
				update_option('easy_fundraisers_payex_settings_arraykey', $options);
			}
		}
			
		public function easy_fundraisers_registerSettings() {

			// add_settings_section( $id, $title, $callback, $page )
			add_settings_section(
				'payex_section',
				esc_html__('PayEx Settings', 'fpdomain'),
				array($this, 'easy_fundraisers_print_payex_section_info'),
				'donation-plugin-payex-group'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'payex_server', 
				esc_html__('Server:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_payex_server_setting'), 
				'donation-plugin-payex-group', 
				'payex_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'payex_account_number', 
				esc_html__('Account Number:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_payex_account_number_setting'), 
				'donation-plugin-payex-group', 
				'payex_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'payex_encryption_key', 
				esc_html__('Encryption Key:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_payex_encryption_key_setting'), 
				'donation-plugin-payex-group', 
				'payex_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'payex_currency', 
				esc_html__('Currency:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_payex_currency_setting'), 
				'donation-plugin-payex-group', 
				'payex_section'
			);

			// register_setting( $option_group, $option_name, $sanitize_callback )
			register_setting( 'payex-settings-group', 'easy_fundraisers_payex_settings_arraykey', array($this, 'easy_fundraisers_payex_settings_validate') );
		}

		public function easy_fundraisers_print_payex_section_info() {
			echo '<p>' .  esc_html__('Settings for PayEx.', 'fpdomain') . '</p>';
		}

		public function easy_fundraisers_create_input_payex_server_setting() {
			$options = get_option('easy_fundraisers_payex_settings_arraykey');
			?>
                <select name="easy_fundraisers_payex_settings_arraykey[payex_server]">
					<option value="test" <?php if ($options['payex_server'] == 'test') echo 'selected'; ?>>Test</option>
					<option value="production" <?php if ($options['payex_server'] == 'production') echo 'selected'; ?>>Production</option>
				</select>
                <p><?php esc_html_e( 'Use the test server for testing purposes, the production server is used for real transactions.', 'fpdomain' ); ?></p>
            <?php
		}

		public function easy_fundraisers_create_input_payex_account_number_setting() {
			$options = get_option('easy_fundraisers_payex_settings_arraykey');
			?>
                <input type="text" name="easy_fundraisers_payex_settings_arraykey[payex_account_number]" value="<?php echo esc_html($options['payex_account_number']); ?>" />
                <p><?php esc_html_e( 'Enter the account number supplied with the PayEx account.', 'fpdomain' ); ?></p>
            <?php
		}

		public function easy_fundraisers_create_input_payex_encryption_key_setting() {
			$options = get_option('easy_fundraisers_payex_settings_arraykey');
			?>
                <input type="password" name="easy_fundraisers_payex_settings_arraykey[payex_encryption_key]" value="<?php echo esc_html($options['payex_encryption_key']); ?>" />
                <p><?php esc_html_e( 'Enter the encryption key supplied with the PayEx account.', 'fpdomain' ); ?></p>
            <?php
		}

		public function easy_fundraisers_create_input_payex_currency_setting() {
			$options = get_option('easy_fundraisers_payex_settings_arraykey');
			?>
                <select name="easy_fundraisers_payex_settings_arraykey[payex_currency]">
					<option value="SEK" <?php if ($options['payex_currency'] == 'SEK') echo 'selected'; ?>>SEK</option>
					<option value="EUR" <?php if ($options['payex_currency'] == 'EUR') echo 'selected'; ?>>EUR</option>
					<option value="GBP" <?php if ($options['payex_currency'] == 'GBP') echo 'selected'; ?>>GBP</option>
					<option value="USD" <?php if ($options['payex_currency'] == 'USD') echo 'selected'; ?>>USD</option>
				</select>
                <p><?php esc_html_e( 'Changing this option does not affect old donations!', 'fpdomain' ); ?></p>
            <?php
            
		}

		public function easy_fundraisers_payex_settings_validate($arr_input) {
            $new_payex_server = trim($arr_input['payex_server']);
            $new_payex_account_number = trim($arr_input['payex_account_number']);
            $new_payex_encryption_key = trim($arr_input['payex_encryption_key']);
            $new_payex_currency = trim($arr_input['payex_currency']);
            
            $new_payex_server = sanitize_text_field($new_payex_server);
            $new_payex_account_number = sanitize_text_field($new_payex_account_number);
            $new_payex_encryption_key = sanitize_text_field($new_payex_encryption_key);
            $new_payex_currency = sanitize_text_field($new_payex_currency);
            
            $options = get_option('easy_fundraisers_payex_settings_arraykey');
			$options['payex_server'] = $new_payex_server;
            $options['payex_account_number'] = $new_payex_account_number;
            $options['payex_encryption_key'] = $new_payex_encryption_key;
			$options['payex_currency'] = $new_payex_currency;
            
            add_settings_error('payex_section', 'payex_settings_general_notice', esc_html__('Settings saved.', 'fpdomain'), 'updated');
            
			return $options;
		}

    	public function easy_fundraisers_create_settings_page() {
            settings_errors('payex_section');
        	?>
            <div class="wrap">
                <form method="post" action="options.php">
                <?php
            		// This prints out all hidden setting fields
            		// settings_fields( $option_group )
            		settings_fields( 'payex-settings-group' );
            		// do_settings_sections( $page )
            		do_settings_sections( 'donation-plugin-payex-group' );
                ?>
                <?php submit_button('Save Changes'); ?>
                </form>
            </div>
        	<?php
	   }
	}
}

?>
