<?php

/**
 * ARRAYKEY:
 * easy_fundraisers_newcol_settings_arraykey
 * 
 * ARRAYKEY-USE:
 * get_option('easy_fundraisers_newcol_settings_arraykey')
 * 
 * OPTIONS:
 * DEFAULT CATEGORY:            default_category
 * FINISH DATE LIMIT:           finish_date_limit
 * COLLECTION NAME:             collection_name
 * COLLECTION DESC:             collection_desc
 * E-MAIL REPLY:                email_reply
 * E-MAIL REPLY INFO:			email_reply_info
 * CHECKBOX TEXT:               default_checkbox_text
 * DESCRIPTION TEXT:            registration_text
 * SUCCESS TEXT:                created_text
 * 
 * OPTIONS-USE:
 * $options['default_category']
**/

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('easy_fundraisers_newcol_settings')) {

	class easy_fundraisers_newcol_settings {

		public function __construct() {
		}
        
        public function easy_fundraisers_initSettings() {
			$options = get_option('easy_fundraisers_newcol_settings_arraykey');
            
            // Settings
            if (!isset($options['default_category']) || empty($options['default_category']) || $options['default_category'] == null) {
				//$options['default_category'] = 'false';
				//update_option('easy_fundraisers_newcol_settings_arraykey', $options);
			}
            if (!isset($options['finish_date_limit']) || empty($options['finish_date_limit']) || $options['finish_date_limit'] == null) {
				$options['finish_date_limit'] = '24';
				update_option('easy_fundraisers_newcol_settings_arraykey', $options);
			}
            if (!isset($options['collection_name']) || empty($options['collection_name']) || $options['collection_name'] == null) {
				$options['collection_name'] = __('Your collection name', 'fpdomain');
				update_option('easy_fundraisers_newcol_settings_arraykey', $options);
			}
            if (!isset($options['collection_desc']) || empty($options['collection_desc']) || $options['collection_desc'] == null) {
				$options['collection_desc'] = __('Your collection description', 'fpdomain');
				update_option('easy_fundraisers_newcol_settings_arraykey', $options);
			}
            if (!isset($options['email_reply']) || empty($options['email_reply']) || $options['email_reply'] == null) {
				$options['email_reply'] = __('Thank you for your donation!', 'fpdomain');
				update_option('easy_fundraisers_newcol_settings_arraykey', $options);
			}
			if (!isset($options['email_reply_info']) || empty($options['email_reply_info']) || $options['email_reply_info'] == null) {
				$options['email_reply_info'] = __('This text explains how the email reply will be used', 'fpdomain');
				update_option('easy_fundraisers_newcol_settings_arraykey', $options);
			}
            if (!isset($options['default_checkbox_text']) || empty($options['default_checkbox_text']) || $options['default_checkbox_text'] == null) {
				$options['default_checkbox_text'] = __('I accept the <a href="#">Terms of Service</a>', 'fpdomain');
				update_option('easy_fundraisers_newcol_settings_arraykey', $options);
			}
            
            // Notices
            if (!isset($options['registration_text']) || empty($options['registration_text']) || $options['registration_text'] == null) {
				$options['registration_text'] = __('This is the form for creating a collection!', 'fpdomain');
				update_option('easy_fundraisers_newcol_settings_arraykey', $options);
			}
            if (!isset($options['created_text']) || empty($options['created_text']) || $options['created_text'] == null) {
				$options['created_text'] = __('Success, the collection was created and submitted for review!', 'fpdomain');
				update_option('easy_fundraisers_newcol_settings_arraykey', $options);
			}
		}
			
		public function easy_fundraisers_registerSettings() {

			$this->easy_fundraisers_addFirstSection();
			$this->easy_fundraisers_addSecondSection();

			// register_setting( $option_group, $option_name, $sanitize_callback )
			register_setting( 'newcol-settings-group', 'easy_fundraisers_newcol_settings_arraykey', array($this, 'easy_fundraisers_newcol_settings_validate') );
		}
        
        private function easy_fundraisers_addFirstSection() {
            // add_settings_section( $id, $title, $callback, $page )
			add_settings_section(
				'newcol_section',
				esc_html__('Form Settings', 'fpdomain'),
				array($this, 'easy_fundraisers_print_newcol_section_info'),
				'donation-plugin-newcol-group'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'default_category', 
				esc_html__('Default Category:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_default_category_setting'), 
				'donation-plugin-newcol-group', 
				'newcol_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'finish_date_limit', 
				esc_html__('Finish Date Limit:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_finish_date_setting'), 
				'donation-plugin-newcol-group', 
				'newcol_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'collection_name', 
				esc_html__('Default Collection Name:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_collection_name_setting'), 
				'donation-plugin-newcol-group', 
				'newcol_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'collection_desc', 
				esc_html__('Default Collection Description:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_collection_desc_setting'), 
				'donation-plugin-newcol-group', 
				'newcol_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'email_reply',
				esc_html__('Default E-mail Reply:', 'fpdomain'),
				array($this, 'easy_fundraisers_create_input_collection_email_setting'),
				'donation-plugin-newcol-group',
				'newcol_section'
			);
			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'email_reply_info',
				esc_html__('Default E-mail Reply Info:', 'fpdomain'),
				array($this, 'easy_fundraisers_create_input_collection_email_info_setting'),
				'donation-plugin-newcol-group',
				'newcol_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'default_checkbox_text', 
				esc_html__('Checkbox text:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_default_checkbox_text_setting'), 
				'donation-plugin-newcol-group', 
				'newcol_section'
			);
        }
        
        private function easy_fundraisers_addSecondSection() {
            // add_settings_section( $id, $title, $callback, $page )
			add_settings_section(
				'newcol_notices_section',
				esc_html__('Default notices', 'fpdomain'),
				array($this, 'easy_fundraisers_print_newcol_notices_section_info'),
				'donation-plugin-newcol-group'
			);
            
			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'registration_text', 
				esc_html__('Form Description:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_registration_text_setting'), 
				'donation-plugin-newcol-group', 
				'newcol_notices_section'
			);
            
			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'created_text', 
				esc_html__('Text on success:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_created_text_setting'), 
				'donation-plugin-newcol-group', 
				'newcol_notices_section'
			);
        }

		public function easy_fundraisers_print_newcol_section_info() {
			echo '<p>' .  esc_html__('Settings for the create collection form.', 'fpdomain') . '</p>';
		}

		public function easy_fundraisers_create_input_default_category_setting() {
			$options = get_option('easy_fundraisers_newcol_settings_arraykey');
            
            ?>
                <select name="easy_fundraisers_newcol_settings_arraykey[default_category]">
    			<?php
    				$terms = get_terms( array(
    					'taxonomy' => 'collectioncategory',
    					'hide_empty' => false,
    				));
    				foreach ( $terms as $term ) {
    					if ( $options["default_category"] == $term->slug ){
    						$selected_option = ' selected';
    					} else {
    						$selected_option = '';
    					}
    					echo '<option value="' . $term->slug . '" '.$selected_option.' >' . $term->name . '</option>';
    				}
    			?>
    			</select>
            <?php
            echo '<p>' . esc_html__( 'This is the default (selected) category in the new collection form.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_create_input_finish_date_setting() {
			$options = get_option('easy_fundraisers_newcol_settings_arraykey');
            $months = esc_html($options["finish_date_limit"]);
            ?>
                <input name="easy_fundraisers_newcol_settings_arraykey[finish_date_limit]" type="number" value="<?php echo($months); ?>" />
			<?php
			$finish_time = strtotime('+' . $months . ' months');
			echo ' (' . esc_html__('finish date limit:', 'fpdomain') . ' ' . date('Y', $finish_time) . '-' . date('m', $finish_time) . '-' . date('d', $finish_time) . ')';
            echo '<p>' . esc_html__( 'New collections will not have a finish date beyond this date.' ) .'</p>';
		}

		public function easy_fundraisers_create_input_collection_name_setting() {
			$options = get_option('easy_fundraisers_newcol_settings_arraykey');
            ?>
                <input type="text" name="easy_fundraisers_newcol_settings_arraykey[collection_name]" value="<?php echo esc_html($options["collection_name"]); ?>" />
			<?php
            echo '<p>' . esc_html__( 'This is the default input value in the form.' ) .'</p>';
		}

		public function easy_fundraisers_create_input_collection_desc_setting() {
			$options = get_option('easy_fundraisers_newcol_settings_arraykey');
            ?>
                <textarea name="easy_fundraisers_newcol_settings_arraykey[collection_desc]" rows="10" cols="80"><?php echo esc_html($options["collection_desc"]); ?></textarea>
			<?php
            echo '<p>' . esc_html__( 'This is the default input value in the form.' ) .'</p>';
		}

		public function easy_fundraisers_create_input_collection_email_setting() {
			$options = get_option('easy_fundraisers_newcol_settings_arraykey');
            ?>
                <textarea name="easy_fundraisers_newcol_settings_arraykey[email_reply]" rows="10" cols="80"><?php echo esc_html($options["email_reply"]); ?></textarea>
			<?php
            echo '<p>' . esc_html__( 'This is the default input value in the form for the thank you e-mail.' ) .'</p>';
		}

		public function easy_fundraisers_create_input_collection_email_info_setting() {
			$options = get_option('easy_fundraisers_newcol_settings_arraykey');
            ?>
                <textarea name="easy_fundraisers_newcol_settings_arraykey[email_reply_info]" rows="10" cols="80"><?php echo esc_html($options["email_reply_info"]); ?></textarea>
			<?php
            echo '<p>' . esc_html__( 'This is the default text in the form above the thank you e-mail.' ) .'</p>';
		}

		public function easy_fundraisers_create_input_default_checkbox_text_setting() {
			$options = get_option('easy_fundraisers_newcol_settings_arraykey');
            ?>
                <input type="text" name="easy_fundraisers_newcol_settings_arraykey[default_checkbox_text]" value="<?php echo esc_html($options["default_checkbox_text"]); ?>" />
			<?php
            echo '<p>' . esc_html__( 'This is the default checkbox text in the form.' ) .'</p>';
		}

		public function easy_fundraisers_print_newcol_notices_section_info() {
			echo '<p>' .  esc_html__('Settings for the form notices.', 'fpdomain') . '</p>';
		}

		public function easy_fundraisers_create_input_registration_text_setting() {
			$options = get_option('easy_fundraisers_newcol_settings_arraykey');
			?>
                <textarea name="easy_fundraisers_newcol_settings_arraykey[registration_text]" rows="10" cols="80"><?php echo esc_html($options["registration_text"]); ?></textarea>
            <?php
            echo '<p>' . esc_html__( 'This is the description text over the form.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_create_input_created_text_setting() {
			$options = get_option('easy_fundraisers_newcol_settings_arraykey');
			?>
                <textarea name="easy_fundraisers_newcol_settings_arraykey[created_text]" rows="10" cols="80"><?php echo esc_html($options["created_text"]); ?></textarea>
            <?php
            echo '<p>' . esc_html__( 'This is the text viewed after successful collection creation.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_newcol_settings_validate($arr_input) {
            $new_default_category = trim($arr_input['default_category']);
            $new_finish_date_limit = trim($arr_input['finish_date_limit']);
            $new_collection_name = trim($arr_input['collection_name']);
            $new_collection_desc = trim($arr_input['collection_desc']);
            $new_email_reply = trim($arr_input['email_reply']);
			$new_email_reply_info = trim($arr_input['email_reply_info']);
            $new_default_checkbox_text = trim($arr_input['default_checkbox_text']);
            $new_registration_text = trim($arr_input['registration_text']);
            $new_created_text = trim($arr_input['created_text']);
            $fails = false;
            
            $new_default_category = sanitize_text_field($new_default_category);
            $new_finish_date_limit = sanitize_text_field($new_finish_date_limit);
            $new_collection_name = sanitize_text_field($new_collection_name);
            $new_collection_desc = sanitize_text_field($new_collection_desc);
            $new_email_reply = sanitize_text_field($new_email_reply);
			$new_email_reply_info = wp_kses($new_email_reply_info, $easy_fundraisers_html_tags);
            $new_default_checkbox_text = wp_kses($new_default_checkbox_text, $easy_fundraisers_html_tags);
            $new_registration_text = wp_kses($new_registration_text, $easy_fundraisers_html_tags);
            $new_created_text = wp_kses($new_created_text, $easy_fundraisers_html_tags);
            
            $options['default_category'] = $new_default_category;
            
            if (!is_numeric($new_finish_date_limit) || intval($new_finish_date_limit) < 1) {
                add_settings_error('newcol_section', 'newcol_settings_finish_date_notice', esc_html__('The chosen finish date limit is invalid!', 'fpdomain'), 'error');
                $fails = true;
                $options['finish_date_limit'] = '24';
            } else {
                $options['finish_date_limit'] = $new_finish_date_limit;
            }
            
            $options['collection_name'] = $new_collection_name;
            $options['collection_desc'] = $new_collection_desc;
            $options['email_reply'] = $new_email_reply;
			$options['email_reply_info'] = $new_email_reply_info;
            $options['default_checkbox_text'] = $new_default_checkbox_text;
            $options['registration_text'] = $new_registration_text;
            $options['created_text'] = $new_created_text;
            
            if ($fails) {
                add_settings_error('newcol_section', 'newcol_settings_general_notice', esc_html__('Settings was saved with errors!', 'fpdomain'), 'error');
            } else {
                add_settings_error('newcol_section', 'newcol_settings_general_notice', esc_html__('Settings saved.', 'fpdomain'), 'updated');
            }
            
			return $options;
		}

    	public function easy_fundraisers_create_settings_page() {
            settings_errors('newcol_section');
        	?>
            <div class="wrap">
                <form method="post" action="options.php">
                <?php
            		// This prints out all hidden setting fields
            		// settings_fields( $option_group )
            		settings_fields( 'newcol-settings-group' );
            		// do_settings_sections( $page )
            		do_settings_sections( 'donation-plugin-newcol-group' );
                ?>
                <?php submit_button('Save Changes'); ?>
                </form>
            </div>
        	<?php
	   }
	}
}

?>
