<?php

/**
 * ARRAYKEY:
 * easy_fundraisers_general_settings_arraykey
 * 
 * ARRAYKEY-USE:
 * get_option('easy_fundraisers_general_settings_arraykey')
 * 
 * OPTIONS:
 * ENABLE NOTICES: 	enable_notices
 * E-MAIL INPUT:    admin_notices_email
 *
 * OPTIONS-USE:
 * $options['admin_notices_email']
**/

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('easy_fundraisers_general_settings')) {

	class easy_fundraisers_general_settings {

		public function __construct() {
		}
		
		public function easy_fundraisers_initSettings() {
			$options = get_option('easy_fundraisers_general_settings_arraykey');
			if (!isset($options['enable_notices']) || empty($options['enable_notices']) || $options['enable_notices'] == null) {
				$options['enable_notices'] = 'false';
				update_option('easy_fundraisers_general_settings_arraykey', $options);
			}
			if (!isset($options['admin_notices_email']) || empty($options['admin_notices_email']) || $options['admin_notices_email'] == null) {
				$options['admin_notices_email'] = 'admin@email.com';
				update_option('easy_fundraisers_general_settings_arraykey', $options);
			}
		}
			
		public function easy_fundraisers_registerSettings() {

			// add_settings_section( $id, $title, $callback, $page )
			add_settings_section(
				'admin_notices_section',
				esc_html__('Administrator notifications', 'fpdomain'),
				array($this, 'easy_fundraisers_print_admin_notices_section_info'),
				'donation-plugin-general-group'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'admin_notices_email_checkbox', 
				esc_html__('Enable notifications:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_admin_email_checkbox_setting'), 
				'donation-plugin-general-group', 
				'admin_notices_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'admin_notices_email', 
				esc_html__('Administrator E-mail:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_admin_email_setting'), 
				'donation-plugin-general-group', 
				'admin_notices_section'
			);

			// register_setting( $option_group, $option_name, $sanitize_callback )
			register_setting( 'general-settings-group', 'easy_fundraisers_general_settings_arraykey', array($this, 'easy_fundraisers_general_settings_validate') );
		}

		public function easy_fundraisers_print_admin_notices_section_info() {
			echo '<p>' .  esc_html__('Settings for administrator notifications.', 'fpdomain') . '</p>';
		}

		public function easy_fundraisers_create_input_admin_email_checkbox_setting() {
			$options = get_option('easy_fundraisers_general_settings_arraykey');
            
            if ($options['enable_notices'] == 'true') {
				echo '<input type="checkbox" name="easy_fundraisers_general_settings_arraykey[enable_notices]" value="true" checked />';
			} else {
				echo '<input type="checkbox" name="easy_fundraisers_general_settings_arraykey[enable_notices]" value="true" />';
			}
            echo '<p>' . esc_html__( 'Enable this option to receive administrator notifications via e-mail.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_create_input_admin_email_setting() {
			$options = get_option('easy_fundraisers_general_settings_arraykey');
			?>
                <input type="text" name="easy_fundraisers_general_settings_arraykey[admin_notices_email]" value="<?php echo esc_html($options['admin_notices_email']); ?>" />
            <?php
            echo '<p>' . esc_html__( 'Enter the e-mail to use for the administrator notifications.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_general_settings_validate($arr_input) {
            $new_enable_notices = trim($arr_input['enable_notices']);
            $new_admin_notices_email = trim($arr_input['admin_notices_email']);
            
            $new_enable_notices = sanitize_text_field($new_enable_notices);
            $new_admin_notices_email = sanitize_text_field($new_admin_notices_email);
            
            $options = get_option('easy_fundraisers_general_settings_arraykey');
            $fails = false;
            
            // Checkbox == null when unchecked
            if (!isset($new_enable_notices) || empty($new_enable_notices) || $new_enable_notices == null) {
                $new_enable_notices = 'false';
            }
            
            $options['enable_notices'] = $new_enable_notices;
            
            if (!isset($new_admin_notices_email) ||
                empty($new_admin_notices_email) ||
                strlen($new_admin_notices_email) < 3 ||
                strlen($new_admin_notices_email) > 100 ||
                !filter_var($new_admin_notices_email, FILTER_VALIDATE_EMAIL)) {
                add_settings_error('admin_notices_section', 'admin_notices_email_notice', esc_html__('The chosen administrator e-mail is invalid!', 'fpdomain'), 'error');
                $fails = true;
            } else {
                $options['admin_notices_email'] = $new_admin_notices_email;
            }
            
            if ($fails) {
                add_settings_error('admin_notices_section', 'admin_notices_general_notice', esc_html__('Settings was saved with errors!', 'fpdomain'), 'error');
            } else {
                add_settings_error('admin_notices_section', 'admin_notices_general_notice', esc_html__('Settings saved.', 'fpdomain'), 'updated');
            }
          
			return $options;
		}

    	public function easy_fundraisers_create_settings_page() {
            settings_errors('admin_notices_section');
        	?>
            <div class="wrap">
                <form method="post" action="options.php">
                <?php
            		// This prints out all hidden setting fields
            		// settings_fields( $option_group )
            		settings_fields( 'general-settings-group' );
            		// do_settings_sections( $page )
            		do_settings_sections( 'donation-plugin-general-group' );
                ?>
                <?php submit_button('Save Changes'); ?>
                </form>
            </div>
        	<?php
	   }
	}
}

?>
