<?php

/**
 * ARRAYKEY:
 * easy_fundraisers_email_settings_arraykey
 *
 * ARRAYKEY-USE:
 * get_option('easy_fundraisers_email_settings_arraykey')
 *
 * OPTIONS:
 * ENABLE SMTP:             enable_smtp
 * SMTP USER:               smtp_username
 * SMTP PASS:               smtp_password
 * SMTP HOST:               smtp_host
 * SMTP PORT:               smtp_port
 * FROM NAME:				smtp_from_name
 * REPLY NEW COL:           email_reply_new_col
 * REPLY ACCACCEPTED COL:   email_reply_accepted_col
 * REPLY REJECTED COL:      email_reply_rejected_col
 *
 * REPLY FOOTER THANKS:     email_reply_thanks_footer
 * REPLY FOOTER GENERAL:	email_reply_general_footer
 * OPTIONS-USE:
 * $options['enable_smtp']
**/

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('easy_fundraisers_email_settings')) {

	class easy_fundraisers_email_settings {

		public function __construct() {
		}

        public function easy_fundraisers_initSettings() {
			$options = get_option('easy_fundraisers_email_settings_arraykey');

            // Settings
            if (!isset($options['enable_smtp']) || empty($options['enable_smtp']) || $options['enable_smtp'] == null) {
				$options['enable_smtp'] = 'false';
				update_option('easy_fundraisers_email_settings_arraykey', $options);
			}
            if (!isset($options['smtp_username']) || empty($options['smtp_username']) || $options['smtp_username'] == null) {
				$options['smtp_username'] = 'admin@email.com';
				update_option('easy_fundraisers_email_settings_arraykey', $options);
			}
            if (!isset($options['smtp_password']) || empty($options['smtp_password']) || $options['smtp_password'] == null) {
				$options['smtp_password'] = 'password';
				update_option('easy_fundraisers_email_settings_arraykey', $options);
			}
            if (!isset($options['smtp_host']) || empty($options['smtp_host']) || $options['smtp_host'] == null) {
				$options['smtp_host'] = 'smtp.google.com';
				update_option('easy_fundraisers_email_settings_arraykey', $options);
			}
            if (!isset($options['smtp_port']) || empty($options['smtp_port']) || $options['smtp_port'] == null) {
				$options['smtp_port'] = '587';
				update_option('easy_fundraisers_email_settings_arraykey', $options);
			}
			if (!isset($options['smtp_from_name']) || empty($options['smtp_from_name']) || $options['smtp_from_name'] == null) {
				$options['smtp_from_name'] = 'Organisation Name';
				update_option('easy_fundraisers_email_settings_arraykey', $options);
			}

            // Responses
            if (!isset($options['email_reply_new_col']) || empty($options['email_reply_new_col']) || $options['email_reply_new_col'] == null) {
				$options['email_reply_new_col'] = __('New collection registered', 'fpdomain');
				update_option('easy_fundraisers_email_settings_arraykey', $options);
			}
            if (!isset($options['email_reply_accepted_col']) || empty($options['email_reply_accepted_col']) || $options['email_reply_accepted_col'] == null) {
				$options['email_reply_accepted_col'] = __('Collection accepted', 'fpdomain');
				update_option('easy_fundraisers_email_settings_arraykey', $options);
			}
            if (!isset($options['email_reply_rejected_col']) || empty($options['email_reply_rejected_col']) || $options['email_reply_rejected_col'] == null) {
				$options['email_reply_rejected_col'] = __('Collection rejected', 'fpdomain');
				update_option('easy_fundraisers_email_settings_arraykey', $options);
			}
            if (!isset($options['email_reply_thanks_footer']) || empty($options['email_reply_thanks_footer']) || $options['email_reply_thanks_footer'] == null) {
				$options['email_reply_thanks_footer'] = __('Thank you for donating to our organisation!', 'fpdomain');
				update_option('easy_fundraisers_email_settings_arraykey', $options);
			}
            if (!isset($options['email_reply_general_footer']) || empty($options['email_reply_general_footer']) || $options['email_reply_general_footer'] == null) {
				$options['email_reply_general_footer'] = __('This is a general footer that is attached to every email that is sent', 'fpdomain');
				update_option('easy_fundraisers_email_settings_arraykey', $options);
			}
		}

		public function easy_fundraisers_registerSettings() {

			$this->easy_fundraisers_addFirstSection();
			$this->easy_fundraisers_addSecondSection();

			// register_setting( $option_group, $option_name, $sanitize_callback )
			register_setting( 'email-settings-group', 'easy_fundraisers_email_settings_arraykey', array($this, 'easy_fundraisers_email_settings_validate') );
		}

        private function easy_fundraisers_addFirstSection() {
            // add_settings_section( $id, $title, $callback, $page )
			add_settings_section(
				'mail_server_section',
				esc_html__('SMTP Settings', 'fpdomain'),
				array($this, 'easy_fundraisers_print_mail_server_section_info'),
				'donation-plugin-email-group'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'smtp_email_checkbox',
				esc_html__('Enable mail server:', 'fpdomain'),
				array($this, 'easy_fundraisers_create_input_smtp_checkbox_setting'),
				'donation-plugin-email-group',
				'mail_server_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'smtp_username',
				esc_html__('E-mail/Username:', 'fpdomain'),
				array($this, 'easy_fundraisers_create_input_smtp_username_setting'),
				'donation-plugin-email-group',
				'mail_server_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'smtp_password',
				esc_html__('Password:', 'fpdomain'),
				array($this, 'easy_fundraisers_create_input_smtp_password_setting'),
				'donation-plugin-email-group',
				'mail_server_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'smtp_host',
				esc_html__('Host:', 'fpdomain'),
				array($this, 'easy_fundraisers_create_input_smtp_host_setting'),
				'donation-plugin-email-group',
				'mail_server_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'smtp_port',
				esc_html__('Port:', 'fpdomain'),
				array($this, 'easy_fundraisers_create_input_smtp_port_setting'),
				'donation-plugin-email-group',
				'mail_server_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'smtp_from_name',
				esc_html__('From Name:', 'fpdomain'),
				array($this, 'easy_fundraisers_create_input_smtp_from_name_setting'),
				'donation-plugin-email-group',
				'mail_server_section'
			);
        }

        private function easy_fundraisers_addSecondSection() {
            // add_settings_section( $id, $title, $callback, $page )
			add_settings_section(
				'email_response_section',
				esc_html__('E-mail Responses', 'fpdomain'),
				array($this, 'easy_fundraisers_print_mail_response_section_info'),
				'donation-plugin-email-group'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'email_reply_new_col',
				esc_html__('New Collection:', 'fpdomain'),
				array($this, 'easy_fundraisers_create_input_mail_response_reply_new_setting'),
				'donation-plugin-email-group',
				'email_response_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'email_reply_accepted_col',
				esc_html__('Accepted Collection:', 'fpdomain'),
				array($this, 'easy_fundraisers_create_input_mail_response_reply_accepted_col_setting'),
				'donation-plugin-email-group',
				'email_response_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'email_reply_rejected_col',
				esc_html__('Rejected Collection:', 'fpdomain'),
				array($this, 'easy_fundraisers_create_input_mail_response_reply_rejected_col_setting'),
				'donation-plugin-email-group',
				'email_response_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'email_reply_thanks_footer',
				esc_html__('Thanks E-mail Footer:', 'fpdomain'),
				array($this, 'easy_fundraisers_create_input_mail_response_reply_thanks_footer_setting'),
				'donation-plugin-email-group',
				'email_response_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'email_reply_general_footer',
				esc_html__('General E-mail Footer:', 'fpdomain'),
				array($this, 'easy_fundraisers_create_input_mail_response_reply_general_footer_setting'),
				'donation-plugin-email-group',
				'email_response_section'
			);
        }

		public function easy_fundraisers_print_mail_server_section_info() {
			echo '<p>' .  esc_html__('Settings for the SMTP mail server, used for sending e-mails from plug-in.', 'fpdomain') . '</p>';
		}

		public function easy_fundraisers_create_input_smtp_checkbox_setting() {
			$options = get_option('easy_fundraisers_email_settings_arraykey');

            if ($options['enable_smtp'] == 'true') {
				echo '<input type="checkbox" name="easy_fundraisers_email_settings_arraykey[enable_smtp]" value="true" checked />';
			} else {
				echo '<input type="checkbox" name="easy_fundraisers_email_settings_arraykey[enable_smtp]" value="true" />';
			}
            echo '<p>' . esc_html__( 'Enable this option to send e-mail notifications via SMTP.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_create_input_smtp_username_setting() {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			?>
                <input type="text" name="easy_fundraisers_email_settings_arraykey[smtp_username]" value="<?php echo esc_html($options['smtp_username']); ?>" />
            <?php
		}

		public function easy_fundraisers_create_input_smtp_password_setting() {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			?>
                <input type="password" name="easy_fundraisers_email_settings_arraykey[smtp_password]" value="<?php echo esc_html($options['smtp_password']); ?>" />
            <?php
		}

		public function easy_fundraisers_create_input_smtp_host_setting() {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			?>
                <input type="text" name="easy_fundraisers_email_settings_arraykey[smtp_host]" value="<?php echo esc_html($options['smtp_host']); ?>" />
            <?php
		}

		public function easy_fundraisers_create_input_smtp_port_setting() {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			?>
                <input type="number" name="easy_fundraisers_email_settings_arraykey[smtp_port]" value="<?php echo esc_html($options['smtp_port']); ?>" />
            <?php
            echo '<p>' . esc_html__( 'Port 587 is usually used for SMTP.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_create_input_smtp_from_name_setting() {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			?>
                <input type="text" name="easy_fundraisers_email_settings_arraykey[smtp_from_name]" value="<?php echo esc_html($options['smtp_from_name']); ?>" />
            <?php
            echo '<p>' . esc_html__( 'From name is displayed as the sender of emails. It should be the name of the organisation.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_print_mail_response_section_info() {
			echo '<p>' .  esc_html__('Settings for the e-mail responses.', 'fpdomain') . '</p>';
		}

		public function easy_fundraisers_create_input_mail_response_reply_new_setting() {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			?>
                <textarea name="easy_fundraisers_email_settings_arraykey[email_reply_new_col]" rows="10" cols="80"><?php echo esc_html($options["email_reply_new_col"]); ?></textarea>
            <?php
            echo '<p>' . esc_html__( 'This e-mail body is sent to the creator of a new collection.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_create_input_mail_response_reply_accepted_col_setting() {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			?>
                <textarea name="easy_fundraisers_email_settings_arraykey[email_reply_accepted_col]" rows="10" cols="80"><?php echo esc_html($options["email_reply_accepted_col"]); ?></textarea>
            <?php
            echo '<p>' . esc_html__( 'This e-mail body is sent to the creator of a collection when it is accepted.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_create_input_mail_response_reply_rejected_col_setting() {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			?>
                <textarea name="easy_fundraisers_email_settings_arraykey[email_reply_rejected_col]" rows="10" cols="80"><?php echo esc_html($options["email_reply_rejected_col"]); ?></textarea>
            <?php
            echo '<p>' . esc_html__( 'This e-mail body is sent to the creator of a collection when it is rejected.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_create_input_mail_response_reply_thanks_footer_setting() {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			?>
                <textarea name="easy_fundraisers_email_settings_arraykey[email_reply_thanks_footer]" rows="10" cols="80"><?php echo esc_html($options["email_reply_thanks_footer"]); ?></textarea>
            <?php
            echo '<p>' . esc_html__( 'This e-mail footer is used when sending thanks e-mails from the plug-in. It should contain directions for the donator on how the contact you in case anything goes wrong.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_create_input_mail_response_reply_general_footer_setting() {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			?>
                <textarea name="easy_fundraisers_email_settings_arraykey[email_reply_general_footer]" rows="10" cols="80"><?php echo esc_html($options["email_reply_general_footer"]); ?></textarea>
            <?php
            echo '<p>' . esc_html__( 'This e-mail footer is used when sending e-mails other than thanks e-mails from the plug-in.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_email_settings_validate($arr_input) {
            $new_enable_smtp = trim($arr_input['enable_smtp']);
            $new_smtp_username = trim($arr_input['smtp_username']);
            $new_smtp_password = trim($arr_input['smtp_password']);
            $new_smtp_host = trim($arr_input['smtp_host']);
            $new_smtp_port = trim($arr_input['smtp_port']);
			$new_smtp_from_name = trim($arr_input['smtp_from_name']);
            $new_email_reply_new_col = trim($arr_input['email_reply_new_col']);
            $new_email_reply_accepted_col = trim($arr_input['email_reply_accepted_col']);
            $new_email_reply_rejected_col = trim($arr_input['email_reply_rejected_col']);
            $new_email_reply_footer_thanks = trim($arr_input['email_reply_thanks_footer']);
            $new_email_reply_footer_general = trim($arr_input['email_reply_general_footer']);
            
            $new_enable_smtp = sanitize_text_field($new_enable_smtp);
            $new_smtp_username = sanitize_email($new_smtp_username);
            $new_smtp_password = sanitize_text_field($new_smtp_password);
            $new_smtp_host = sanitize_text_field($new_smtp_host);
            $new_smtp_port = sanitize_text_field($new_smtp_port);
			$new_smtp_from_name = sanitize_text_field($new_smtp_from_name);
            $new_email_reply_new_col = wp_kses($new_email_reply_new_col, $easy_fundraisers_html_tags);
            $new_email_reply_accepted_col = wp_kses($new_email_reply_accepted_col, $easy_fundraisers_html_tags);
            $new_email_reply_rejected_col = wp_kses($new_email_reply_rejected_col, $easy_fundraisers_html_tags);
            $new_email_reply_footer_thanks = wp_kses($new_email_reply_footer_thanks, $easy_fundraisers_html_tags);
            $new_email_reply_footer_general = wp_kses($new_email_reply_footer_general, $easy_fundraisers_html_tags);
            
            $options = get_option('easy_fundraisers_email_settings_arraykey');

            // Checkbox == null when unchecked
            if (!isset($new_enable_smtp) || empty($new_enable_smtp) || $new_enable_smtp == null) {
                $new_enable_smtp = 'false';
            }

            $options['enable_smtp'] = $new_enable_smtp;
            $options['smtp_username'] = $new_smtp_username;
            $options['smtp_password'] = $new_smtp_password;
            $options['smtp_host'] = $new_smtp_host;
            $options['smtp_port'] = $new_smtp_port;
			$options['smtp_from_name'] = $new_smtp_from_name;
            $options['email_reply_new_col'] = $new_email_reply_new_col;
            $options['email_reply_accepted_col'] = $new_email_reply_accepted_col;
            $options['email_reply_rejected_col'] = $new_email_reply_rejected_col;
            $options['email_reply_thanks_footer'] = $new_email_reply_footer_thanks;
            $options['email_reply_general_footer'] = $new_email_reply_footer_general;

            add_settings_error('mail_server_section', 'mail_settings_general_notice', __('Settings saved.', 'fpdomain'), 'updated');

			return $options;
		}

    	public function easy_fundraisers_create_settings_page() {
            settings_errors('mail_server_section');
        	?>
            <div class="wrap">
                <form method="post" action="options.php">
                <?php
            		// This prints out all hidden setting fields
            		// settings_fields( $option_group )
            		settings_fields( 'email-settings-group' );
            		// do_settings_sections( $page )
            		do_settings_sections( 'donation-plugin-email-group' );
                ?>
                <?php submit_button('Save Changes'); ?>
                </form>
            </div>
        	<?php
	   }
	}
}

?>
