<?php

/**
 * ARRAYKEY:
 * easy_fundraisers_archive_settings_arraykey
 * 
 * ARRAYKEY-USE:
 * get_option('easy_fundraisers_archive_settings_arraykey')
 * 
 * OPTIONS:
 * ARCHIVE TITLE:           archive_title
 * ARCHIVE DESC:            archive_desc
 * ARCHIVE LINK:            archive_link
 * 
 * OPTIONS-USE:
 * $options['archive_title']
**/

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('easy_fundraisers_archive_settings')) {

	class easy_fundraisers_archive_settings {

		public function __construct() {
		}
        
        public function easy_fundraisers_initSettings() {
			$options = get_option('easy_fundraisers_archive_settings_arraykey');
            
            // Settings
            if (!isset($options['archive_title']) || empty($options['archive_title']) || $options['archive_title'] == null) {
				$options['archive_title'] = __('All collections:', 'fpdomain');
				update_option('easy_fundraisers_archive_settings_arraykey', $options);
			}
            if (!isset($options['archive_desc']) || empty($options['archive_desc']) || $options['archive_desc'] == null) {
				$options['archive_desc'] = __('This is the collection archive.', 'fpdomain');
				update_option('easy_fundraisers_archive_settings_arraykey', $options);
			}
            if (!isset($options['archive_link']) || empty($options['archive_link']) || $options['archive_link'] == null) {
				$options['archive_link'] = '#';
				update_option('easy_fundraisers_archive_settings_arraykey', $options);
			}
		}
			
		public function easy_fundraisers_registerSettings() {

			$this->easy_fundraisers_addFirstSection();

			// register_setting( $option_group, $option_name, $sanitize_callback )
			register_setting( 'archive-settings-group', 'easy_fundraisers_archive_settings_arraykey', array($this, 'easy_fundraisers_archive_settings_validate') );
		}
        
        private function easy_fundraisers_addFirstSection() {
            // add_settings_section( $id, $title, $callback, $page )
			add_settings_section(
				'archive_server_section',
				esc_html__('Archive Settings', 'fpdomain'),
				array($this, 'easy_fundraisers_print_archive_section_info'),
				'donation-plugin-archive-group'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'archive_title', 
				esc_html__('Title:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_archive_title_setting'), 
				'donation-plugin-archive-group', 
				'archive_server_section'
			);
            
			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'archive_desc', 
				esc_html__('Description:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_archive_desc_setting'), 
				'donation-plugin-archive-group', 
				'archive_server_section'
			);
            
			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'archive_link', 
				esc_html__('Button Link:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_archive_link_setting'), 
				'donation-plugin-archive-group', 
				'archive_server_section'
			);
        }

		public function easy_fundraisers_print_archive_section_info() {
			echo '<p>' .  esc_html__('Settings for the collections archive.', 'fpdomain') . '</p>';
		}

		public function easy_fundraisers_create_input_archive_title_setting() {
			$options = get_option('easy_fundraisers_archive_settings_arraykey');
			?>
                <input type="text" name="easy_fundraisers_archive_settings_arraykey[archive_title]" value="<?php echo esc_html($options['archive_title']); ?>" />
            <?php
            echo '<p>' . esc_html__( 'This title is used on the collections archive page.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_create_input_archive_desc_setting() {
			$options = get_option('easy_fundraisers_archive_settings_arraykey');
			?>
                <textarea name="easy_fundraisers_archive_settings_arraykey[archive_desc]" rows="10" cols="80"><?php echo esc_html($options['archive_desc']); ?></textarea>
            <?php
            echo '<p>' . esc_html__( 'This description is used on the collections archive page, right below the title.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_create_input_archive_link_setting() {
			$options = get_option('easy_fundraisers_archive_settings_arraykey');
			?>
                <input type="text" name="easy_fundraisers_archive_settings_arraykey[archive_link]" value="<?php echo esc_html($options['archive_link']); ?>" />
            <?php
            echo '<p>' . esc_html__( 'This is the button link for creating a new collection.', 'fpdomain' ) .'</p>';
		}

		public function easy_fundraisers_archive_settings_validate($arr_input) {
            $new_archive_title = trim($arr_input['archive_title']);
            $new_archive_desc = trim($arr_input['archive_desc']);
            $new_archive_link = trim($arr_input['archive_link']);
            
            $new_archive_title = wp_kses($new_archive_title, $easy_fundraisers_html_tags);
            $new_archive_desc = wp_kses($new_archive_desc, $easy_fundraisers_html_tags);
            $new_archive_link = sanitize_text_field($new_archive_link);
            
            $options = get_option('easy_fundraisers_archive_settings_arraykey');
            
            $options['archive_title'] = $new_archive_title;
            $options['archive_desc'] = $new_archive_desc;
            $options['archive_link'] = $new_archive_link;
            
            add_settings_error('archive_server_section', 'archive_settings_general_notice', esc_html__('Settings saved.', 'fpdomain'), 'updated');
            
			return $options;
		}

    	public function easy_fundraisers_create_settings_page() {
            settings_errors('archive_server_section');
        	?>
            <div class="wrap">
                <form method="post" action="options.php">
                <?php
            		// This prints out all hidden setting fields
            		// settings_fields( $option_group )
            		settings_fields( 'archive-settings-group' );
            		// do_settings_sections( $page )
            		do_settings_sections( 'donation-plugin-archive-group' );
                ?>
                <?php submit_button('Save Changes'); ?>
                </form>
            </div>
        	<?php
	   }
	}
}

?>
