<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('easy_fundraisers_3colwidget_settings')) {

	class easy_fundraisers_3colwidget_settings {

		public function __construct() {
		}
		
		public function easy_fundraisers_initSettings() {
			$options = get_option('easy_fundraisers_3colwidget_settings_arraykey');
			if (!isset($options['sort_by']) || empty($options['sort_by']) || $options['sort_by'] == null) {
				$options['sort_by'] = 'recent';
				update_option('easy_fundraisers_3colwidget_settings_arraykey', $options);
			}
			if (!isset($options['widget_title']) || empty($options['widget_title']) || $options['widget_title'] == null) {
				$options['widget_title'] = __('Create Collection', 'fpdomain');
				update_option('easy_fundraisers_3colwidget_settings_arraykey', $options);
			}
			if (!isset($options['widget_image_link']) || empty($options['widget_image_link']) || $options['widget_image_link'] == null) {
				$options['widget_image_link'] = '#';
				update_option('easy_fundraisers_3colwidget_settings_arraykey', $options);
			}
			if (!isset($options['widget_link']) || empty($options['widget_link']) || $options['widget_link'] == null) {
				$options['widget_link'] = '#';
				update_option('easy_fundraisers_3colwidget_settings_arraykey', $options);
			}
			if (!isset($options['description']) || empty($options['description']) || $options['description'] == null) {
				$options['description'] = __('Click on this box to create a new collection!', 'fpdomain');
				update_option('easy_fundraisers_3colwidget_settings_arraykey', $options);
			}
		}
			
		public function easy_fundraisers_registerSettings() {

			// add_settings_section( $id, $title, $callback, $page )
			add_settings_section(
				'3colwidget_section',
				esc_html__('3 Column Widget Settings', 'fpdomain'),
				array($this, 'easy_fundraisers_print_3colwidget_section_info'),
				'donation-plugin-3colwidget-group'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'sort_by', 
				esc_html__('Sort by:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_sort_by_setting'), 
				'donation-plugin-3colwidget-group', 
				'3colwidget_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'widget_title', 
				esc_html__('Title:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_title_setting'), 
				'donation-plugin-3colwidget-group', 
				'3colwidget_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'widget_image_link', 
				esc_html__('Image Link:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_image_link_setting'), 
				'donation-plugin-3colwidget-group', 
				'3colwidget_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'widget_link', 
				esc_html__('Link:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_link_setting'), 
				'donation-plugin-3colwidget-group', 
				'3colwidget_section'
			);

			// add_settings_field( $id, $title, $callback, $page, $section, $args )
			add_settings_field(
				'description', 
				esc_html__('Description:', 'fpdomain'), 
				array($this, 'easy_fundraisers_create_input_descr_setting'), 
				'donation-plugin-3colwidget-group', 
				'3colwidget_section'
			);

			// register_setting( $option_group, $option_name, $sanitize_callback )
			register_setting( '3colwidget-settings-group', 'easy_fundraisers_3colwidget_settings_arraykey', array($this, 'easy_fundraisers_3colwidget_settings_validate') );
		}

		public function easy_fundraisers_print_3colwidget_section_info() {
			echo '<p>' .  esc_html__('Settings for PayEx.', 'fpdomain') . '</p>';
		}

		public function easy_fundraisers_create_input_sort_by_setting() {
			$options = get_option('easy_fundraisers_3colwidget_settings_arraykey');
			?>
                <select name="easy_fundraisers_3colwidget_settings_arraykey[sort_by]">
					<option value="recent" <?php if ($options['sort_by'] == 'recent') echo 'selected'; ?>>Recent Collections</option>
					<option value="most" <?php if ($options['sort_by'] == 'most') echo 'selected'; ?>>Most Collected</option>
				</select>
                <p><?php esc_html_e( 'Sorting method for collections displayed by the widget.', 'fpdomain' ); ?></p>
            <?php
		}

		public function easy_fundraisers_create_input_title_setting() {
			$options = get_option('easy_fundraisers_3colwidget_settings_arraykey');
			?>
                <input type="text" name="easy_fundraisers_3colwidget_settings_arraykey[widget_title]" value="<?php echo wp_kses($options['widget_title'], $easy_fundraisers_html_tags); ?>" />
                <p><?php esc_html_e( 'Title for the third column.', 'fpdomain' ); ?></p>
            <?php
		}

		public function easy_fundraisers_create_input_image_link_setting() {
			$options = get_option('easy_fundraisers_3colwidget_settings_arraykey');
			?>
                <input type="text" name="easy_fundraisers_3colwidget_settings_arraykey[widget_image_link]" value="<?php echo esc_html($options['widget_image_link']); ?>" />
                <p><?php esc_html_e( 'Link to the image for the third column.', 'fpdomain' ); ?></p>
            <?php
		}

		public function easy_fundraisers_create_input_link_setting() {
			$options = get_option('easy_fundraisers_3colwidget_settings_arraykey');
			?>
                <input type="text" name="easy_fundraisers_3colwidget_settings_arraykey[widget_link]" value="<?php echo esc_html($options['widget_link']); ?>" />
                <p><?php esc_html_e( 'Link for the third column.', 'fpdomain' ); ?></p>
            <?php
		}

		public function easy_fundraisers_create_input_descr_setting() {
			$options = get_option('easy_fundraisers_3colwidget_settings_arraykey');
			?>
				<textarea name="easy_fundraisers_3colwidget_settings_arraykey[description]" rows="10" cols="80"><?php echo esc_html($options['description']); ?></textarea>
                <p><?php esc_html_e( 'Description for the third column.', 'fpdomain' ); ?></p>
            <?php
		}

		public function easy_fundraisers_3colwidget_settings_validate($arr_input) {
            $new_sort_by = trim($arr_input['sort_by']);
            $new_widget_title = trim($arr_input['widget_title']);
            $new_widget_image_link = trim($arr_input['widget_image_link']);
            $new_widget_link = trim($arr_input['widget_link']);
            $new_description = trim($arr_input['description']);
            
            $new_sort_by = sanitize_text_field($new_sort_by);
            $new_widget_title = wp_kses($new_widget_title, $easy_fundraisers_html_tags);
            $new_widget_image_link = sanitize_text_field($new_widget_image_link);
            $new_widget_link = sanitize_text_field($new_widget_link);
            $new_description = wp_kses($new_description, $easy_fundraisers_html_tags);
            
            $options = get_option('easy_fundraisers_3colwidget_settings_arraykey');
            
			$options['sort_by'] = $new_sort_by;
			$options['widget_title'] = $new_widget_title;
			$options['widget_image_link'] = $new_widget_image_link;
			$options['widget_link'] = $new_widget_link;
			$options['description'] = $new_description;
            
            add_settings_error('3colwidget_section', '3colwidget_settings_general_notice', esc_html__('Settings saved.', 'fpdomain'), 'updated');
            
			return $options;
		}

    	public function easy_fundraisers_create_settings_page() {
            settings_errors('3colwidget_section');
        	?>
            <div class="wrap">
                <form method="post" action="options.php">
                <?php
            		// This prints out all hidden setting fields
            		// settings_fields( $option_group )
            		settings_fields( '3colwidget-settings-group' );
            		// do_settings_sections( $page )
            		do_settings_sections( 'donation-plugin-3colwidget-group' );
                ?>
                <?php submit_button('Save Changes'); ?>
                </form>
            </div>
        	<?php
	   }
	}
}

?>
