<?php

/**
* Plugin name: Easy Fundraisers
* Plugin URI: http://www.richarddahlgren.se/
* Description: A plugin for creating fundraisers
* Author: Richard Dahlgren, Micaela Carlsson, Kristoffer Johansson
* Author URI: http://www.richarddahlgren.se/
* Version: 0.1.1.2
* Text Domain: fpdomain
* Domain Path: /language
*/

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

include("includes/class-easy-fundraisers-activation.php");
include("includes/class-easy-fundraisers-deactivation.php");

if (!class_exists('easy_fundraisers')) {

	class easy_fundraisers {
		private static $easy_fundraisers_instance;

		public static function easy_fundraisers_get_instance() {
			if (self::$easy_fundraisers_instance == null) {
				self::$easy_fundraisers_instance = new easy_fundraisers();
			}

			return self::$easy_fundraisers_instance;
		}

		private function __construct() {
			$easy_fundraisers_activation = new easy_fundraisers_activation();
			$easy_fundraisers_activation->easy_fundraisers_activation_setup();

			$easy_fundraisers_deactivation = new easy_fundraisers_deactivation();
			$easy_fundraisers_deactivation->easy_fundraisers_deactivation_setup();
		}
	}
}

add_action( 'init', 'easy_fundraisers_load_textdomain' );

function easy_fundraisers_load_textdomain() {
	load_plugin_textdomain( 'fpdomain', false, dirname( plugin_basename( __FILE__ ) ) . '/language' ); 
}

add_action('plugins_loaded', array('easy_fundraisers', 'easy_fundraisers_get_instance'));

function easy_fundraisers_create_donation_table() {
	global $wpdb;
	$table_name = $wpdb->prefix . 'donations';
	$charset_collate = $wpdb->get_charset_collate();

	$sql = "CREATE TABLE $table_name (
		id bigint(20) NOT NULL AUTO_INCREMENT,
		collection_id bigint(20) NOT NULL,
		donation_date datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		donor_name varchar(64) NOT NULL,
		donor_email varchar(64) NOT NULL,
		donation_amount int(11) NOT NULL,
		donation_status varchar(32) NOT NULL DEFAULT 'initiated',
		transaction_number varchar(64) NOT NULL DEFAULT '',
		PRIMARY KEY  (id),
		KEY collection_id (collection_id),
		KEY donation_date (donation_date)
	) $charset_collate;";

	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
	dbDelta( $sql );
}

function easy_fundraisers_create_api_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'donations_api';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
		id bigint(20) NOT NULL AUTO_INCREMENT,
		email text NOT NULL,
		authkey text NOT NULL,
		created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
		PRIMARY KEY (id)
	) $charset_collate;";

    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
    dbDelta( $sql );
}

register_activation_hook( __FILE__, 'easy_fundraisers_create_donation_table' );
register_activation_hook( __FILE__, 'easy_fundraisers_create_api_table' );

?>
