<?php

class Queries {

	public function getCollectionTitle($table_posts, $id) {
		$sql = "SELECT post_title
				FROM $table_posts
				WHERE id = '$id'";
		return $sql;
	}

    public function getGeneralCollectionInformation($table_posts, $table_users) {
        $sql_wp_posts = "SELECT t1.post_id, t1.post_title, t1.post_content, t1.display_name AS author, t1.post_status
                          FROM (
                            SELECT poststable.id AS post_id, post_title, post_status, post_content, post_type, display_name 
                            FROM $table_posts AS poststable 
                            LEFT JOIN $table_users AS userstable 
                            ON poststable.post_author = userstable.id) 
                            AS t1 
                            WHERE t1.post_type = 'collection'
                            AND (post_status = 'publish' OR post_status = 'pending' OR post_status = 'draft')";
        return $sql_wp_posts;
    }

    public function getSpecifiedCollectionInformation($table_posts, $table_users, $userId) {
        $sql_wp_posts = "SELECT t1.post_id, t1.post_title, t1.post_content, t1.display_name AS author, t1.post_status
                          FROM (
                            SELECT poststable.id AS post_id, post_author, post_title, post_status, post_content, post_type, display_name 
                            FROM $table_posts AS poststable 
                            LEFT JOIN $table_users AS userstable 
                            ON poststable.post_author = userstable.id) 
                            AS t1 
                            WHERE t1.post_type = 'collection'
                            AND (post_status = 'publish' OR post_status = 'pending' OR post_status = 'draft')
                            AND t1.post_author = '$userId'";
        return $sql_wp_posts;
    }

    public function isExistingCollection($table_posts, $cid, $userId) {
        $sql_wp_posts = "SELECT id
                            FROM $table_posts 
                            WHERE id = '$cid'
                            AND post_author = '$userId'
                            AND (post_status = 'publish' OR post_status = 'pending' OR post_status = 'draft')
                            AND post_type = 'collection'";
        return $sql_wp_posts;
    }

    public function getSpecifiedCollectionIds($table_posts, $userId) {
        $sql_wp_posts = "SELECT id AS post_id
                            FROM $table_posts
                            WHERE post_type = 'collection'
                            AND (post_status = 'publish' OR post_status = 'pending' OR post_status = 'draft')
                            AND post_author = '$userId'";
        return $sql_wp_posts;
    }

    public function getCollectionDonationSum($table_donations, $collection_id) {
        $sql_wp_donations = "SELECT (SUM(donation_amount) / 100) AS amount 
                              FROM $table_donations 
                              WHERE donation_status = 'successful' 
                              AND collection_id = " . $collection_id;
        return $sql_wp_donations;
    }

    public function getPayExArrayKey($table_options) {
        $sql_wp_options = "SELECT option_value AS settings 
                            FROM $table_options 
                            WHERE option_name = 'easy_fundraisers_payex_settings_arraykey'";
        return $sql_wp_options;
    }

    public function getEmailArrayKey($table_options) {
        $sql_wp_options = "SELECT option_value AS settings 
                            FROM $table_options 
                            WHERE option_name = 'easy_fundraisers_email_settings_arraykey'";
        return $sql_wp_options;
    }

    public function getCollectionMetaData($table_postmeta, $collection_id) {
        $sql_wp_postmeta = "SELECT join1.*, join2.thumbnail_id FROM
                            ((SELECT t1.post_id, t1.end_date, t2.target_amount 
                                FROM (
                                    (SELECT post_id, meta_value AS end_date 
                                    FROM $table_postmeta 
                                    WHERE meta_key = 'easy_fundraisers_end_date'
                                    AND post_id = " . $collection_id . ") 
                                    AS t1 
                                LEFT JOIN (
                                    SELECT post_id, meta_value AS target_amount 
                                    FROM $table_postmeta
                                    WHERE meta_key = 'easy_fundraisers_target_amount') 
                                    AS t2 
                                ON t1.post_id = t2.post_id)
                                ) AS join1
                             LEFT JOIN (
                                SELECT post_id, meta_value AS thumbnail_id 
                                FROM $table_postmeta 
                                WHERE meta_key = '_thumbnail_id') 
                                AS join2
                                ON join1.post_id = join2.post_id)";
        return $sql_wp_postmeta;
    }

    public function getPostImageByThumbnailId($table_posts, $thumbnail_id) {
        $sql_wp_posts = "SELECT guid AS post_img 
                            FROM $table_posts 
                            WHERE id = " . $thumbnail_id . "
                            AND post_type = 'attachment'";
        return $sql_wp_posts;
    }

    public function getUserPassword($table_users, $email) {
        $sql_wp_user = "SELECT user_pass 
                        FROM $table_users 
                        WHERE user_email = '$email'
                        LIMIT 1";
        return $sql_wp_user;
    }

    public function isExistingKey($table_api, $key) {
        $sql_wp_api = "SELECT email
                        FROM $table_api
                        WHERE authkey = '$key'
                        LIMIT 1";
        return $sql_wp_api;
    }

    public function isExistingAndValidKey($table_api, $key) {
        $sql_wp_api = "SELECT email
                        FROM $table_api
                        WHERE authkey = '$key'
                        AND created >= (NOW() - INTERVAL 1 DAY)
                        LIMIT 1";
        return $sql_wp_api;
    }

    public function deleteKey($table_api, $email) {
        $sql_wp_api = "DELETE FROM $table_api 
                        WHERE email = '$email'";
        return $sql_wp_api;
    }

    public function revokeKey($table_api, $key) {
        $sql_wp_api = "DELETE FROM $table_api 
                        WHERE authkey = '$key'";
        return $sql_wp_api;
    }

    public function insertKey($table_api, $email, $key) {
        $sql_wp_api = "INSERT INTO $table_api 
                      (email, authkey)
                      VALUES ('$email', '$key')";
        return $sql_wp_api;
    }

    public function getUserEmailByToken($table_api, $key) {
        $sql_wp_api = "SELECT email 
                        FROM $table_api 
                        WHERE authkey = '$key'
                        LIMIT 1";
        return $sql_wp_api;
    }

    public function getUserIdByToken($table_users, $table_api, $key) {
        $sql_wp_api = "SELECT t2.id
                        FROM ((
                            SELECT email 
                            FROM $table_api 
                            WHERE authkey = '$key')
                            AS t1
                            LEFT JOIN (
                                SELECT id, user_email 
                                FROM $table_users)
                                AS t2
                            ON t1.email = t2.user_email)
                        LIMIT 1";
        return $sql_wp_api;
    }

    public function updateCollectionTitle($table_posts, $column, $collection_id, $value) {
        $sql_wp_posts = "UPDATE $table_posts
                            SET $column = '$value'
                            WHERE id = '$collection_id'";
        return $sql_wp_posts;
    }

    public function updateCollectionEmailReply($table_postmeta, $collection_id, $value) {
        $sql_wp_posts = "UPDATE $table_postmeta
                            SET meta_value = '$value'
                            WHERE post_id = '$collection_id'
							AND meta_key = 'easy_fundraisers_email_reply'";
        return $sql_wp_posts;
    }


    public function updateCollectionStatus($table_posts, $collection_id, $status) {
        $sql_wp_posts = "UPDATE $table_posts
                            SET post_status = '$status'
                            WHERE id = '$collection_id'";
        return $sql_wp_posts;
    }

    public function getDonationsByCollectionId($table_donations, $collection_id, $sort) {
        $sql_wp_donations = "SELECT donation_date, (donation_amount / 100) AS amount
                                FROM $table_donations
                                WHERE collection_id = '$collection_id'
                                AND donation_status = 'successful'
                                ORDER BY donation_date $sort";
        return $sql_wp_donations;
    }

    public function getCollectionEmailReply($table_postmeta, $collection_id) {
        $sql_wp_posts = "SELECT meta_value
							FROM $table_postmeta
							WHERE post_id = '$collection_id'
							AND meta_key = 'easy_fundraisers_email_reply'";
        return $sql_wp_posts;
    }
}

?>