<?php

class Mailer {
	
	private function getEmail() {
        $table_options = Connector::$database->getPrefixedTable("options");
        $sql_wp_options = Connector::$queries->getEmailArrayKey($table_options);
        $object_wp_options = Connector::$database->selectObject($sql_wp_options);
        $email = "collections@starforlife.org";

        if ($object_wp_options) {
            $email = $object_wp_options->settings;
            if (!isset($email) || empty($email)) {
                $email = "collections@starforlife.org";
            } else {
                $arr_email = explode("{", $email)[1];
                $arr_email = substr($arr_email, 0, strlen($arr_email) - 1);
                $arr_email = explode(";", $arr_email);
                $email_found = false;

                foreach ($arr_email as $value) {
                    $value_split = explode(":", $value)[2];
                    if ($value_split == "\"smtp_username\"") {
                        $email_found = true;
                    } else if ($email_found) {
                        $email = substr($value_split, 1, strlen($value_split) - 2);
                        break;
                    }
                }
            }
        }

        return $email;
    }
	
	private function getPassword() {
        $table_options = Connector::$database->getPrefixedTable("options");
        $sql_wp_options = Connector::$queries->getEmailArrayKey($table_options);
        $object_wp_options = Connector::$database->selectObject($sql_wp_options);
        $password = "A&qPQ9ZSA&qPQ9ZS";

        if ($object_wp_options) {
            $password = $object_wp_options->settings;
            if (!isset($password) || empty($password)) {
                $password = "A&qPQ9ZSA&qPQ9ZS";
            } else {
                $arr_email = explode("{", $password)[1];
                $arr_email = substr($arr_email, 0, strlen($arr_email) - 1);
                $arr_email = explode(";", $arr_email);
                $password_found = false;

                foreach ($arr_email as $value) {
                    $value_split = explode(":", $value)[2];
                    if ($value_split == "\"smtp_password\"") {
                        $password_found = true;
                    } else if ($password_found) {
                        $password = substr($value_split, 1, strlen($value_split) - 2);
                        break;
                    }
                }
            }
        }

        return $password;
    }
	
	private function setupEmail($phpmailer) {
		$phpmailer->isSMTP();
		$phpmailer->SMTPAuth = true; // Force it to use Username and Password to authenticate
		$phpmailer->Host = "smtp.gmail.com";
		$phpmailer->Port = "587";
		
		$email = $this->getEmail();
		$phpmailer->Username = $email;
		$phpmailer->Password = $this->getPassword();
		$phpmailer->SMTPSecure = "tls"; // Choose SSL or TLS, if necessary for your server
		
		//echo $phpmailer->Username . ", " . $phpmailer->Password . "; " .  $this->getPassword();
		$phpmailer->setFrom("collections@starforlife.org", "Star for Life");
		//$phpmailer->addAddress("collections@starforlife.org");
		$phpmailer->addAddress($email);
		$phpmailer->isHTML(true);
	}

	private function dispatchEmail($phpmailer) {
		if (!$phpmailer->send()) {
			return false;
		} else {
			return true;
		}
	}
	
	public function sendStatusChangedEmail($collection_name, $value, $link) {
		$subject = "Collection status changed";
		$body = "The status has changed to \"" . $value . "\" for collection " . $collection_name . " (<a href=\"" . $link . "\">" . $link . "</a>).";
		$altBody = "The status has changed to \"" . $value . "\" for collection " . $collection_name . " (" . $link . ").";
		
		$phpmailer = new PHPMailer;
		$this->setupEmail($phpmailer);
		$phpmailer->Subject = $subject;
		$phpmailer->Body = $body;
		$phpmailer->AltBody = $altBody;
		
		$this->dispatchEmail($phpmailer);
	}
	
	public function sendCollectionChangedEmail($collection_name, $category, $link) {
		$subject = "Collection changed";
		$body = "The " . $category . " has changed for collection " . $collection_name . " (<a href=\"" . $link . "\">" . $link . "</a>).";
		$altBody = "The " . $category . " has changed for collection " . $collection_name . " (" . $link . ").";
		
		$phpmailer = new PHPMailer;
		$this->setupEmail($phpmailer);
		$phpmailer->Subject = $subject;
		$phpmailer->Body = $body;
		$phpmailer->AltBody = $altBody;
		
		$this->dispatchEmail($phpmailer);
	}
}

?>