<?php

require_once('authenticater.php');
require_once('collections.php');
require_once('mailer.php');

require_once('database.php');
require_once('queries.php');

require_once(dirname(dirname(dirname(dirname(dirname(__FILE__))))) . '/wp-config.php');
require_once(dirname(dirname(dirname(dirname(dirname(__FILE__))))) . '/wp-includes/class-phpass.php');
require_once(dirname(dirname(dirname(dirname(dirname(__FILE__))))) . '/wp-includes/class-phpmailer.php');
require_once(dirname(dirname(dirname(dirname(dirname(__FILE__))))) . '/wp-load.php');

header('Content-Type: text/xml');

class Connector {

    private $use_post_method = false;
    public static $database;
    public static $queries;

    function __construct() {
        if (!$this->determineMethod()) {
            echo "ERROR: Failed to determine method!";
        } else {
            if ($this->setupDatabase()) {
                $this->parseInput();
            }
        }
    }

    function __destruct() {
        self::$database->disconnect();
    }

    private function setupDatabase() {
        self::$database = new Database();
        self::$queries = new Queries();

        if (!self::$database->connect()) {
            die("Failed to connect!");
            return false;
        }
        return true;
    }

    /**
     * This method validates the input based on parameters.
     * @param $input
     * @param $min_length
     * @param $max_length
     * @param $numeric
     * @return bool
     */
    private function validateInput($input, $min_length, $max_length, $numeric) {
        if (!isset($input) || empty($input)) {
            return false;
        } else if (strlen($input) < $min_length) {
            return false;
        } else if (strlen($input) > $max_length) {
            return false;
        } else if ($numeric && !is_numeric($input)) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * This method determine the method to use.
     * @return bool
     */
    private function determineMethod() {
        $method = $_GET['method'];
        if ($this->validateInput($method, 1, 1, true)) {
            if ($method == 1) {
                $this->use_post_method = true;
            } else if ($method == 2) {
                $this->use_post_method = false;
            }
            return true;
        }
        return false;
    }

    /**
     * This method returns the value from either POST or GET.
     * @param $command
     * @return mixed
     */
    private function getInput($command) {
        return ($this->use_post_method) ? $_POST[$command] : $_GET[$command];
    }

    /**
     * This method parse the input to the API.
     */
    private function parseInput() {
        $authenticate = $this->getInput('auth');
        $logout = $this->getInput('logout');
        $generallist = $this->getInput('generallist');
        $mylist = $this->getInput('mylist');
        $edit = $this->getInput('edit');
        $dlist = $this->getInput('dlist');

        // Used to "force authenticate" a user, a new token is sent to the user
        if ($this->validateInput($authenticate, 1, 1, true) && $authenticate == 1) {
            $this->doForceAuthentication();

        // Used to print the general list, no authentication needed.
        // Not used
        } else if ($this->validateInput($logout, 1, 1, true) && $logout == 1) {
            $this->doLogOut();

        // Used to print the general list, no authentication needed.
        } else if ($this->validateInput($generallist, 1, 1, true) && $generallist == 1) {
            $this->doPrintGeneralList();

        // Used to print a user specific list, authentication needed.
        } else if ($this->validateInput($mylist, 1, 1, true) && $mylist == 1) {
            $this->doPrintSpecifiedList();

        // Used to edit a specific collection
        } else if ($this->validateInput($edit, 1, 1, true) && $edit == 1) {
            $this->doEdit();

        // Used to print donations of a collection
        } else if ($this->validateInput($dlist, 1, 1, true) && $dlist == 1) {
            $this->doPrintDonationList();
        }
    }

    /**
     * This method perform the force authentication.
     */
    private function doForceAuthentication() {
        $email = $this->getInput('email');
        $password = $this->getInput('pass');
        $class_authenticater = new Authenticater();
        $class_authenticater->authenticateForNewToken($email, $password);
    }

    /**
     * This method perform the force authentication.
     */
    private function doLogOut() {
        $key = $this->getInput('key');
        $class_authenticater = new Authenticater();
        $result = $class_authenticater->revokeKey($key);
        $xml = new SimpleXMLElement("<collections></collections>");
        $xml_response = $xml->addChild("response");
        if ($result === false) {
            $xml_response->addChild("status", "sysfail");
        } else {
            $xml_response->addChild("status", "success");
        }
        echo $xml->asXML();
    }

    /**
     * This method perform the general list printing.
     */
    private function doPrintGeneralList() {
        $class_collections = new Collections();
        $xml = new SimpleXMLElement("<collections></collections>");
        $class_collections->printList($xml, -1);
        echo $xml->asXML();
    }

    /**
     * This method perform the specified list printing.
     */
    private function doPrintSpecifiedList() {
        $xml = new SimpleXMLElement("<collections></collections>");
        $xml_response = $xml->addChild("response");

        $key = $this->getInput('key');
        $full = $this->getInput('full');
		$dlist = $this->getInput('dlist');
		$ereply = $this->getInput('ereply');
        $class_authenticater = new Authenticater();

        if (!$class_authenticater->authenticate($key)) {
            $xml_response->addChild("status", "failed");
        } else {
            $userId = $class_authenticater->getIdByKey($key);
            if (!$userId) {
                $xml_response->addChild("status", "sysfail");
            } else {
                $xml_response->addChild("status", "success");
                $class_collections = new Collections();
                if ($this->validateInput($full, 1, 1, true) && $full == 1) {
                    $class_collections->printList($xml, $userId);
                    //$class_collections->printList($xml, 3);// FOR TESTING !!!
                } else {
					$print_donations = ($this->validateInput($dlist, 1, 1, true) && $dlist == 1) ? true : false;
					$print_ereply = ($this->validateInput($ereply, 1, 1, true) && $ereply == 1) ? true : false;
					$class_collections->printIdList($xml, $userId, $print_donations, $print_ereply);
                    //$class_collections->printIdList($xml, 3);// FOR TESTING !!!
                }
            }
        }
        echo $xml->asXML();
    }

    private function doEdit() {
        $xml = new SimpleXMLElement("<collections></collections>");
        $xml_response = $xml->addChild("response");

        $key = $this->getInput('key');
        $collection_id = $this->getInput('cid');
        $action = $this->getInput('action');

        if ($this->validateInput($collection_id, 1, PHP_INT_MAX, true)) {
            $class_authenticater = new Authenticater();
            if (!$class_authenticater->authenticate($key)) {
                $xml_response->addChild("status", "failed");
            } else {
                $userId = $class_authenticater->getIdByKey($key);
                if (!$userId) {
                    $xml_response->addChild("status", "sysfail");
                } else {
                    $table_posts = Connector::$database->getPrefixedTable("posts");
                    $collection_id = Connector::$database->esc($collection_id);
                    $query = Connector::$queries->isExistingCollection($table_posts, $collection_id, $userId);
                    $exist = Connector::$database->isExistingEntry($query);
                    if (!$exist) {
                        $xml_response->addChild("status", "failed");
                    } else {
                        switch ($action) {
                            case "title":
                            {
                                $this->editPost($collection_id, "post_title", $xml_response);
                                break;
                            }
                            case "desc":
                            {
                                $this->editPost($collection_id, "post_content", $xml_response);
                                break;
                            }
							case "ereply":
							{
								$this->editEmailReply($collection_id, $xml_response);
								break;
							}
							case "status":
							{
								$this->setPostStatus($collection_id, $xml_response);
								break;
							}
                            default:
                            {
                                break;
                            }
                        }
                    }
                }
            }
        } else {
            $xml_response->addChild("status", "failed");
        }
        echo $xml->asXML();
    }

    private function setPostStatus($collection_id, $xml_response) {
		$value = Connector::$database->esc($this->getInput('value'));
		if (ctype_alnum($value)) {
			$table_posts = Connector::$database->getPrefixedTable("posts");
			$query = Connector::$queries->updateCollectionStatus($table_posts, $collection_id, $value);
			$result = Connector::$database->query($query);
			if ($result === false) {
				$xml_response->addChild("status", "failed");
			} else {
				$xml_response->addChild("status", "success");
				$mailer = new Mailer();
				$mailer->sendStatusChangedEmail($this->getCollectionName($collection_id), $value, get_permalink($collection_id));
			}
		} else {
            $xml_response->addChild("status", "failed");
        }
    }

    private function editPost($collection_id, $column, $xml_response) {
        $value = Connector::$database->esc($this->getInput('value'));
		$table_posts = Connector::$database->getPrefixedTable("posts");
		$query = Connector::$queries->updateCollectionTitle($table_posts, $column, $collection_id, $value);
		$result = Connector::$database->query($query);
		if ($result === false) {
			$xml_response->addChild("status", "failed");
		} else {
			$xml_response->addChild("status", "success");
			$email_val = "";
			if ($column == "post_title") {
				$email_val = "title";
			} else if ($column == "post_content") {
				$email_val = "description";
			}

			$mailer = new Mailer();
			$mailer->sendCollectionChangedEmail($this->getCollectionName($collection_id), $email_val, get_permalink($collection_id));
		}
    }
	
	private function editEmailReply($collection_id, $xml_response) {
        $value = Connector::$database->esc($this->getInput('value'));
		$table_posts = Connector::$database->getPrefixedTable("postmeta");
		$query = Connector::$queries->updateCollectionEmailReply($table_posts, $collection_id, $value);
		$result = Connector::$database->query($query);
		if ($result === false) {
			$xml_response->addChild("status", "failed");
		} else {
			$xml_response->addChild("status", "success");
			$mailer = new Mailer();
			$mailer->sendCollectionChangedEmail($this->getCollectionName($collection_id), "email reply", get_permalink($collection_id));
		}
    }

    private function doPrintDonationList() {
        $xml = new SimpleXMLElement("<collections></collections>");
        $xml_response = $xml->addChild("response");

        $collection_id = $this->getInput('cid');
        $sort = $this->getInput('sort');
        if ($this->validateInput($collection_id, 1, PHP_INT_MAX, true) &&
            ($sort == "ASC" || $sort == "DESC")) {

            $collection_id_esc = Connector::$database->esc($collection_id);
            $sort_esc = Connector::$database->esc($sort);

            $table_donations = Connector::$database->getPrefixedTable("donations");
            $sql_wp_posts = Connector::$queries->getDonationsByCollectionId($table_donations, $collection_id_esc, $sort_esc);
            $result = Connector::$database->select($sql_wp_posts);

            $xml_response->addChild("status", "success");

            if ($result) {
                $xml_collection = $xml->addChild("collection");
                foreach ($result as $row) {
                    $donation_date = htmlspecialchars($row['donation_date']);
                    $amount = htmlspecialchars($row['amount']);
                    $xml_donation = $xml_collection->addChild("donation");
                    $xml_donation->addChild("donation_date", $donation_date);
                    $xml_donation->addChild("amount", $amount);
                }
            }
        } else {
            $xml_response->addChild("status", "failed");
        }
        echo $xml->asXML();
    }
	
	private function getCollectionName($id) {
		$table_posts = Connector::$database->getPrefixedTable("posts");
		$sql_wp_posts = Connector::$queries->getCollectionTitle($table_posts, $id);
		$result = Connector::$database->selectObject($sql_wp_posts);
		if (!$result) {
			return "with id " . $id;
		} else {
			return $result->post_title;
		}
	}
}

$connector = new Connector();

?>