<?php

class Database {

    protected static $conn;

    /**
     * Establish a connection.
     * @return bool|mysqli
     */
    public function connect() {
        if (!isset(self::$conn)) {
           self::$conn = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
        }

        if (self::$conn === false) {
            return false;
        }
        return self::$conn;
    }

    /**
     * Close a connection.
     */
    public function disconnect() {
        if (isset(self::$conn)) self::$conn->close();
    }

    public function getPrefixedTable($table) {
        global $table_prefix;
        return $table_prefix . $table;
    }

    /**
     * Perform a query to the database.
     * @param $query
     * @return bool|mysqli_result
     */
    public function query($query) {
        $connection = $this->connect();
        $result = $connection->query($query);
        return $result;
    }

    /**
     * Return the result of a select.
     * @param $query
     * @return array|bool
     */
    public function select($query) {
        $rows = array();
        $result = $this->query($query);
        if ($result === false) {
            return false;
        }
        while ($row = $result->fetch_assoc()) {
            $rows[] = $row;
        }
        return $rows;
    }

    /**
     * Return the result of a select.
     * @param $query
     * @return bool|object|stdClass
     */
    public function selectObject($query) {
        $result = $this->query($query);
        if ($result === false) {
            return false;
        }
        return $result->fetch_object();
    }

    /**
     * Return true if the entry exist.
     * @param $query
     * @return bool
     */
    public function isExistingEntry($query) {
        $result = $this->query($query);
        if ($result->num_rows > 0) {
            return true;
        }
        return false;
    }

    /**
     * Return the last error.
     * @return string
     */
    public function error() {
        $connection = $this->connect();
        return $connection->error;
    }

    /**
     * Returns escaped value.
     * @param $value
     * @return string
     */
    public function esc($value) {
        $connection = $this->connect();
        return $connection->real_escape_string($value);
    }

    /**
     * Return escaped value in a quoted string.
     * @param $value
     * @return string
     */
    public function quote($value) {
        $connection = $this->connect();
        return "'" . $connection->real_escape_string($value) . "'";
    }
}

?>