<?php

class Collections {

    /**
     * This method print a list of the collections.
     */
    public function printList($xml, $userId) {
        $table_posts = Connector::$database->getPrefixedTable("posts");
        $table_users = Connector::$database->getPrefixedTable("users");
        $sql_wp_posts = null;

        if ($userId < 0) {
            $sql_wp_posts = Connector::$queries->getGeneralCollectionInformation($table_posts, $table_users);
        } else {
            $sql_wp_posts = Connector::$queries->getSpecifiedCollectionInformation($table_posts, $table_users, $userId);
        }

        $result = Connector::$database->select($sql_wp_posts);

        if ($result) {
            $collection_currency = $this->getCurrency();

            foreach ($result as $row) {
                $collection_id = htmlspecialchars($row['post_id']);
                $collection_title = htmlspecialchars($row['post_title']);
                $collection_description = htmlspecialchars($row['post_content']);
                $collection_started_by = htmlspecialchars($row['author']);
                $collection_status = htmlspecialchars($row['post_status']);

                $postmeta = $this->getPostMeta($collection_id);
                $collection_target_amount = $postmeta[0];
                $collection_ending_at = $postmeta[1];
                $collection_thumbnail_id = $postmeta[2];

                $collection_gathered_amount = $this->getGatheredAmount($collection_id);
                $post_image = $this->getFeaturedImage($collection_thumbnail_id);

                $xml_collection = $xml->addChild("collection");
                $xml_collection->addChild("id", $collection_id);
                $xml_collection->addChild("title", $collection_title);
                $xml_collection->addChild("description", $collection_description);
                $xml_collection->addChild("author", $collection_started_by);
                $xml_collection->addChild("status", $collection_status);
                $xml_collection->addChild("target", $collection_target_amount);
                $xml_collection->addChild("gathered", $collection_gathered_amount);
                $xml_collection->addChild("enddate", $collection_ending_at);
                $xml_collection->addChild("currency", $collection_currency);
                $xml_collection->addChild("image", htmlspecialchars($post_image));
                $xml_collection->addChild("link", htmlspecialchars(get_permalink($collection_id)));
            }
        }
    }

    /**
     * This method print a list of collection ids for a specific user.
     * @param $xml
     * @param $userId
     */
    public function printIdList($xml, $userId, $dlist, $ereply) {
        $table_posts = Connector::$database->getPrefixedTable("posts");
        $sql_wp_posts = Connector::$queries->getSpecifiedCollectionIds($table_posts, $userId);
        $result = Connector::$database->select($sql_wp_posts);
        if ($result) {
            foreach ($result as $row) {
                $collection_id = htmlspecialchars($row['post_id']);
                $xml_collection = $xml->addChild("collection");
                $xml_collection->addChild("id", $collection_id);
				if ($dlist) {
					$table_donations = Connector::$database->getPrefixedTable("donations");
					$sql_wp_posts_2 = Connector::$queries->getDonationsByCollectionId($table_donations, $collection_id, "ASC");
					$result2 = Connector::$database->select($sql_wp_posts_2);
					if ($result2) {
						foreach ($result2 as $row2) {
							$donation_date = htmlspecialchars($row2['donation_date']);
							$amount = htmlspecialchars($row2['amount']);
							$xml_donation = $xml_collection->addChild("donation");
							$xml_donation->addChild("donation_date", $donation_date);
							$xml_donation->addChild("amount", $amount);
						}
					}
				}
				if ($ereply) {
					$table_postmeta = Connector::$database->getPrefixedTable("postmeta");
					$sql_wp_posts_2 = Connector::$queries->getCollectionEmailReply($table_postmeta, $collection_id);
					$result2 = Connector::$database->selectObject($sql_wp_posts_2);
					if ($result2) {
						$email_reply = htmlspecialchars($result2->meta_value);
						$xml_collection->addChild("emailreply", $email_reply);
					}
				}
            }
        }
    }

    /**
     * This method return the currency for the collections.
     * @return bool|string
     */
    private function getCurrency() {
        $table_options = Connector::$database->getPrefixedTable("options");
        $sql_wp_options = Connector::$queries->getPayExArrayKey($table_options);
        $object_wp_options = Connector::$database->selectObject($sql_wp_options);
        $collection_currency = "USD";

        if ($object_wp_options) {
            $collection_currency = $object_wp_options->settings;
            if (!isset($collection_currency) || empty($collection_currency)) {
                $collection_currency = "USD";
            } else {
                $arr_currency = explode("{", $collection_currency)[1];
                $arr_currency = substr($arr_currency, 0, strlen($arr_currency) - 1);
                $arr_currency = explode(";", $arr_currency);
                $currency_found = false;

                foreach ($arr_currency as $value) {
                    $value_split = explode(":", $value)[2];
                    if ($value_split == "\"payex_currency\"") {
                        $currency_found = true;
                    } else if ($currency_found) {
                        $collection_currency = substr($value_split, 1, strlen($value_split) - 2);
                        break;
                    }
                }
            }
        }

        return $collection_currency;
    }

    /**
     * This method return the post metadata for a collection
     * by the given id.
     * @param $collection_id
     * @return array
     */
    private function getPostMeta($collection_id) {
        $ret = array();
        $table_postmeta = Connector::$database->getPrefixedTable("postmeta");
        $sql_wp_postmeta = Connector::$queries->getCollectionMetaData($table_postmeta, $collection_id);
        $object_wp_postmeta = Connector::$database->selectObject($sql_wp_postmeta);
        if ($object_wp_postmeta) {
            $collection_target_amount = htmlspecialchars($object_wp_postmeta->target_amount);
            $collection_ending_at = htmlspecialchars($object_wp_postmeta->end_date);
            $collection_thumbnail = htmlspecialchars($object_wp_postmeta->thumbnail_id);
            if (!isset($collection_target_amount) || empty($collection_target_amount)) {
                $collection_target_amount = 0;
            }
            if (!isset($collection_ending_at) || empty($collection_ending_at)) {
                $collection_ending_at = "2017-01-01";
            }
            if (!isset($collection_thumbnail) || empty($collection_thumbnail)) {
                $collection_thumbnail = "";
            }
            $ret[0] = $collection_target_amount;
            $ret[1] = $collection_ending_at;
            $ret[2] = $collection_thumbnail;
        }
        return $ret;
    }

    /**
     * This method return the gathered amount for a collection
     * by the given id.
     * @param $collection_id
     * @return int|string
     */
    private function getGatheredAmount($collection_id) {
        $table_donations = Connector::$database->getPrefixedTable("donations");
        $object_wp_donations = Connector::$database->selectObject(Connector::$queries->getCollectionDonationSum($table_donations, $collection_id));
        $collection_gathered_amount = 0;
        if ($object_wp_donations) {
            $collection_gathered_amount = htmlspecialchars($object_wp_donations->amount);
            if (!isset($collection_gathered_amount) || empty($collection_gathered_amount)) {
                $collection_gathered_amount = 0;
            }
        }
        return $collection_gathered_amount;
    }

    /**
     * This method return the gathered amount for a collection
     * by the given id.
     * @param $collection_id
     * @return int|string
     */
    private function getFeaturedImage($thumbnail_id) {
        $table_posts = Connector::$database->getPrefixedTable("posts");
        $object_wp_posts = Connector::$database->selectObject(Connector::$queries->getPostImageByThumbnailId($table_posts, $thumbnail_id));
        $image = "";
        if ($object_wp_posts) {
            $image = htmlspecialchars($object_wp_posts->post_img);
            if (!isset($image) || empty($image)) {
                $image = "";
            }
        }
        return $image;
    }
}

?>