<?php

class Authenticater {

    /**
     * Insert a new token for the given user email.
     * @param $email
     * @param $key
     * @return mixed
     */
    private function insertKey($email, $key) {
        $table_api = Connector::$database->getPrefixedTable("donations_api");
        $sql_wp_api = Connector::$queries->insertKey($table_api, $email, $key);
        $result = Connector::$database->query($sql_wp_api);
        return $result;
    }

    /**
     * Delete a token by a given user email.
     * @param $email
     * @return mixed
     */
    private function deleteKey($email) {
        $table_api = Connector::$database->getPrefixedTable("donations_api");
        $sql_wp_api = Connector::$queries->deleteKey($table_api, $email);
        $result = Connector::$database->query($sql_wp_api);
        return $result;
    }

    /**
     * Delete a token.
     * @param $key
     * @return mixed
     */
    public function revokeKey($key) {
        $key_esc = Connector::$database->esc($key);
        $table_api = Connector::$database->getPrefixedTable("donations_api");
        $sql_wp_api = Connector::$queries->revokeKey($table_api, $key_esc);
        $result = Connector::$database->query($sql_wp_api);
        return $result;
    }

    /**
     * Check if a token exist and is valid.
     * @param $key
     * @return mixed
     */
    public function authenticate($key) {
        $key_esc = Connector::$database->esc($key);
        $table_api = Connector::$database->getPrefixedTable("donations_api");
        $query = Connector::$queries->isExistingAndValidKey($table_api, $key_esc);
        return Connector::$database->isExistingEntry($query);
    }

    /**
     * Return the user email by a given token.
     * @param $key
     * @return bool
     */
    public function getEmailByKey($key) {
        $key_esc = Connector::$database->esc($key);
        $table_api = Connector::$database->getPrefixedTable("donations_api");
        $query = Connector::$queries->getUserEmailByToken($table_api, $key_esc);
        $result = Connector::$database->selectObject($query);
        if ($result === false) {
            return false;
        }
        return $result->email;
    }

    /**
     * Return the user id by a given token.
     * @param $key
     * @return bool
     */
    public function getIdByKey($key) {
        $key_esc = Connector::$database->esc($key);
        $table_api = Connector::$database->getPrefixedTable("donations_api");
        $table_users = Connector::$database->getPrefixedTable("users");
        $query = Connector::$queries->getUserIdByToken($table_users, $table_api, $key_esc);
        $result = Connector::$database->selectObject($query);
        if ($result === false) {
            return false;
        }
        return $result->id;
    }

    /**
     * Return a new random token.
     * @return int|string
     */
    private function getNewKey() {
        $key = 0;
        $table_api = Connector::$database->getPrefixedTable("donations_api");
        do {
            $key = sha1(microtime(true).mt_rand(10000,90000));
            $query = Connector::$queries->isExistingKey($table_api, $key);
        } while (Connector::$database->isExistingEntry($query));
        return $key;
    }

    /**
     * Authenticate a user by email and password, send new token.
     * @param $email
     * @param $password
     */
    public function authenticateForNewToken($email, $password) {
        $email_esc = Connector::$database->esc($email);
        $password_esc = Connector::$database->esc($password);
        $password_hashed = '';

        $table_users = Connector::$database->getPrefixedTable("users");
        $sql_wp_users = Connector::$queries->getUserPassword($table_users, $email_esc);
        $object_wp_users = Connector::$database->selectObject($sql_wp_users);

        $xml = new SimpleXMLElement("<collections></collections>");
        $xml_response = $xml->addChild("response");

        if ($object_wp_users) {
            $password_hashed = $object_wp_users->user_pass;

            $hasher = new PasswordHash(8, TRUE);
            if ($hasher->CheckPassword($password_esc, $password_hashed)) {
                $key = $this->getNewKey();
                $deleteResult = $this->deleteKey($email_esc);
                if ($deleteResult === false) {
                    $xml_response->addChild("status", "sysfail");
                } else {
                    $insertResult = $this->insertKey($email_esc, $key);
                    if ($insertResult === false) {
                        $xml_response->addChild("status", "sysfail");
                    } else {
                        $xml_response->addChild("status", "success");
                        $xml_response->addChild("key", $key);
                    }
                }
            } else {
                $xml_response->addChild("status", "failed");
            }
        } else {
            $xml_response->addChild("status", "failed");
        }

        echo $xml->asXML();
    }
}

?>