<?php

namespace Zamzamcoders\Easybundlefbt\Admin\Ajax;

class FbtAjax
{
    /**
     * efbtw_search_products function
     *
     * @return void
     */
    function efbtw_get_products_callback()
    {
        $product_args = array(
            'post_type'      => 'product',
            'post_status'    => 'publish',
            'posts_per_page' => -1,
            'order'          => 'DESC',
        );

        $product_query = new \WP_Query($product_args);

        $output = '<option value="">Select Product</option>'; // Default option

        if ($product_query->have_posts()) :
            while ($product_query->have_posts()) : $product_query->the_post();
                $product_id  = get_the_ID();
                $output .= '<option data-item="' . $product_id . '" value="' . get_the_ID() . '">' . get_the_title() . '</option>';
            endwhile;
            wp_reset_postdata();
        endif;

        echo wp_kses($output, 'efbtw_kses');
        wp_die();
    }

    function efbtw_tab_bundle_get_products_callback()
    {
        $product_args = array(
            'post_type'      => 'easyfbt_bundle',
            'post_status'    => 'publish',
            'posts_per_page' => -1,
            'order'          => 'DESC',
        );

        $product_query = new \WP_Query($product_args);

        $output = '<option value="">Select Bundle Product</option>'; // Default option

        if ($product_query->have_posts()) :
            while ($product_query->have_posts()) : $product_query->the_post();
                $product_id  = get_the_ID();

                $output .= '<option  data-item="' . $product_id . '" value="' . get_the_ID() . '">' . get_the_title() . '</option>';
            endwhile;
            wp_reset_postdata();
        endif;

        echo wp_kses($output, 'efbtw_kses');
        wp_die();
    }


    function efbtw_get_bundle_data()
    {
        $bundle_ids = isset($_POST['bundle_ids']) ?  $_POST['bundle_ids'] : [];


        $data = [];
        foreach ($bundle_ids as $bundle_id) {

            $products_datas = [];
            $bundle_group = get_post_meta($bundle_id, 'efbtw_bundle_item_group', true);

            if (is_array($bundle_group)) {
                foreach ($bundle_group as $item) {
                    $pid = absint($item['efbtw_select_product'] ?? 0);

                    if ($pid && !in_array($pid, array_column($products_datas, 'efbtw_select_product'))) {
                        $products_datas[] = get_the_title($pid);
                    }
                }
            }

            $data[] = [
                'id'       => $bundle_id,
                'title'    => get_the_title($bundle_id),
                'edit_link' => get_edit_post_link($bundle_id),
                'products' => $products_datas
            ];
        }

        update_option('efbtw_bundles_save_id', $data);

        //error_log("bundle product list" . print_r($products_datas, true));

        wp_send_json_success($data);
    }
}
