(function (window, document, $, undefined) {
  "use strict";

  $(document).ready(function ($) {
    function loadProductsDropdown(selectElement) {
      $.ajax({
        url: efbtw_localize_obj.ajax_url,
        type: "POST",
        data: {
          action: "efbtw_get_products",
        },
        success: function (response) {
          $(selectElement).html(response);
          $(selectElement).select2({
            placeholder: "Select Product",
            width: "100%",
          });
        },
      });
    }

    $("#fbt-bought-together-add-row").on("click", function (e) {
      e.preventDefault();

      var newRow = $(".empty-row")
        .clone()
        .removeClass("empty-row screen-reader-text")
        .insertBefore(".empty-row");

      var newSelect = newRow.find(".fbt-select-product2");
      loadProductsDropdown(newSelect);

      newRow.find("select, input").each(function () {
        var oldName = $(this).attr("name");
        if (oldName) {
          $(this).attr("name", oldName.replace("[]", "") + "[]");
        }
      });

      newRow.find('input[type="number"]').val("");
    });

    // Remove row button
    $(document).on("click", ".fbt-bought-together-remove-row", function (e) {
      e.preventDefault();
      $(this).closest("tr").remove();
    });
  });

  function loadbundleProductsDropdown(selectElement) {
    $.ajax({
      url: efbtw_localize_obj.ajax_url,
      type: "POST",
      data: {
        action: "tab_bundle_get_products_callback",
      },
      success: function (response) {
        console.log(response);
        $(selectElement).html(response);
        $(selectElement).select2({
          placeholder: "Select bundle Product",
          width: "100%",
        });
      },
    });
  }

  var bundleProductSelect = $(".efbtw-bought-together-controls").find(
    ".woobufbt-select-bundle-product"
  );
  loadbundleProductsDropdown(bundleProductSelect);

  /*add bundle list js*/

  jQuery(function ($) {
    $(document).on("change", ".efbtw-bundle-select-product", function (e) {
      let bundle_ids = $(this).val();

      console.log("bundle id", bundle_ids);
      let $tableBody = $(".efbtw-bundle-list-table tbody");

      if (!bundle_ids || bundle_ids.length === 0) {
        $tableBody.empty();
        return;
      }

      $.ajax({
        url: efbtw_localize_obj.ajax_url,
        method: "POST",
        data: {
          action: "efbtw_get_bundle_data",
          bundle_ids: bundle_ids,
        },
        success: function (response) {
          if (response.success) {
            $tableBody.empty();
            $.each(response.data, function (index, bundle) {
              let products = bundle.products
                .map(function (product) {
                  return product;
                })
                .join(" | ");

              let row = `
                <tr>
                    <td class="name column-name column-primary">
                        <strong>
                            <a href="${bundle.edit_link}">${bundle.title}</a>
                        </strong>
                        <div class="row-actions">
                            <span class="edit"><a href="${bundle.edit_link}">Edit</a> | </span>
                            <span class="delete"><a href="#" class="xts-delete-bundle" data-id="${bundle.id}">Delete</a></span>
                        </div>
                    </td>
                    <td class="products column-products">${products}</td>
                </tr>
            `;
              $tableBody.append(row);
            });
          }
        },
      });
    });
  });
})(window, document, jQuery);
