<?php
/**
 * Plugin Name: Easy Footer Menu
 * Description: Add a customizable footer navigation menu to WordPress sites.
 * Version: 1.0.0
 * Author: Kamrul Hasan
 * Author URI: https://facebook.com/uikamrul
 * Text Domain: easy-footer-menu
 * License: GPL2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package EasyFooterMenu
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define constants.
define( 'EASY_FOOTER_MENU_VERSION', '1.0.0' );
define( 'EASY_FOOTER_MENU_PLUGIN_FILE', __FILE__ );
define( 'EASY_FOOTER_MENU_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );

/**
 * Enqueue styles and scripts.
 */
function easy_footer_menu_enqueue_scripts() {
	wp_enqueue_style( 'easy-footer-menu-style', plugins_url( 'assets/css/style.css', __FILE__ ), array(), EASY_FOOTER_MENU_VERSION );
	wp_enqueue_script( 'feather-icons', plugins_url( 'assets/js/feather.min.js', __FILE__ ), array(), '4.28.0', true );
	wp_enqueue_script( 'easy-footer-menu-script', plugins_url( 'assets/js/script.js', __FILE__ ), array( 'jquery', 'feather-icons' ), EASY_FOOTER_MENU_VERSION, true );
}

add_action( 'wp_enqueue_scripts', 'easy_footer_menu_enqueue_scripts' );

/**
 * Add menu to footer.
 */
function easy_footer_menu_add_to_footer() {
	?>
	<nav class="efm-nav">
		<div class="efm-nav-box">
			<ul class="efm-nav-container">
				<?php
				$menu_items = get_option( 'easy_footer_menu_items', array() );
				if ( isset( $_SERVER['REQUEST_URI'] ) ) {
					$current_url = esc_url( home_url( sanitize_text_field( wp_unslash( $_SERVER['REQUEST_URI'] ) ) ) );
				}
				if ( ! empty( $menu_items ) ) {
					foreach ( $menu_items as $item ) {
						if ( ! empty( $item['name'] ) && ! empty( $item['link'] ) && ! empty( $item['feather_icon'] ) ) {
							// Remove server-side active class assignment as it's now handled by JavaScript
							?>
							<li class="efm-nav__item">
								<a href="<?php echo esc_url( $item['link'] ); ?>" class="efm-nav__item-link">
									<div class="efm-nav__item-icon">
										<i data-feather="<?php echo esc_attr( $item['feather_icon'] ); ?>"></i>
									</div>
									<span class="efm-nav__item-text"><?php echo esc_html( $item['name'] ); ?></span>
								</a>
							</li>
							<?php
						}
					}
				} else {
					echo '<li class="efm-nav__item">No menu items found.</li>';
				}
				?>
			</ul>
		</div>
	</nav>
	<?php
}

add_action( 'wp_footer', 'easy_footer_menu_add_to_footer' );

// Include settings page.
require_once EASY_FOOTER_MENU_PLUGIN_DIR . 'inc/settings.php';