const list = document.querySelectorAll(".efm-nav__item");
list.forEach((item) => {
  item.addEventListener("click", (e) => {
    e.preventDefault();
    const link = item.querySelector('a');
    const href = link.getAttribute('href');
    requestAnimationFrame(() => {
      list.forEach((item) => item.classList.remove("active", "initial-active"));
      item.classList.add("active");
      localStorage.setItem('activeMenuItem', href);
      // Navigate to the link after the animation frame
      window.location.href = href;
    });
  });
});

document.addEventListener('DOMContentLoaded', function() {
  const currentPath = window.location.pathname;
  const currentUrl = window.location.href;
  
  // First remove any existing active classes
  list.forEach((item) => {
    item.classList.remove("active");
    item.classList.remove("initial-active");
  });
  
  // Then add initial-active class to the current page only
  let activeItemFound = false;
  
  list.forEach((item) => {
    const link = item.querySelector('a');
    if (link) {
      const href = link.getAttribute('href');
      // Check if the link matches the current URL
      if (href === currentUrl || href === currentPath) {
        item.classList.add("initial-active");
        activeItemFound = true;
      }
    }
  });
  
  // If no active item was found based on URL, use localStorage as fallback
  if (!activeItemFound) {
    const activeMenuItem = localStorage.getItem('activeMenuItem');
    if (activeMenuItem) {
      list.forEach((item) => {
        const link = item.querySelector('a');
        if (link && link.getAttribute('href') === activeMenuItem) {
          item.classList.add("initial-active");
        }
      });
    }
  }
});

document.addEventListener('DOMContentLoaded', function() {
  if (typeof feather !== 'undefined') {
    feather.replace();
  }
});