jQuery(document).ready(function($) {
    var index = easyFooterMenuData.index;
    var featherIcons = easyFooterMenuData.featherIcons;

    function createCustomSelect(name, value) {
        var wrapper = $('<div class="custom-select-wrapper"></div>');
        var select = $('<select name="' + name + '" class="icon-select" style="display: none;"></select>');
        var customSelect = $('<div class="custom-select"></div>');
        var trigger = $('<div class="custom-select-trigger"></div>');
        var options = $('<div class="custom-options"></div>');

        trigger.html('<i data-feather="' + value + '" style="font-size: 24px;"></i><span>' + value + '</span>');

        $.each(featherIcons, function(i, icon) {
            var option = $('<option></option>').attr('value', icon).text(icon);
            if (icon === value) {
                option.attr('selected', 'selected');
            }
            select.append(option);

            var customOption = $('<span class="custom-option" data-value="' + icon + '"></span>');
            customOption.html('<i data-feather="' + icon + '" style="font-size: 24px;"></i><span>' + icon + '</span>');
            if (icon === value) {
                customOption.addClass('selected');
            }
            options.append(customOption);
        });

        customSelect.append(trigger).append(options);
        wrapper.append(select).append(customSelect);
        return wrapper;
    }

    function updateIconPreview(select) {
        var iconName = select.val();
        var wrapper = select.closest('.custom-select-wrapper');
        var trigger = wrapper.find('.custom-select-trigger');
        
        trigger.html('<i data-feather="' + iconName + '" style="font-size: 24px;"></i><span>' + iconName + '</span>');
        feather.replace({root: wrapper[0]});
        
        console.log('Icon updated to:', iconName); // Debug log
    }

    $('#add-menu-item').on('click', function() {
        var newRow = $('<tr></tr>');
        newRow.append('<td><input type="text" name="easy_footer_menu_items[' + index + '][name]" value="" /></td>');
        newRow.append('<td><input type="text" name="easy_footer_menu_items[' + index + '][link]" value="" /></td>');

        var featherCustomSelect = createCustomSelect('easy_footer_menu_items[' + index + '][feather_icon]', featherIcons[0]);
        newRow.append($('<td></td>').append(featherCustomSelect));

        newRow.append('<td><button type="button" class="remove-item button">Remove</button></td>');
        $('#menu-items-table tbody').append(newRow);
        index++;
        initCustomSelects();
        feather.replace({root: newRow[0]});
    });

    $(document).on('click', '.remove-item', function() {
        $(this).closest('tr').remove();
    });

    function initCustomSelects() {
        $('.custom-select-wrapper').each(function() {
            var wrapper = $(this);
            var select = wrapper.find('select');
            var customSelect = wrapper.find('.custom-select');
            var trigger = customSelect.find('.custom-select-trigger');
            var options = customSelect.find('.custom-options');

            trigger.off('click').on('click', function(event) {
                event.stopPropagation();
                $('.custom-select').not(customSelect).removeClass('opened');
                customSelect.toggleClass('opened');
            });

            options.find('.custom-option').off('click').on('click', function(event) {
                event.stopPropagation();
                var value = $(this).data('value');
                select.val(value).trigger('change');
                updateIconPreview(select);
                options.find('.custom-option').removeClass('selected');
                $(this).addClass('selected');
                customSelect.removeClass('opened');
                
                console.log('Option clicked:', value); // Debug log
            });

            // Add change event listener to the hidden select
            select.off('change').on('change', function() {
                updateIconPreview($(this));
            });
        });

        $(document).off('click.customSelect').on('click.customSelect', function() {
            $('.custom-select').removeClass('opened');
        });
    }

    // Initialize custom selects for existing items
    initCustomSelects();
    
    // Replace all Feather icons
    feather.replace();

    // Debug: Log when script is fully loaded
    console.log('Feather icon script loaded and initialized');
});