<?php
/**
 * Plugin Name: Easy Error Log
 *
 * @author            Sabbir Sam, devsabbirahmed
 * @copyright         2022- devsabbirahmed
 * @license           GPL-2.0-or-later
 *
 * @wordpress-plugin
 * Plugin Name: Easy Error Log
 * Plugin URI: https://github.com/sabbirsam/wp-error-log
 * Description: Experience hassle-free debugging by conveniently defining error modes and debug log constants within the config file. No need to delve into core files – simply toggle the settings. Logs PHP errors and access all errors in a single, user-friendly dashboard page, making it effortless to identify and rectify issues.
 * Version:           2.3.1
 * Requires at least: 5.9
 * Requires PHP:      5.6
 * Author:            sabbirsam
 * Author URI:        https://github.com/sabbirsam/
 * Text Domain:       easy-error-log
 * Domain Path: /languages/
 * License:           GPL v2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */

if ( ! function_exists( 'eel_fs' ) ) {
    // Create a helper function for easy SDK access.
    function eel_fs() {
        global $eel_fs;

        if ( ! isset( $eel_fs ) ) {
            // Include Freemius SDK.
            require_once dirname( __FILE__ ) . '/vendor/freemius/start.php';
            $eel_fs = fs_dynamic_init( array(
                'id'                  => '19488',
                'slug'                => 'easy-error-log',
                'type'                => 'plugin',
                'public_key'          => 'pk_abbb01e02f1ffb9a0ead4de79b26a',
                'is_premium'          => false,
				'has_premium_version' => true,
				'has_addons'          => false,
				'has_paid_plans'      => false,
				'is_org_compliant'    => true,
                'menu'                => array(
					'slug'           => 'easy_error_log',
					'first-path'     => 'tools.php?page=easy_error_log',
					'contact'    => false,
					'support'        => false,
					'account'        => false,
					'parent'         => array(
                        'slug' => 'tools.php',
                    ),
				),
            ) );
        }

        return $eel_fs;
    }

    // Init Freemius.
    eel_fs();
    // Signal that SDK was initiated.
    do_action( 'eel_fs_loaded' );
}

defined('ABSPATH') || die('Hey, what are you doing here? You silly human!');

if ( file_exists(__DIR__ . '/vendor/autoload.php') ) {
	require_once __DIR__ . '/vendor/autoload.php';
}

use EASYERLO\Inc\EASYERLO_Activate; //phpcs:ignore
use EASYERLO\Inc\EASYERLO_Deactivate;  //phpcs:ignore

define( 'EASY_ERROR_LOG_VERSION', '2.3.1' );
define( 'EASY_ERROR_LOG_FILE', __FILE__ );
define( 'EASY_ERROR_LOG_DIR_URL', plugin_dir_url( __FILE__ ) );


if ( ! class_exists('EASYERLO_Error') ) {
	/**
	 * Main class for Easy Error Log.
	 *
	 * @since 1.0.0
	 */
	class EASYERLO_Error {
		/**
		 * The single instance of the class.
		 *
		 * @var EASYERLO_Error
		 */
		private $base;

		/**
		 * The __construct of the class.
		 */
		public function __construct() {
			$this->base = new EASYERLO\Inc\EASYERLO_Base();
		}

		/**
		 * The init activate method of the class.
		 *
		 * @return void
		 */
		public function easyerlo_activate() {
			EASYERLO\Inc\EASYERLO_Activate::easyerlo_activate();
		}

		/**
		 * The init deactivate method of the class.
		 *
		 * @return void
		 */
		public function easyerlo_deactivate() {
			EASYERLO\Inc\EASYERLO_Deactivate::easyerlo_deactivate();
		}
	}

	/**
	 * The main instance of the class.
	 *
	 * @return EASYERLO_Error
	 */
	$err = new EASYERLO_Error();
	register_activation_hook(__FILE__, array( $err, 'easyerlo_activate' ));
	register_deactivation_hook(__FILE__, array( $err, 'easyerlo_deactivate' ));
}
