jQuery(document).ready(function($) {
	$('.color-field').wpColorPicker();
    console.log('Admin Notification Script Loaded');
    $('.custom-notice').on('click', '.notice-dismiss', function(e) {
        e.preventDefault();
        var $notice = $(this).closest('.custom-notice');
        var notification_id = $notice.attr('id').replace('easy-custom-admin-notification-', '');
        console.log('Dismiss button clicked for notification:', notification_id);
        
        $.ajax({
            url: easyCustomAdminNotification.ajax_url,
            type: 'POST',
            data: {
                action: 'easy_custom_admin_notification_dismiss',
                notification_id: notification_id,
                nonce: easyCustomAdminNotification.nonce
            },
            success: function(response) {
                console.log('Dismiss response:', response);
                if (response.success) {
                    $notice.slideUp('slow', function() {
                        $(this).remove();
                    });
                } else {
                    console.error('Failed to dismiss notification:', response);
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX error dismissing notification:', error);
            }
        });
    });
});