<?php
/*
* Plugin Name: Easy Code Highlighter
* Description: Resaltador de código con números de línea y función de copiar.
* Version: 1.00
* Author: ReorMadrid
* Author URI: https://www.reormadrid.com
* License: GPLv2 or later
* License URI: http://www.gnu.org/licenses/gpl-2.0.html
* Text Domain: easy-code-highlighter
* Domain Path: /languages
*/

/**
 * Ejemplo de como usar el shortcode para mostrar el código.
 * Example of how to use the shortcode to display the code.
 *
 * Uso:
 * [easycode]
 * <?php
 * echo "Hola, mundo!";
 * echo Hi, world!";
 * ?>
 * [/easycode]
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; 
	// Evita el acceso directo.
	// Avoid direct access.
}

function easy_hi_reormadrid_code_highlighter_copy_enqueue_assets() {
    // Se cargan los archivos localmente.
	// The files are loaded locally.
		   wp_enqueue_script(
        'prism',
        plugin_dir_url(__FILE__) . 'js/prism.min.js',
        array(),
        filemtime(plugin_dir_path(__FILE__) . 'js/prism.min.js'),
        true
    );
	
    wp_enqueue_style(
        'prism-tomorrow',
        plugin_dir_url(__FILE__) . 'css/prism-tomorrow.min.css',
        array(),
        filemtime(plugin_dir_path(__FILE__) . 'css/prism-tomorrow.min.css')
    );

 

    wp_register_script(
        'prism-markup-templating',
        plugin_dir_url(__FILE__) . 'js/prism-markup-templating.min.js',
        array('prism'),
        filemtime(plugin_dir_path(__FILE__) . 'js/prism-markup-templating.min.js'),
        true
    );

    wp_register_script(
        'prism-php',
        plugin_dir_url(__FILE__) . 'js/prism-php.min.js',
        array('prism'),
        filemtime(plugin_dir_path(__FILE__) . 'js/prism-php.min.js'),
        true
    );

    wp_register_script(
        'prism-javascript',
        plugin_dir_url(__FILE__) . 'js/prism-javascript.min.js',
        array('prism'),
        filemtime(plugin_dir_path(__FILE__) . 'js/prism-javascript.min.js'),
        true
    );

    wp_register_script(
        'prism-css',
        plugin_dir_url(__FILE__) . 'js/prism-css.min.js',
        array('prism'),
        filemtime(plugin_dir_path(__FILE__) . 'js/prism-css.min.js'),
        true
    );

    // Añadimos los estilos CSS.
	// We add the CSS styles.
    wp_enqueue_style(
        'code-highlighter-style',
        plugin_dir_url(__FILE__) . 'css/style.css',
        array(),
        filemtime(plugin_dir_path(__FILE__) . 'css/style.css')
    );
}
add_action('wp_enqueue_scripts', 'easy_hi_reormadrid_code_highlighter_copy_enqueue_assets');

// Detectamos el lenguaje de programación basado en el contenido del código
// We detect the programming language based on the content of the code.
function easy_hi_reormadrid_detect_language( $content ) {
    if ( preg_match( '/<\\?php/', $content ) ) {
        return 'php';
    }
    if ( preg_match( '/<[a-z][\\s\\S]*>/i', $content ) ) {
        return 'markup';
    }
    if ( preg_match( '/function\\s*\\(|let\\s+|const\\s+|var\\s+/', $content ) ) {
        return 'javascript';
    }
    if ( preg_match( '/\\{[^}]+\\}/', $content ) ) {
        return 'css';
    }
    return 'plaintext';
}

function easy_hi_reormadrid_code_highlighter_copy_shortcode( $atts, $content = null ) {
    $content = shortcode_unautop( $content );
    $content = str_replace( array( '<p>', '</p>', '<br>', '<br/>', '<br />' ), '', $content );
    $content = trim( $content );
	$content = htmlentities($content);
    $atts = shortcode_atts( array(
        'language' => '',
    ), $atts, 'code' );
    if ( empty( $atts['language'] ) ) {
        $atts['language'] = easy_hi_reormadrid_detect_language( $content );
    }
    if ( $atts['language'] === 'php' ) {
        wp_enqueue_script( 'prism-markup-templating' );
        wp_enqueue_script( 'prism-php' );
    } elseif ( $atts['language'] === 'javascript' ) {
        wp_enqueue_script( 'prism-javascript' );
    } elseif ( $atts['language'] === 'css' ) {
        wp_enqueue_script( 'prism-css' );
    }
    $content = shortcode_unautop( $content );
    $content = str_replace( array( '<p>', '</p>', '<br>', '<br/>', '<br />' ), '', $content );
    $content = trim( $content );
    $lines = explode( "\n", $content );
    $lineNumbersHtml = '';
    $codeHtml = '';
    foreach ( $lines as $i => $line ) {
        $lineNumbersHtml .= '<span>' . ( $i + 1 ) . '</span>' . "\n";
        $codeHtml .= esc_html( $line ) . "\n";
    }
	$languageSetting = get_option( 'code_highlighter_language', 'es' );
	$texts = array(
		'es'     => __( 'Copiar', 'easy-code-highlighter' ),
		'en'     => __( 'Copy', 'easy-code-highlighter' ),
		'custom' => get_option( 'code_highlighter_text_copy', __( 'Copiar', 'easy-code-highlighter' ) )
				);
	$button_text = isset( $texts[ $languageSetting ] ) ? $texts[ $languageSetting ] : __( 'Copiar', 'easy-code-highlighter' );
    $output  = '<div class="code-container">';
    $output .= '<button class="copy-button" onclick="copyCode(this)">' . esc_html( $button_text ) . '</button>';
    $output .= '<div class="code-wrapper">';
    $output .= '<div class="line-numbers">' . $lineNumbersHtml . '</div>';
    $output .= '<pre><code class="language-' . esc_attr( $atts['language'] ) . '">' . $codeHtml . '</code></pre>';
    $output .= '</div></div>';
    return $output;
}
add_shortcode( 'easycode', 'easy_hi_reormadrid_code_highlighter_copy_shortcode' );

// Añadimos menú y opciones en la administración
// We add menu and options in the administration
function easy_hi_reormadrid_code_highlighter_admin_menu() {
    add_menu_page(
        __( 'Code Highlighter Config', 'easy-code-highlighter' ),
        __( 'Code Highlighter', 'easy-code-highlighter' ),
        'manage_options',
        'code-highlighter-settings',
        'easy_hi_reormadrid_code_highlighter_settings_page',
        'dashicons-admin-generic',
        100
    );
}
add_action( 'admin_menu', 'easy_hi_reormadrid_code_highlighter_admin_menu' );

// Añadir el selector de colorres a la página de configuración (WP Color Picker)
// Add the color picker to the settings page (WP Color Picker)
function easy_hi_reormadrid_code_highlighter_admin_color_picker( $hook_suffix ) {
    if ( 'toplevel_page_code-highlighter-settings' !== $hook_suffix ) {
        return;
    }
    wp_enqueue_style( 'wp-color-picker' );
    wp_enqueue_script( 'wp-color-picker' );
}
add_action( 'admin_enqueue_scripts', 'easy_hi_reormadrid_code_highlighter_admin_color_picker' );

// Aquí generamos todas las opciones dentro de la administración
// Here we generate all the options within the administration
function easy_hi_reormadrid_code_highlighter_settings_page() {
    if ( isset( $_POST['code_highlighter_save_settings'] ) ) {
          // Verificar
		  // Verify
		if ( ! isset( $_POST['code_highlighter_settings_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['code_highlighter_settings_nonce'] ) ), 'code_highlighter_settings_nonce' ) ) {
			wp_die( 'Acceso no permitido.' );
		}
        check_admin_referer( 'code_highlighter_settings_nonce', 'code_highlighter_settings_nonce' );
        // Traducciones e idioma
		// Translations and language
        $text_copy = isset( $_POST['text_copy'] ) ? sanitize_text_field( wp_unslash( $_POST['text_copy'] ) ) : '';
        update_option( 'code_highlighter_text_copy', $text_copy );
        $text_copied = isset( $_POST['text_copied'] ) ? sanitize_text_field( wp_unslash( $_POST['text_copied'] ) ) : '';
        update_option( 'code_highlighter_text_copied', $text_copied );
        $language = isset( $_POST['language'] ) ? sanitize_text_field( wp_unslash( $_POST['language'] ) ) : 'es';
        update_option( 'code_highlighter_language', $language );
        // Colores
		// Colors
        $bg_color = isset( $_POST['bg_color'] ) ? sanitize_text_field( wp_unslash( $_POST['bg_color'] ) ) : '';
        update_option( 'code_highlighter_bg_color', $bg_color );
        $line_color = isset( $_POST['line_color'] ) ? sanitize_text_field( wp_unslash( $_POST['line_color'] ) ) : '';
        update_option( 'code_highlighter_line_color', $line_color );
        $button_color = isset( $_POST['button_color'] ) ? sanitize_text_field( wp_unslash( $_POST['button_color'] ) ) : '';
        update_option( 'code_highlighter_button_color', $button_color );
        // Color y grosor del borde del botón
		// Button border color and thickness
        $button_border_color = isset( $_POST['button_border_color'] ) ? sanitize_text_field( wp_unslash( $_POST['button_border_color'] ) ) : '';
        update_option( 'code_highlighter_button_border_color', $button_border_color );
        $button_border_thickness = isset( $_POST['button_border_thickness'] ) ? sanitize_text_field( wp_unslash( $_POST['button_border_thickness'] ) ) : '';
        update_option( 'code_highlighter_button_border_thickness', $button_border_thickness );
        // Estilos al  botón de copiar
		// Styles for the copy button
        $button_font_size = isset( $_POST['button_font_size'] ) ? sanitize_text_field( wp_unslash( $_POST['button_font_size'] ) ) : '';
        update_option( 'code_highlighter_button_font_size', $button_font_size );
        $button_padding_top = isset( $_POST['button_padding_top'] ) ? sanitize_text_field( wp_unslash( $_POST['button_padding_top'] ) ) : '';
        update_option( 'code_highlighter_button_padding_top', $button_padding_top );
        $button_padding_right = isset( $_POST['button_padding_right'] ) ? sanitize_text_field( wp_unslash( $_POST['button_padding_right'] ) ) : '';
        update_option( 'code_highlighter_button_padding_right', $button_padding_right );
        $button_padding_bottom = isset( $_POST['button_padding_bottom'] ) ? sanitize_text_field( wp_unslash( $_POST['button_padding_bottom'] ) ) : '';
        update_option( 'code_highlighter_button_padding_bottom', $button_padding_bottom );
        $button_padding_left = isset( $_POST['button_padding_left'] ) ? sanitize_text_field( wp_unslash( $_POST['button_padding_left'] ) ) : '';
        update_option( 'code_highlighter_button_padding_left', $button_padding_left );
        update_option( 'code_highlighter_button_border', isset( $_POST['button_border'] ) ? '1' : '0' );
        update_option( 'code_highlighter_button_border_radius', isset( $_POST['button_border_radius'] ) ? '1' : '0' );
        $button_border_radius_value = isset( $_POST['button_border_radius_value'] ) ? sanitize_text_field( wp_unslash( $_POST['button_border_radius_value'] ) ) : '';
        update_option( 'code_highlighter_button_border_radius_value', $button_border_radius_value );
        echo '<div class="updated"><p>' . esc_html__( 'Configuración guardada.', 'easy-code-highlighter' ) . '</p></div>';
    }
    // Valores por defecto
	// Default values
    $text_copy                   = get_option( 'code_highlighter_text_copy', esc_html__( 'Copiar', 'easy-code-highlighter' ) );
    $text_copied                 = get_option( 'code_highlighter_text_copied', esc_html__( 'Copiado!', 'easy-code-highlighter' ) );
    $language                    = get_option( 'code_highlighter_language', 'es' );
    $bg_color                    = get_option( 'code_highlighter_bg_color', '#2d2d2d' );
    $line_color                  = get_option( 'code_highlighter_line_color', '#fff' );
    $button_color                = get_option( 'code_highlighter_button_color', '#0073aa' );
    $button_border_color         = get_option( 'code_highlighter_button_border_color', '#ffffff' );
    $button_border_thickness     = get_option( 'code_highlighter_button_border_thickness', '1px' );
    $button_font_size            = get_option( 'code_highlighter_button_font_size', '12px' );
    $button_padding_top          = get_option( 'code_highlighter_button_padding_top', '5px' );
    $button_padding_right        = get_option( 'code_highlighter_button_padding_right', '10px' );
    $button_padding_bottom       = get_option( 'code_highlighter_button_padding_bottom', '5px' );
    $button_padding_left         = get_option( 'code_highlighter_button_padding_left', '10px' );
    $button_border               = get_option( 'code_highlighter_button_border', '0' );
    $button_border_radius        = get_option( 'code_highlighter_button_border_radius', '0' );
    $button_border_radius_value  = get_option( 'code_highlighter_button_border_radius_value', '5px' );
	?>
 
    <div class="wrap code-highlighter-settings">
        <h1><?php esc_html_e( 'Configuración de Code Highlighter', 'easy-code-highlighter' ); ?></h1>
        <?php wp_nonce_field( 'code_highlighter_settings_nonce', 'code_highlighter_settings_nonce' ); ?>
        
        <form method="post">
		    <?php wp_nonce_field( 'code_highlighter_settings_nonce', 'code_highlighter_settings_nonce' ); ?>
			
            <div class="section">
                <h2><?php esc_html_e( 'Seleccionar Idioma', 'easy-code-highlighter' ); ?></h2>
				<div class="inline-group">
                <label>
                    <input type="radio" name="language" value="es" <?php checked( $language, 'es' ); ?>> <?php esc_html_e( 'Español', 'easy-code-highlighter' ); ?>
                </label>
                <label>
                    <input type="radio" name="language" value="en" <?php checked( $language, 'en' ); ?>> <?php esc_html_e( 'Inglés', 'easy-code-highlighter' ); ?>
                </label>
                <label>
                    <input type="radio" name="language" value="custom" <?php checked( $language, 'custom' ); ?>> <?php esc_html_e( 'Personalizado', 'easy-code-highlighter' ); ?>
                </label>
				</div>
            </div>
            <div class="section">
                <h2><?php esc_html_e( 'Traducción', 'easy-code-highlighter' ); ?></h2>
                <div class="translation-row">
                    <div>
                        <label><?php esc_html_e( 'Español', 'easy-code-highlighter' ); ?></label>
                        <input type="text" readonly value="<?php esc_attr_e( 'Copiar', 'easy-code-highlighter' ); ?>" style="background:#eee;border:1px solid #ccc;">
                    </div>
                    <div>
                        <label><?php esc_html_e( 'Inglés', 'easy-code-highlighter' ); ?></label>
                        <input type="text" readonly value="<?php esc_attr_e( 'Copy', 'easy-code-highlighter' ); ?>" style="background:#eee;border:1px solid #ccc;">
                    </div>
                    <div>
                        <label><?php esc_html_e( 'Personalizado', 'easy-code-highlighter' ); ?></label>
                        <input type="text" name="text_copy" value="<?php echo esc_attr( $text_copy ); ?>">
                    </div>
                </div>
                <div class="translation-row">
                    <div>
                        <label><?php esc_html_e( 'Español', 'easy-code-highlighter' ); ?></label>
                        <input type="text" readonly value="<?php esc_attr_e( 'Copiado!', 'easy-code-highlighter' ); ?>" style="background:#eee;border:1px solid #ccc;">
                    </div>
                    <div>
                        <label><?php esc_html_e( 'Inglés', 'easy-code-highlighter' ); ?></label>
                        <input type="text" readonly value="<?php esc_attr_e( 'Copied!', 'easy-code-highlighter' ); ?>" style="background:#eee;border:1px solid #ccc;">
                    </div>
                    <div>
                        <label><?php esc_html_e( 'Personalizado', 'easy-code-highlighter' ); ?></label>
                        <input type="text" name="text_copied" value="<?php echo esc_attr( $text_copied ); ?>">
                    </div>
                </div>
            </div>
			<hr />
            <div class="section">
                <h2><?php esc_html_e( 'Colores', 'easy-code-highlighter' ); ?></h2>
                <div class="color-group">
                    <label><?php esc_html_e( 'Fondo del código:', 'easy-code-highlighter' ); ?></label>
                    <input type="text" class="color-field" name="bg_color" value="<?php echo esc_attr( $bg_color ); ?>" placeholder="#2d2d2d">
                </div>
                <div class="color-group">
                    <label><?php esc_html_e( 'Numeración:', 'easy-code-highlighter' ); ?></label>
                    <input type="text" class="color-field" name="line_color" value="<?php echo esc_attr( $line_color ); ?>" placeholder="#ffffff">
                </div>
                <div class="color-group">
                    <label><?php esc_html_e( 'Botón copiar:', 'easy-code-highlighter' ); ?></label>
                    <input type="text" class="color-field" name="button_color" value="<?php echo esc_attr( $button_color ); ?>" placeholder="#0073aa">
                </div>
            </div>
			<hr />
            <div class="section">
                <h2><?php esc_html_e( 'Estilos del botón de copiar', 'easy-code-highlighter' ); ?></h2>
                <div class="inline-group">
                    <label><?php esc_html_e( 'Tamaño de fuente:', 'easy-code-highlighter' ); ?></label>
                    <input class="small-input" type="text" name="button_font_size" value="<?php echo esc_attr( $button_font_size ); ?>" placeholder="12px">
                </div>
                <div class="inline-group">
                    <label><?php esc_html_e( 'Padding (Sup, Der, Inf, Izq):', 'easy-code-highlighter' ); ?></label>
                    <input class="small-input" type="text" name="button_padding_top" value="<?php echo esc_attr( $button_padding_top ); ?>" placeholder="5px">
                    <input class="small-input" type="text" name="button_padding_right" value="<?php echo esc_attr( $button_padding_right ); ?>" placeholder="10px">
                    <input class="small-input" type="text" name="button_padding_bottom" value="<?php echo esc_attr( $button_padding_bottom ); ?>" placeholder="5px">
                    <input class="small-input" type="text" name="button_padding_left" value="<?php echo esc_attr( $button_padding_left ); ?>" placeholder="10px">
                </div>
                <div class="inline-group">
                    <label><?php esc_html_e( 'Borde:', 'easy-code-highlighter' ); ?></label>
                    <input type="checkbox" name="button_border" <?php checked( $button_border, '1' ); ?>> 
                    <label style="margin-left:10px;"><?php esc_html_e( 'Color:', 'easy-code-highlighter' ); ?></label>
                    <input class="small-input color-field" type="text" name="button_border_color" value="<?php echo esc_attr( $button_border_color ); ?>" placeholder="#ffffff">
                    <label style="margin-left:10px;"><?php esc_html_e( 'Grosor:', 'easy-code-highlighter' ); ?></label>
                    <input class="small-input" type="text" name="button_border_thickness" value="<?php echo esc_attr( $button_border_thickness ); ?>" placeholder="1px">
                </div>
                <div class="inline-group">
                    <label><?php esc_html_e( 'Border Radius:', 'easy-code-highlighter' ); ?></label>
                    <input type="checkbox" name="button_border_radius" <?php checked( $button_border_radius, '1' ); ?>> 
                    <label style="margin-left:10px;"><?php esc_html_e( 'Tamaño:', 'easy-code-highlighter' ); ?></label>
                    <input class="small-input" type="text" name="button_border_radius_value" value="<?php echo esc_attr( $button_border_radius_value ); ?>" placeholder="5px">
                </div>
            </div>
            <p>
                <input type="submit" name="code_highlighter_save_settings" class="button-primary" value="<?php esc_attr_e( 'Guardar cambios', 'easy-code-highlighter' ); ?>">
            </p>
        </form>
        
    </div>
    <?php
}

// Agregar CSS y JS en la administración de WordPress
// Adding CSS and JS in WordPress Admin
function easy_hi_reormadrid_enqueue_code_highlighter_admin_assets($hook_suffix) {
    // Asegúrate de que solo se cargue en la página de configuración del plugin
    if ($hook_suffix === 'toplevel_page_code-highlighter-settings') {
        // Cargamos CSS.
		// We load CSS.
        wp_enqueue_style(
            'code-highlighter-admin-styles',
            plugin_dir_url(__FILE__) . 'css/admin-styles.css',
            array(),
            filemtime(plugin_dir_path(__FILE__) . 'css/admin-styles.css')
        );
        // Cargamos archivo JS.
		// We load the JS file.		
        wp_enqueue_script(
            'code-highlighter-admin-scripts',
            plugin_dir_url(__FILE__) . 'js/admin-scripts.js',
            array('jquery', 'wp-color-picker'),
            filemtime(plugin_dir_path(__FILE__) . 'js/admin-scripts.js'),
            true // Cargamos en el footer - We load it in the footer.
        );
    }
}
add_action('admin_enqueue_scripts', 'easy_hi_reormadrid_enqueue_code_highlighter_admin_assets');

function easy_hi_reormadrid_code_highlighter_custom_js() {
    // El idioma seleccionado.
	// The selected language.
    $language = get_option('code_highlighter_language', 'es');

    // ¿Hay textos personalizados y se pueden usar?.
	// Are there custom texts, and can they be used?
    $text_copy = esc_js(get_option('code_highlighter_text_copy', __('Copiar', 'easy-code-highlighter')));
    $text_copied = esc_js(get_option('code_highlighter_text_copied', __('Copiado!', 'easy-code-highlighter')));

    // Si el idioma no es personalizado, usamos los textos predeterminados según el idioma.
	// If the language is not customized, we use the default texts based on the language.
    if ($language !== 'custom') {
        $texts = [
            'es' => ['copy' => __('Copiar', 'easy-code-highlighter'), 'copied' => __('Copiado!', 'easy-code-highlighter')],
            'en' => ['copy' => __('Copy', 'easy-code-highlighter'), 'copied' => __('Copied!', 'easy-code-highlighter')],
        ];
        if (isset($texts[$language])) {
            $text_copy = esc_js($texts[$language]['copy']);
            $text_copied = esc_js($texts[$language]['copied']);
        }
    }

    // Obtenemos los estilos personalizados.
	// We get the custom styles.
    $bg_color = esc_js(get_option('code_highlighter_bg_color', '#2d2d2d'));
    $line_color = esc_js(get_option('code_highlighter_line_color', '#fff'));
    $button_color = esc_js(get_option('code_highlighter_button_color', '#0073aa'));
    $button_border_color = esc_js(get_option('code_highlighter_button_border_color', '#ffffff'));
    $button_border_thickness = esc_js(get_option('code_highlighter_button_border_thickness', '1px'));
    $button_font_size = esc_js(get_option('code_highlighter_button_font_size', '12px'));
    $button_padding_top = esc_js(get_option('code_highlighter_button_padding_top', '5px'));
    $button_padding_right = esc_js(get_option('code_highlighter_button_padding_right', '10px'));
    $button_padding_bottom = esc_js(get_option('code_highlighter_button_padding_bottom', '5px'));
    $button_padding_left = esc_js(get_option('code_highlighter_button_padding_left', '10px'));
    $button_border = esc_js(get_option('code_highlighter_button_border', '0'));
    $button_border_radius = esc_js(get_option('code_highlighter_button_border_radius', '0'));
    $button_border_radius_value = esc_js(get_option('code_highlighter_button_border_radius_value', '5px'));

    // Generamos el código JavaScript personalizado.
	// We generate the custom JavaScript code.
    $custom_js = sprintf(
        "
        function copyCode(button) {
            var codeEl = button.parentElement.querySelector('pre code');
            var text = codeEl.innerText;
            navigator.clipboard.writeText(text).then(function(){
                button.textContent = %s;
                setTimeout(function(){
                    button.textContent = %s;
                }, 2000);
            });
        }
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.code-container, .code-wrapper pre').forEach(function(el) {
                el.style.backgroundColor = %s;
            });
            document.querySelectorAll('.line-numbers').forEach(function(el) {
                el.style.color = %s;
            });
            document.querySelectorAll('.copy-button').forEach(function(el) {
                el.style.backgroundColor = %s;
                el.style.fontSize = %s;
                el.style.paddingTop = %s;
                el.style.paddingRight = %s;
                el.style.paddingBottom = %s;
                el.style.paddingLeft = %s;
                if (%s === '1') {
                    el.style.border = %s + ' solid ' + %s;
                } else {
                    el.style.border = 'none';
                }
                if (%s === '1') {
                    el.style.borderRadius = %s;
                } else {
                    el.style.borderRadius = '0';
                }
            });
        });
        ",
        wp_json_encode($text_copied),
        wp_json_encode($text_copy),
        wp_json_encode($bg_color),
        wp_json_encode($line_color),
        wp_json_encode($button_color),
        wp_json_encode($button_font_size),
        wp_json_encode($button_padding_top),
        wp_json_encode($button_padding_right),
        wp_json_encode($button_padding_bottom),
        wp_json_encode($button_padding_left),
        wp_json_encode($button_border),
        wp_json_encode($button_border_thickness),
        wp_json_encode($button_border_color),
        wp_json_encode($button_border_radius),
        wp_json_encode($button_border_radius_value)
    );

    wp_add_inline_script('prism', $custom_js);
}
add_action('wp_enqueue_scripts', 'easy_hi_reormadrid_code_highlighter_custom_js');
?>