<?php

/**
 * Plugin Name:       Easy Client Testimonial
 * Plugin URI:        https://nabiganj-it.com/testimonial
 * Description:       It's nice and professional testomonial slider plugin. It's very easy and free to use.
 * Version:           1.0.0
 * Requires at least: 5.2
 * Requires PHP:      7.2
 * Author:            Musarrof
 * Author URI:        https://nabiganj-it.com/musarrof
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       nice_testi
 */

// All Style and JS function

function nice_testi_enqueue_scripts() {
	wp_enqueue_style('owl.carousel', plugins_url('assets/css/owl.carousel.min.css', __FILE__) );
	wp_enqueue_style('owl.theme', plugins_url('assets/css/owl.theme.default.min.css', __FILE__) );
	wp_enqueue_style('fontawesome', 'https://pro.fontawesome.com/releases/v5.10.0/css/all.css' );
	
	wp_enqueue_style('main-style', plugins_url('assets/css/style.css', __FILE__) );

	wp_enqueue_script('owl.carousel-js', plugin_dir_url(__FILE__). 'assets/js/owl.carousel.min.js', array('jquery'), '2.3.4', true );
	
}
add_action('wp_enqueue_scripts', 'nice_testi_enqueue_scripts');


function nice_testi_post_type_function() {
	$all_fields = array(
		'name' 					=> _( 'Easy Testimonials' ),
		'singular_name' 		=> _( 'Testimonial' ),
		'add_new'               => __( 'Add New', 'Testimonial' ),
        'add_new_item'          => __( 'Add New Testimonial', 'nice_testi' ),
        'new_item'              => __( 'New Testimonial', 'nice_testi' ),
        'edit_item'             => __( 'Edit Testimonial', 'nice_testi' ),
        'view_item'             => __( 'View Testimonial', 'nice_testi' ),
        'all_items'             => __( 'All Testimonial', 'nice_testi' ),
        'featured_image'        => _x( 'Testimonial Profile Image', 'Overrides the “Featured Image” phrase for this post type. Added in 4.3', 'nice_testi' ),
        'set_featured_image'    => _x( 'Set Profile image', 'Overrides the “Set featured image” phrase for this post type. Added in 4.3', 'nice_testi' ),
        'remove_featured_image' => _x( 'Remove Profile image', 'Overrides the “Remove featured image” phrase for this post type. Added in 4.3', 'nice_testi' ),
	);
	$custom_post_options = array(
		'labels' 		=> $all_fields,
		'supports' 		=> array('title', 'editor', 'thumbnail', 'page-attributes'),
		'public' 		=> false,
		'show_ui' 		=> true,
		'menu_icon' 	=> 'dashicons-id'
	);

	register_post_type('nice_testi_all_post', $custom_post_options);
}
add_action('init', 'nice_testi_post_type_function');


	

function nice_testi_shortcode($nice_testi_atts) {
	
	$all_option_nice_testi = get_option('_nice_testi_options');
	$slider_item = $all_option_nice_testi['nice_testi_how_many_slide'];
	$slider_per_page = $all_option_nice_testi['nice_testi_slide_per_page'];
	$nav_arrow = $all_option_nice_testi['enable_arrow'];
	$slider_dots = $all_option_nice_testi['enable_dots'];
	$slider_autoplay = $all_option_nice_testi['enable_autoplay'];
	$slider_autoplay_time = $all_option_nice_testi['slide_auto_play_time'];
	$slider_loop = $all_option_nice_testi['enable_loop'];

	extract( shortcode_atts( array(
		'count' 			=> 4,
		'items' 			=> 2,
		'dots' 				=> 'false',
		'nav' 				=> 'true',
		'autoplay' 			=> 'true',
		'autoplayTimeout' 	=> 5000,
		'loop' 				=> 'true',

	), $nice_testi_atts) );

	$nice_testi_argoment = array(
		'post_type' 		=> 'nice_testi_all_post',
		'posts_per_page' 	=> $slider_per_page
	);

	$nice_testi_get_post = new WP_Query( $nice_testi_argoment );

	$nice_testi_random = rand(69874526, 47862589);

	$nice_testi_markup = '
		<script>
			jQuery(window).load( function() {
				jQuery("#testimonial-slider-'.$nice_testi_random.'").owlCarousel({
					items:'.$slider_item.',
			        dots:'.$dots.',
			        nav:'.$nav_arrow.',
			        navText:["",""],
			        autoplay:'.$slider_autoplay.',
					autoplayTimeout: '.$slider_autoplay_time.',
					loop: '.$slider_loop.'
				});
			});
		</script>

	<div id="testimonial-slider-'.$nice_testi_random.'" class="owl-carousel">';

	while($nice_testi_get_post->have_posts() ) : $nice_testi_get_post->the_post();
				$post_id = get_the_ID();
	
	$nice_testi_name = get_post_meta($post_id, 'nice_testi_name_field', true);
	$nice_testi_designation = get_post_meta($post_id, 'nice_testi_designation_field', true);
	$nice_testi_rating = get_post_meta( $post_id, 'nice_testi_rating', true );
	

	$nice_testi_markup .= '
		<div class="testimonial">
			<div class="pic">
				<img src="'.esc_url( get_the_post_thumbnail_url($post_id) ).'" alt="">
			</div>
			<h3 class="title">'.esc_html( get_the_title($post_id) ).'</h3>
			'.wpautop( get_the_content( $post_id ) ) .'
			<div class="testimonial-content">
				<div class="testimonial-profile">
					<h3 class="name">'.esc_html( $nice_testi_name ).'</h3>
					<span class="post">'.esc_html( $nice_testi_designation ).'</span>
				</div>
				<ul class="rating">
					<li class="'.esc_html( $nice_testi_rating ).'"></li>
					<li class="'.esc_html( $nice_testi_rating ).'"></li>
					<li class="'.esc_html( $nice_testi_rating ).'"></li>
					<li class="'.esc_html( $nice_testi_rating ).'"></li>
					<li class="'.esc_html( $nice_testi_rating ).'"></li>
				</ul>
			</div>
		</div>
		
	';

	endwhile;

	$nice_testi_markup .= '</div>';

	wp_reset_query();

	return $nice_testi_markup;
}
add_shortcode('nice_testimonial', 'nice_testi_shortcode');

require_once plugin_dir_path(__FILE__) .'/assets/cs-framwork/nice_testi-framework.php';
require_once plugin_dir_path(__FILE__) .'/assets/cs-framwork/post_and_admin_options.php';
require_once plugin_dir_path(__FILE__) .'/assets/cmb2/init.php';
require_once plugin_dir_path(__FILE__) .'/assets/cmb2/nice-testi-functions.php';

