<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

if( class_exists( 'CSF' ) ) {

  // Settings Options 

  // Set a unique slug-like ID
  //
  $nice_testi_prefix = '_nice_testi_options';

  //
  // Create options
  //
  CSF::createOptions( $nice_testi_prefix, array(
    'menu_title'        => 'Settings',
    'menu_slug'         => 'nice_testi_options',
    'menu_type'         => 'submenu',
    'menu_parent'       => 'edit.php?post_type=nice_testi_all_post',
    'framework_title'   => 'Nice Testimonial Options',
    'menu_icon'         => ''
  ) );

  //
  // Create a section
  //
  CSF::createSection( $nice_testi_prefix, array(
    'title'  => 'Main Options',
    'icon'   => 'fas fa-tools',
    'fields' => array(

      //
      // A text field
      //
      array(
        'id'        => 'nice_testi_sc',
        'title'     => 'ShortCode',
        'type'      => 'content',
        'content'   => '<h2>Use this shortcode <strong style="font-size:30px">[nice_testimonial] </strong> to display the Testimonial Slider </h2>',
      ),
      array(
        'id'        => 'nice_testi_how_many_slide',
        'type'      => 'number',
        'title'     => 'Chose how many slide you want to show',
        'default'   => 1
      ),
      array(
        'id'        => 'nice_testi_slide_per_page',
        'type'      => 'number',
        'title'     => 'Chose how many post per page you want to show ',
      ),
      array(
        'id'        => 'enable_arrow',
        'type'      => 'switcher',
        'title'     => 'Enable Arrow',
        'label'     => 'Enable/Disable Nav Arrow.',
        'default'   => true
      ),
      array(
        'id'        => 'enable_dots',
        'type'      => 'switcher',
        'title'     => 'Enable Dots',
        'label'     => 'Enable/Disable Nav Dots',
        'default'   => false
      ),
      array(
        'id'        => 'enable_autoplay',
        'type'      => 'switcher',
        'title'     => 'Enable Slider Auto Play',
        'label'     => 'Enable/Disable Nav Auto Play',
        'default'   => true
      ),
      array(
        'id'        => 'slide_auto_play_time',
        'type'      => 'number',
        'title'     => 'Chose Slider Auto Play Time milisecond',
        'default'   => 5000
      ),
      array(
        'id'        => 'enable_loop',
        'type'      => 'switcher',
        'title'     => 'Enable Slider Loop',
        'label'     => 'Enable/Disable Loop',
        'default'   => true
      ),

    )
  ) );


  CSF::createSection( $nice_testi_prefix, array(
    'title'  => 'Premium Options',
    'icon'   => 'fas fa-dollar-sign',
    'fields' => array(

      //
      // A text field
      //
       array(
        'id'      => 'premium_nice_testi',
        'type'    => 'notice',
        'style'   => 'success',
        'content' => 'Below Option only work for a premium version of this plugin',
      ),

      array(
        'id'      => 'title-color',
        'type'    => 'color',
        'title'   => 'Title Text Color',
        'default' => '#3498db',
      ),

      array(
        'id'      => 'body-color',
        'type'    => 'color',
        'title'   => 'Body Text Font Color',
        'default' => '#000000',
      ),

      array(
        'id'      => 'bg-color',
        'type'    => 'color',
        'title'   => 'Background Color Change',
        'default' => '#cccccc',
      ),

      array(
        'id'        => 'rating-icon',
        'type'      => 'color',
        'title'     => 'Rating Icon Color',
        'default'   => '#ffffff'
      ),

      array(
        'id'    => 'opt-typography-1',
        'type'  => 'typography',
        'title' => 'Typography',
      ),

      array(
        'id'         => 'opt-alt-textarea',
        'type'       => 'textarea',
        'title'      => 'Custom CSS',
        'subtitle'   => 'A textarea for custom CSS.'
      ),

    )
  ) );

}