<?php 
/**
* Plugin Name: Easy Category Cloud
* Plugin URI: https://eluminoustechnologies.com/
* Description: This plugin shows category and sub categories cloud for your woocommerce shop.
* Version: 1.0.0
* Author: Rajendra Mahajan
* License: GPL-2.0+
* License URI: http://www.gnu.org/licenses/gpl-2.0.txt
*/
 
 // Plugin directory url.
 define('ECLURL', WP_PLUGIN_URL."/".dirname( plugin_basename( __FILE__ ) ) );
 
 // Get absolute path 
 if ( !defined('ABSPATH'))
    define('ABSPATH', dirname(__FILE__) . '/');

/**
 *  Current plugin version.
 */
 if ( ! defined( 'EASY_CATEGORY_CLOUD_VER' ) ) {
	define( 'EASY_CATEGORY_CLOUD_VER', '1.0.0' );
 }

/**
  * Check if WooCommerce is active, then put your plugin code here
 */
  if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
	 
	// Enqueue style
	add_action('wp_enqueue_scripts', esyccld_enqueue_scripts); 	
	
	// Add shortcode
	add_shortcode('easycategorycloud', 'esyccld_showeasycategorycloud');
  }

/////////////////////////////////////////////////////////////////////////////////////////////////////  
/**
  * Function to show category cloud
 */
 function esyccld_showeasycategorycloud(){

	 $args = array(
          'taxonomy' => 'product_cat',
          'hide_empty' => true,
          'parent'   => 0
      );
  $product_cat = get_terms( $args );

  foreach ($product_cat as $parent_product_cat) {

  echo '<div class="tagcloud05"><ul><li><a href="'.get_term_link($parent_product_cat->term_id).'">'.$parent_product_cat->name.'</a></li></ul></div>';
  $child_args = array(
              'taxonomy' => 'product_cat',
              'hide_empty' => false,
              'parent'   => $parent_product_cat->term_id
        );
  $child_product_cats = get_terms( $child_args );
  if(count($child_product_cats)>0) {
  echo '<div class="tagcloud01" id="divesyccld"><ul>';
  
  foreach ($child_product_cats as $child_product_cat) {
    echo '<li><a href="'.get_term_link($child_product_cat->term_id).'">'.$child_product_cat->name.'</a></li>';
  } 
  echo '</ul></div>';
  } 
  } 	
 }
  
/**
  * Function to enqueue script
 */  
  function esyccld_enqueue_scripts() {
	wp_register_style( 'esyccldcss',  ECLURL.'/assets/css/style.css' );
    wp_enqueue_style( 'esyccldcss' );  
  }  
?>