<?php 
/*
    Plugin Name: Easy car rental custom lightslider
    Plugin URI: http://clever-themes.com
    Author: Filipescu Alexandru
    Author URI: http://filipescu.ml
    Description: A plugin built by Filipescu Alexandru using a popular slider library http://sachinchoolur.github.io/lightslider/ and the core features of Wordpress.
    Version: 1.0
    License GPL2 or later
    Text Domain: easy-car-rental-lightslider
    
    Version: 1.0
*/

if( !defined('ABSPATH')){
    exit;
}

add_action('plugins_loaded', function(){
    if(current_user_can('editor') || current_user_can('administrator')){


function ecrcl_init() {
    $args = array(
        'public'    => true,
        'label'     => 'Light Images',
        'menu_position' => 12,
        'menu_icon' => 'dashicons-images-alt2',
        'supports'  => array(
            'title',
            'thumbnail'
           )
        );
        add_image_size('ecrcl_widget', 180, 100, true);
        add_image_size('ecrcl_function', 990, 380, true);
        register_post_type('ecrcl_images' , $args);
       
}
add_theme_support( 'post-thumbnails' );
add_action('init', 'ecrcl_init');

add_action('wp_print_scripts', 'ecrcl_register_scripts');
add_action('wp_print_styles', 'ecrcl_register_styles');

function ecrcl_register_scripts() {
    if (!is_admin()) {
        // register
        wp_register_script('ecrcl_light_script', plugins_url('lightslider.js', __FILE__));
     
        // enqueue
        wp_enqueue_script('ecrcl_light_script');
        wp_enqueue_script('jquery');
        
    }
}
 
function ecrcl_register_styles() {
    // register
    wp_register_style('ecrcl_styles', plugins_url('lightslider.css', __FILE__));
 
    // enqueue
    wp_enqueue_style('ecrcl_styles');

}

function ecrcl_function() {
    $args = array(
        'post_type' => 'ecrcl_images',
        'posts_per_page' => 5
    );

    ?>
<script>
jQuery(document).ready(function(){
    $("#slider-lp").lightSlider({
        loop:true,
        item: 1
        
    });
});
</script>

<?php

      
    $result = '<ul id="slider-lp">';
 
    //loop-ul
    $loop = new WP_Query($args);
    while ($loop->have_posts()) {
        $loop->the_post();
 
        $the_url = wp_get_attachment_image_src(get_post_thumbnail_id($loop->ID), 'ecrcl_function');
        $result .= '<li>';
        $result .='<img style="width: 100%;height: 100%;object-fit:cover; overflow: hidden;" src="' . $the_url[0] . '" />';

        $result .= '</li>';
    }
    $result .='</ul>';
   
    return $result;

}

add_shortcode('ecrcl-shortcode', 'ecrcl_function');


}
});

?>
