<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

//acf block define
register_block_type( EG_PLUGIN_PATH . "blocks/carousel/block.json" );


//assets loading
function egacf_carousel_enqueue_block_assets() {
	wp_register_style( 'egacf-slick-style', EG_PLUGIN_URL . "/blocks/carousel/slick.css", array(), time() );
	wp_enqueue_style( 'egacf-slick-style');

	wp_register_style( 'egacf-carousel-style', EG_PLUGIN_URL . "/blocks/carousel/eg-carousel-style.css", array(), time() );
	wp_enqueue_style( 'egacf-carousel-style');

	wp_register_script( 'egacf-slick-script', EG_PLUGIN_URL . "/blocks/carousel/slick.js", array('jquery'), time(), true );
	wp_enqueue_script('egacf-slick-script');
	
	wp_register_script( 'egacf-carousel-script', EG_PLUGIN_URL . "/blocks/carousel/eg-carousel-script.js", [ 'jquery', 'acf' ],time(),true );
	wp_enqueue_script('egacf-carousel-script');

	if (is_admin()) {
		wp_register_style( 'egacf-carousel-admin-style', EG_PLUGIN_URL . "/blocks/carousel/eg-carousel-admin.css", "", time() );
		wp_enqueue_style( 'egacf-carousel-admin-style');
	}
}

function egacf_carousel_assets( $block_content, $block ) {
	// Check if the specific block is being rendered
    if ( 'acf/eg-carousel' === $block['blockName']) {
		egacf_carousel_enqueue_block_assets();
	}
	return $block_content;
}
add_filter( 'render_block', 'egacf_carousel_assets', 10, 2 );

//loading assets for admin
add_action( 'admin_enqueue_scripts', 'egacf_carousel_enqueue_block_assets' );


//acf backend field adding
if ( ! function_exists( 'acf_add_local_field_group' ) ) {
    return;
}

acf_add_local_field_group( array(
	'key' => 'group_64f9750eeeed9',
	'title' => 'Easy Gutenberg - Carousal',
	'fields' => array(
		array(
			'key' => 'field_64f9750f003a2',
			'label' => 'Block Settings',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_64f9750f003a8',
			'label' => 'Title',
			'name' => 'title',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64f97ca2e72a4',
			'label' => 'Remove top padding',
			'name' => 'remove_top_padding',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '20',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'allow_in_bindings' => 1,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_64f97cb7e72a5',
			'label' => 'Remove bottom padding',
			'name' => 'remove_button_padding',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '20',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'allow_in_bindings' => 1,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_64f9750f003b1',
			'label' => 'Hide Controls',
			'name' => 'hide_controls',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '20',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'allow_in_bindings' => 1,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_655457787172a',
			'label' => 'Hide Slide Footer',
			'name' => 'hide_slide_footer',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '20',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'allow_in_bindings' => 1,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_672aef87c93d0',
			'label' => 'Hide Container',
			'name' => 'hide_container',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '20',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'allow_in_bindings' => 1,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_64f9750f003b4',
			'label' => 'Number of Slides',
			'name' => 'number_of_slider',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Recommended 4',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '20',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => '1',
				2 => '2',
				3 => '3',
				4 => '4',
				5 => '5',
			),
			'default_value' => 4,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'allow_in_bindings' => 1,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_672b518e40722',
			'label' => 'Slide Image Height',
			'name' => 'slide_image_height',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '20',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'allow_in_bindings' => 0,
			'placeholder' => '320px',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_6766147b3c706',
			'label' => 'Slide Image Height (Mobile)',
			'name' => 'slide_image_height_mobile',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '20',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'allow_in_bindings' => 0,
			'placeholder' => '280px',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_672d64ba16b57',
			'label' => 'Slide Speed',
			'name' => 'slide_speed',
			'aria-label' => '',
			'type' => 'number',
			'instructions' => 'In milliseconds',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '20',
				'class' => '',
				'id' => '',
			),
			'default_value' => 2000,
			'min' => '',
			'max' => '',
			'allow_in_bindings' => 0,
			'placeholder' => '',
			'step' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_672d64fb16b58',
			'label' => 'Slide Autoplay',
			'name' => 'slide_auto_play',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '20',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'allow_in_bindings' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_64f9750f003b7',
			'label' => 'Carousal',
			'name' => 'news_and_events',
			'aria-label' => '',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'row',
			'pagination' => 0,
			'min' => 0,
			'max' => 0,
			'collapsed' => '',
			'button_label' => 'Add Row',
			'rows_per_page' => 20,
			'sub_fields' => array(
				array(
					'key' => 'field_64f97761bf669',
					'label' => 'Title',
					'name' => 'news_and_events_title',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64f9750f003b7',
				),
				array(
					'key' => 'field_64f97511be6ed',
					'label' => 'Image',
					'name' => 'news_and_events_image',
					'aria-label' => '',
					'type' => 'image',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'url',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
					'preview_size' => 'medium',
					'parent_repeater' => 'field_64f9750f003b7',
				),
				array(
					'key' => 'field_64f97511be6f7',
					'label' => 'Description',
					'name' => 'news_and_events_description',
					'aria-label' => '',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'allow_in_bindings' => 1,
					'tabs' => 'all',
					'toolbar' => 'basic',
					'media_upload' => 0,
					'delay' => 0,
					'parent_repeater' => 'field_64f9750f003b7',
				),
				array(
					'key' => 'field_64f977c1bf66c',
					'label' => 'Footer Color',
					'name' => 'news_and_events_footer_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'enable_opacity' => 0,
					'return_format' => 'string',
					'parent_repeater' => 'field_64f9750f003b7',
				),
				array(
					'key' => 'field_64f97798bf66a',
					'label' => 'Button Label',
					'name' => 'news_and_events_button_label',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'allow_in_bindings' => 1,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64f9750f003b7',
				),
				array(
					'key' => 'field_64f977a6bf66b',
					'label' => 'Button URL',
					'name' => 'news_and_events_button_url',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64f97798bf66a',
								'operator' => '!=empty',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'allow_in_bindings' => 1,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64f9750f003b7',
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'block',
				'operator' => '==',
				'value' => 'acf/eg-carousel',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );