jQuery(document).ready(function($) {

    // Check if localization object exists
    if (typeof easyavup_frontend_localize === 'undefined') {
        console.error('Localization object not found.');
        return;
    }

    // Open popup
    $('body').on('click', '.easyavup_open_action .easyavup_upload', function() {
        $('.easyavup_overlay').addClass('easyavup_active');
        $('.easyavup_popup').addClass('easyavup_active');
        $('body').css('overflow', 'hidden');
    });

    // Close popup function
    function closePopup() {
        $('.easyavup_overlay').removeClass('easyavup_active');
        $('.easyavup_popup').removeClass('easyavup_active');
        $('body').css('overflow', '');
    }

    // Close popup events
    $('.easyavup_closeBtn, .easyavup_cancelBtn').click(closePopup);
    $('.easyavup_overlay').click(closePopup);

    // Prevent popup from closing when clicking inside it
    $('.easyavup_popup').click(function(e) {
        e.stopPropagation();
    });


    // let selectedFile = null;
    
    if ( typeof wp !== "undefined" && typeof wp.media !== "undefined" ) {

        var mediaUploader;

        $('.easyavup_popup').on('click', '.easyavup_changePictureBtn', function(e){

            e.preventDefault();
            if (mediaUploader) {
                mediaUploader.open();
                return;
            }

            mediaUploader = wp.media({
                title: easyavup_frontend_localize.easyavup_strings.easyavup_selectImage || 'Select Profile Picture',
                button: {
                    text: easyavup_frontend_localize.easyavup_strings.easyavup_useImage || 'Use This Image'
                },
                multiple: false,
                library: {
                    type: 'image'
                }
            });

            mediaUploader.on("select", function() {
                var attachment = mediaUploader.state().get("selection").first().toJSON();

                if (!attachment || !attachment.id) {
                    console.error('Invalid attachment selected.');
                    return;
                }

                const imageUrl = attachment.sizes?.medium?.url || attachment.url;
                let attachmentId = attachment.id;
                let update_profile_nonce = $('#easyavup-nonce').val() || '';

                // // Validate required data
                if ( attachmentId == '' && !update_profile_nonce ) {
                    console.log('Missing Something');
                    return;
                }

                const formData = new FormData();
                formData.append('action', 'easyavup_save_profile_picture');
                formData.append('nonce', update_profile_nonce);
                formData.append('attachment_id', parseInt(attachmentId, 10));
                formData.append('directfile', '');


                $('.easyavup_changePictureBtn').addClass('easyavup_btn-loading');

                $.ajax({
                    url: easyavup_frontend_localize.ajax_url,
                    type: "POST",
                    dataType: 'json',
                    timeout: 30000, 
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {

                        if ( response && response['success'] ) {
                            $("img.avatar.easyavup_avatar, .avatar").attr('src', imageUrl).attr('srcset', imageUrl);
                            $(".easyavup_deleteBtn").attr('data-id', attachmentId);
                            $('.loader-wrap').removeClass('active');
                            $('.easyavup_changePictureBtn').removeClass('easyavup_btn-loading');
                            showSuccessMessage('Profile picture updated successfully.')
                        }
                    },
                    error: function(data, status) {
                        console.log(data, status);
                        alert('Something is missing!');
                    }
                });
            });

            mediaUploader.open();
        });
    } else {

        $('.easyavup_popup').on('click', '.easyavup_changePictureBtn', function(e){
            e.preventDefault();

            $('#profile-picture-upload_manual').trigger('click');
        });

        $('body').on('change', '#profile-picture-upload_manual', function(){
            const selectedFile = this.files[0];

            if ( selectedFile ) {

                if ( selectedFile != null ) {
                    if ( !validateFile(selectedFile) ) {
                        selectedFile = null;
                    };
                }

                let update_profile_nonce = $('#easyavup-nonce').val() || '';
                var $this = $(this);

                if ( selectedFile == null && !update_profile_nonce ) {
                    console.log('Missing Something');
                    return;
                }

                const formData = new FormData();
                formData.append('action', 'easyavup_save_profile_picture');
                formData.append('nonce', update_profile_nonce);
                formData.append('directfile', selectedFile);


                $('.easyavup_changePictureBtn').addClass('easyavup_btn-loading');
                $.ajax({
                    url: easyavup_frontend_localize.ajax_url,
                    type: "POST",
                    dataType: 'json',
                    timeout: 30000, 
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {

                        if ( response && response['success'] && response['data']['url'] != '' ) {
                            let imageUrl = response['data']['url'];
                            let attachmentId = response['data']['id'] ?? '0';

                            $("img.avatar.easyavup_avatar, .avatar").attr('src', imageUrl).attr('srcset', imageUrl);
                            $(".easyavup_deleteBtn").attr('data-id', attachmentId);
                            $('.easyavup_changePictureBtn').removeClass('easyavup_btn-loading');
                            showSuccessMessage('Profile picture updated successfully.')
                        }

                    },
                    error: function(data, status) {
                        console.log(data, status);
                        alert('Something is missing!');
                    }
                });

                // previewImage(file);
            }
        });

    }

    function previewImage( file ) {
        if (file && file.type.match('image.*')) {
            const reader = new FileReader();
            reader.onload = function(e) {
                $('body').find('.avatar').attr('src', e.target.result).attr('srcset', e.target.result);
            };
            reader.readAsDataURL(file);
        }
    }

    function validateFile(file) {
        // Check file type
        const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp'];
        if (!allowedTypes.includes(file.type)) {
            alert('Please select a valid image file (JPEG, PNG, GIF, or WebP).', 'error');
            return false;
        }
        
        if (file.size > easyavup_frontend_localize.easyavup_upload_limit) {
            alert('File size must be less than 2MB.', 'error');
            return false;
        }
        
        return true;
    }

    $('.easyavup_deleteBtn').click(function(e) {
        e.preventDefault();

        let update_profile_nonce = $('#easyavup-nonce').val() || '';
        var $this = $(this);

        if (!update_profile_nonce) {
            console.log('Soemthing Missing');
            return;
        }

        // Add loading state
        $this.addClass('easyavup_btn-loading').prop('disabled', true);
        
        $.ajax({
            url: easyavup_frontend_localize.ajax_url,
            type: "POST",
            dataType: 'json',
            timeout: 30000, 
            data: {
                 action: 'easyavup_remove_profile_picture',
                 nonce: update_profile_nonce,
            },
            success: function(response) {
                if (response && response['success'] ) {

                    // Reset avatar to default
                    const defaultAvatar = response.data && response.data.default ? response.data.default : '';
                    
                    if (defaultAvatar) {
                        $('.avatar').attr('src', defaultAvatar).attr('srcset', defaultAvatar);
                    }

                    $("#easyavup-avatar-id").val("");
                    $this.removeClass('easyavup_btn-loading').prop('disabled', false).attr('data-id', '0');
                    showSuccessMessage('Profile picture deleted successfully!');
                }
            },
            error: function() {
                console.log('Something is missing!');
            }
        });
    });



    // // Handle file selection
    // $('.easyavup_fileInput').change(function(e) {
    //     const file = e.target.files[0];
        
    //     if (file && file.type.startsWith('image/')) {
    //         const reader = new FileReader();
            
    //         reader.onload = function(e) {
    //             $('#easyavup_profileImg').attr('src', e.target.result);
    //             showSuccessMessage('Profile picture updated successfully!');
    //         };
            
    //         reader.readAsDataURL(file);
    //     } else if (file) {
    //         alert('Please select a valid image file.');
    //     }
        
    //     // Reset input value
    //     $(this).val('');
    // });

    // // Delete profile picture


    // // Show success message function
    function showSuccessMessage(message) {
        const $successMsg = $('#easyavup_successMessage');
        
        $successMsg.text(message).addClass('easyavup_show');
        
        setTimeout(function() {
            $successMsg.removeClass('easyavup_show');
        }, 3000);
    }

    // // Close popup with Escape key
    $(document).keydown(function(e) {
        if (e.key === 'Escape' || e.keyCode === 27) {
            closePopup();
        }
    });

});