<?php
/**
 * Plugin Name:       Easy Avatar Upload
 * Description:       Allows users to upload a custom profile picture using the WordPress media library with enhanced security and user experience. Shortcode : <strong>[easyavup_avatar mode="view" size=120]</strong>
 * Version:           1.2
 * Author:            Kamrul
 * Requires at least: 6.8
 * Requires PHP:      7.4
 * License:           GPL-3
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       easy-avatar-upload
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}


define( 'EASYAVUP__PATH', trailingslashit(plugin_dir_path(__FILE__)) );
define( 'EASYAVUP__URL', trailingslashit(plugins_url('/', __FILE__)) );
define( 'EASYAVUP__VERSION', '1.0.0');
define( 'EASYAVUP__FILE', __FILE__ );


/**
 * Main plugin class to handle all functionality.
 */
class EASYAVUP_MAIN {

    /**
     * Plugin instance.
     *
     * @var EASYAVUP_MAIN
     */
    private static $instance = null;

    /**
     * Get plugin instance.
     *
     * @return EASYAVUP_MAIN
     */
    public static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }


    /**
     * Constructor to hook into WordPress actions and filters.
     */
    public function __construct() {
        $this->load_dependencies();
        $this->define_admin_hooks();
        $this->define_public_hooks();
        $this->define_ajax_hooks();
    }

    public function load_dependencies() {
        /**
         * The class responsible for defining all actions that occur in the admin area.
         */
        require_once EASYAVUP__PATH . 'admin/class-easyavup-admin.php';

        /**
         * The class responsible for defining all actions that occur in the public-facing
         * side of the site.
         */
        require_once EASYAVUP__PATH . 'public/class-easyavup-public.php';

        /**
         * The class responsible for handling AJAX requests.
         */
        require_once EASYAVUP__PATH . 'includes/class-easyavup-ajax.php';
    }

    private function define_admin_hooks() {
        $Easyavup_Admin = new Easyavup_Admin();

        add_action( 'show_user_profile', array( $Easyavup_Admin, 'easyavup_add_profile_field' ), 99 );
        add_action( 'edit_user_profile', array( $Easyavup_Admin, 'easyavup_add_profile_field' ), 99 );
        add_action( 'admin_enqueue_scripts', array( $Easyavup_Admin, 'easyavup_enqueue_admin_scripts' ) ); 
        add_action( 'plugin_action_links_' . plugin_basename(__FILE__), array( $Easyavup_Admin, 'eastavyo_settings' ) ); 
    }

    private function define_public_hooks() {
        $plugin_public = new Easyavup_Public();

        add_action( 'init', array( $plugin_public, 'init' ) );

        add_shortcode( 'easyavup_avatar', array( $plugin_public, 'easyavup_easyavup_avatar') );
        add_action( 'wp_enqueue_scripts', array( $plugin_public, 'easyavup_enqueue_scripts' ) );
        add_action( 'wp_footer', array( $plugin_public, 'add_poupup_html' ), 99 );
    }


    private function define_ajax_hooks(){
        $Easyavup_Ajax = new Easyavup_Ajax();

        add_action( 'wp_ajax_easyavup_save_profile_picture', array( $Easyavup_Ajax, 'easyavup_save_profile_picture' ) );
        add_action( 'wp_ajax_easyavup_remove_profile_picture', array( $Easyavup_Ajax, 'easyavup_remove_profile_picture' ) );
    }

}

/**
 * Initialize plugin.
 */
function easyavup_init_plugin() {
    EASYAVUP_MAIN::get_instance();
}
add_action( 'plugins_loaded', 'easyavup_init_plugin' );

