(function($) {
    $(document).ready(function() {

        // Check if localization object exists
        if (typeof easyavup_localize === 'undefined') {
            console.error('Localization object not found.');
            return;
        }

        let selectedFile = null;
        
        if ( typeof wp !== "undefined" && typeof wp.media !== "undefined" ) {

            var mediaUploader;

            $('#easyavup_profile_back-wrap').on('click', '.easyavup_upload-area', function(e){
                e.preventDefault();

                if (mediaUploader) {
                    mediaUploader.open();
                    return;
                }

                mediaUploader = wp.media({
                    title: easyavup_localize.easyavup_strings.easyavup_selectImage || 'Select Profile Picture',
                    button: {
                        text: easyavup_localize.easyavup_strings.easyavup_useImage || 'Use This Image'
                    },
                    multiple: false,
                    library: {
                        type: 'image'
                    }
                });

                mediaUploader.on("select", function() {
                    var attachment = mediaUploader.state().get("selection").first().toJSON();

                    if (!attachment || !attachment.id) {
                        console.error('Invalid attachment selected.');
                        return;
                    }

                    const imageUrl = attachment.sizes?.medium?.url || attachment.url;

                    $("#easyavup-avatar-id").val(attachment.id);
                    $(".easyavup_current-avatar img, .avatar").attr('src', imageUrl);
                    $('.easyavup_message').html('');

                });

                mediaUploader.open();
            });
        } else {

            $('#easyavup_profile_back-wrap').on('click', '.easyavup_upload-area', function(e){
                e.preventDefault();

                $('#profile-picture-upload_manual').trigger('click');
            });

            $('body').on('change', '#profile-picture-upload_manual', function(){
                const file = this.files[0];

                if ( file ) {
                    selectedFile = file;
                    previewImage(file);
                }
            });

        }

        function previewImage( file ) {
            if (file && file.type.match('image.*')) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    $('body').find('.easyavup_avatar-circle img').attr('src', e.target.result);
                    $('body').find('.avatar').attr('src', e.target.result).attr('srcset', e.target.result);
                };
                reader.readAsDataURL(file);
            }
        }

        function validateFile(file) {
            // Check file type
            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp'];
            if (!allowedTypes.includes(file.type)) {
                alert('Please select a valid image file (JPEG, PNG, GIF, or WebP).', 'error');
                return false;
            }
            
            if (file.size > easyavup_localize.easyavup_upload_limit) {
                alert('File size must be less than 2MB.', 'error');
                return false;
            }
            
            return true;
        }


        $('body').on('click', '#easyavup_save_profile_picture', function(e){
            e.preventDefault();

            let attachmentId = $('#easyavup-avatar-id').val() || '';
            let update_profile_nonce = $('#easyavup-nonce').val() || '';
            var $this = $(this);


            if ( selectedFile != null ) {
                if ( !validateFile(selectedFile) ) {
                    selectedFile = null;
                };
            }

            // Validate required data
            if ( ( selectedFile == null  || attachmentId == '' ) && !update_profile_nonce ) {
                console.log('Missing Something');
                return;
            }

            const formData = new FormData();
            formData.append('action', 'easyavup_save_profile_picture');
            formData.append('nonce', update_profile_nonce);
            formData.append('attachment_id', parseInt(attachmentId, 10));
            formData.append('directfile', selectedFile);


            $this.text(easyavup_localize.easyavup_strings.updating || 'Updating...');

            $.ajax({
                url: easyavup_localize.ajax_url,
                type: "POST",
                dataType: 'json',
                timeout: 30000, 
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if ( response && response['success'] ) {
                        $this.text(easyavup_localize.easyavup_strings.easyavup_updated || 'Updated');
                        $("#easyavup-remove-avatar-button").show();
                        $('.easyavup_message').html(easyavup_localize.easyavup_strings.easyavup_success || 'Profile picture updated successfully.').attr('class', 'easyavup_message added');
                    }
                },
                error: function(data, status) {
                    console.log(data, status);
                    alert('Something is missing!');
                }
            });

        });


        $("#easyavup-remove-avatar-button").on("click", function(e) {
            e.preventDefault();

            let update_profile_nonce = $('#easyavup-nonce').val() || '';
            var $this = $(this);

            if (!update_profile_nonce) {
                console.log('Soemthing Missing');
                return;
            }

            $this.text(easyavup_localize.easyavup_strings.easyavup_removing_btn || 'Removing...');

            $.ajax({
                url: easyavup_localize.ajax_url,
                type: "POST",
                dataType: 'json',
                timeout: 30000, 
                data: {
                     action: 'easyavup_remove_profile_picture',
                     nonce: update_profile_nonce,
                },
                success: function(response) {
                    if (response && response['success'] ) {
                        $this.text(easyavup_localize.easyavup_strings.easyavup_removed_btn || 'Removed');

                        // Reset avatar to default
                        const defaultAvatar = response.data && response.data.default ? response.data.default : '';
                        
                        if (defaultAvatar) {
                            $('.easyavup_current-avatar img, .avatar').attr('src', defaultAvatar);
                        }

                        $("#easyavup-avatar-id").val("");
                        $("#easyavup-remove-avatar-button").hide();
                        $('.easyavup_message').html(easyavup_localize.easyavup_strings.easyavup_removed || 'Avatar removed successfully.').attr('class', 'easyavup_message removed');
                    }
                },
                error: function() {
                    console.log('Something is missing!');
                }
            });

        });
    });
})(jQuery);