<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://#
 * @since             1.0.0
 * @package           Easy_Apis
 *
 * @wordpress-plugin
 * Plugin Name:       Easy APIs Simplify Api Integration
 * Description:       Easy APIs is a powerful yet user-friendly WordPress plugin designed to help developers and site owners integrate external APIs seamlessly. With an intuitive interface, customizable settings, and built-in request management, Easy APIs makes it simple to connect your website with third-party services without extensive coding.


 * Version:           1.0.0
 * Author:            Gurjaint Narwal
 * Author URI:        https://in.linkedin.com/in/gurjaint-narwal-02158215b
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       easy-apis-simplify-api-integration
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'EASY_APIS_SIMPLIFY_API_INTEGRATION_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-easy-apis-simplify-api-integration-activator.php
 */
function activate_easy_apis_simplify_api_integration() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-easy-apis-simplify-api-integration-activator.php';
	Easy_Apis_Simplify_Api_Integration_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-easy-apis-simplify-api-integration-deactivator.php
 */
function deactivate_easy_apis_simplify_api_integration() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-easy-apis-simplify-api-integration-deactivator.php';
	Easy_Apis_Simplify_Api_Integration_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_easy_apis_simplify_api_integration' );
register_deactivation_hook( __FILE__, 'deactivate_easy_apis_simplify_api_integration' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-easy-apis-simplify-api-integration.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_easy_apis_simplify_api_integration() {

	$plugin = new Easy_Apis_Simplify_Api_Integration();
	$plugin->run();

}
run_easy_apis_simplify_api_integration();
