<?php
/**
 * Admin UX
 *
 * @package Easy_Add_To_Cart_Links
 */

namespace DogCat\EACL;

/**
 * Admin-side UX hooks.
 *
 * @return void
 */
final class UX {
	/**
	 * Register admin hooks.
	 *
	 * @return void
	 */
	public static function init(): void {
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'assets' ) );
	}
	/**
	 * Enqueue Classic editor assets.
	 *
	 * @return void
	 */
	public static function assets(): void {
		wp_enqueue_style( 'eacl', plugins_url( 'admin/css/eacl.css', __DIR__ ), array(), '1.0.0' );
		wp_enqueue_script( 'eacl', plugins_url( 'admin/js/linkcontrol.js', __DIR__ ), array( 'jquery' ), '1.0.0', true );
	}
}
