<?php
/**
 * Link generation (relative cart URLs, variations, etc).
 *
 * @package Easy_Add_To_Cart_Links
 */

namespace DogCat\EACL;

/**
 * Build Add-to-Cart links.
 */
final class Links {

	/**
	 * Wire filters/shortcodes.
	 *
	 * @return void
	 */
	public static function init(): void {
		add_shortcode( 'eacl_link', array( __CLASS__, 'shortcode' ) );
	}
	/**
	 * Shortcode handler.
	 *
	 * @param  array<string,string> $atts Shortcode attributes.
	 * @return string
	 */
	public static function shortcode( $atts ): string {
		$a = shortcode_atts(
			array(
				'id'    => 0,
				'label' => __( 'Add to cart', 'easy-add-to-cart-links' ),
				'qty'   => 1,
			),
			$atts,
			'eacl_link'
		);

		$pid = absint( $a['id'] );
		$qty = max( 1, absint( $a['qty'] ) );
		if ( ! $pid ) {
			return '';
		}

		// MVP: emit standard Woo params, no custom nonce/query vars.
		$url = add_query_arg(
			array(
				'add-to-cart' => $pid,
			),
			home_url( '/' )
		);

		$url = wp_make_link_relative( $url );

		return sprintf(
			'<a class="eacl-link" href="%s" rel="nofollow noopener noreferrer">%s</a>',
			esc_url( $url ),
			esc_html( $a['label'] )
		);
	}
}
