<?php
/**
 * Plugin Name: Easy Add-to-Cart Links for WooCommerce
 * Description: Easily generate add-to-cart links for WooCommerce. Works in both Gutenberg and Classic Editor. 
 * Version:     1.3.3
 * Author:      DogCat / Connor Magyar
 * License:     GPL2+
 * Text Domain: easy-add-to-cart-links
 * Domain Path: /languages
 * Requires Plugins: woocommerce
 *
 * @package Easy_Add_To_Cart_Links
 */

defined( 'ABSPATH' ) || exit;

// Robust PSR-4-ish autoloader for DogCat\EACL\* classes.
spl_autoload_register(
	function ( $class ) {
		$prefix = 'DogCat\\EACL\\';
		if ( 0 !== strncmp( $class, $prefix, strlen( $prefix ) ) ) {
			return;
		}

		$rel     = substr( $class, strlen( $prefix ) );    // e.g. "Plugin" or "Admin\\Thing".
		$relPath = str_replace( '\\', '/', $rel );         // "Plugin" -> "Plugin".
		$base    = __DIR__ . '/includes/';

		// Candidate paths (order matters).
		$candidates = array();

		// 1) PSR-4 exact case: includes/Plugin.php.
		$candidates[] = $base . $relPath . '.php';

		// 2) Lowercase filename: includes/plugin.php.
		$candidates[] = $base . strtolower( $relPath ) . '.php';

		// 3) WP-style: includes/class-plugin.php (handles "REST" -> "rest" sanely).
		$leaf = basename( $relPath );
		$dir  = dirname( $relPath );
		$dir  = ( '.' === $dir ) ? '' : $dir . '/';
		$slug = strtolower( preg_replace( '/([a-z])([A-Z])/', '$1-$2', $leaf ) ); // "Plugin"->"plugin", "REST"->"rest".
		$candidates[] = $base . $dir . 'class-' . $slug . '.php';

		foreach ( $candidates as $file ) {
			if ( is_file( $file ) ) {
				require $file;
				return;
			}
		}
	}
);

// Boot safely (avoid fatals if a file isn’t found).
add_action(
	'plugins_loaded',
	function () {
		// Only run Woo features if Woo is present.
		$has_woo = class_exists( 'WooCommerce' );

		// Core orchestrator.
		if ( class_exists( 'DogCat\\EACL\\Plugin', /* autoload */ true ) && method_exists( 'DogCat\\EACL\\Plugin', 'init' ) ) {
			DogCat\EACL\Plugin::init();
			return;
		}

	}
);
