(function(){
	if ( ! window.wp || ! wp.apiFetch || ! window.EACL ) return;
	const apiFetch = wp.apiFetch;
	let t = null;
	const debounce = (fn, ms=200) => (...a)=>{ clearTimeout(t); t=setTimeout(()=>fn(...a), ms); };
	function popover(){ return document.querySelector('.block-editor-link-control'); }
	function ensureContainer(pop){
	  if (!pop) return null;
	  let wrap = pop.querySelector('.eacl-linkcontrol-group');
	  if (wrap) return wrap;
	  wrap = document.createElement('div');
	  wrap.className = 'eacl-linkcontrol-group';
	  wrap.style.display = 'none'; // hidden by default
	  wrap.innerHTML = '<style>.eacl-badge{display:inline-block;font-size:11px;line-height:1;border:1px solid #dcdcde;border-radius:2px;padding:2px 4px;margin-left:6px;color:#50575e;background:#f6f7f7}.eacl-linkcontrol-group{margin-top:8px;border-top:1px solid #e0e0e0;padding-top:8px}.eacl-li{padding:6px 8px;cursor:pointer;border-radius:2px}.eacl-li:hover{background:#f0f0f1}.eacl-muted{color:#6c7781}</style><div class="eacl-header eacl-muted" style="display:none">Add to Cart</div><div class="eacl-list"></div>';
	  const resultsRoot = pop.querySelector('.block-editor-link-control__search-results');
	  (resultsRoot || pop).appendChild(wrap);
	  return wrap;
	}

	function setUrl(url){
	  // Gutenberg LinkControl has two possible inputs we can see
	  const input =
	    document.querySelector('.block-editor-link-control__search-input input') ||
	    document.querySelector('.block-editor-link-control__field .components-text-control__input');

	  if (input){
	    try{
	      const proto = Object.getOwnPropertyDescriptor(HTMLInputElement.prototype, 'value');
	      if (proto && proto.set) proto.set.call(input, url);
	      else input.value = url;
	    }catch(e){ input.value = url; }

	    // fire both input & change; LinkControl listens to these
	    input.dispatchEvent(new Event('input',  { bubbles:true }));
	    input.dispatchEvent(new Event('change', { bubbles:true }));
	  }
	}

	function render(container, items){
	  const list   = container.querySelector('.eacl-list');
	  const header = container.querySelector('.eacl-header');
	  list.innerHTML = '';
	  if (!items || !items.length){
	    if (header) header.style.display = 'none';
	    container.style.display = 'none';
	    return;
	  }
	  // has results
	  if (header) header.style.display = 'block';
	  container.style.display = 'block';
	  items.forEach(i=>{
	    const row = document.createElement('div');
	    row.className = 'eacl-li';
	    row.innerHTML = `<strong>${i.title}</strong> <span class="eacl-badge">ADD TO CART</span><br><span class="eacl-muted">${i.url}</span>`;
		const pick = e => { e.preventDefault(); e.stopPropagation(); setUrl(i.url); };
		row.addEventListener('mousedown', pick);
		row.addEventListener('click',     pick);
	    list.appendChild(row);
	  });
	}

	async function fetchResults(q){
	  if (!q) return [];
	  // Prefer relative path for apiFetch; if someone accidentally passes a full URL, switch to `url`.
	  const relative = '/eacl/v1/search?s=' + encodeURIComponent(q);

	  // If EACL.rest.root looks like a full URL, use `url` instead of `path` to avoid wp-json duplication.
	  const looksAbsolute = EACL && EACL.rest && /^https?:\/\//i.test(EACL.rest.root || '');

	  const opts = looksAbsolute
	    ? { url: EACL.rest.root.replace(/\/+$/, '/') + 'search?s=' + encodeURIComponent(q) }
	    : { path: relative };

	  // wp.apiFetch injects the REST nonce automatically in the editor.
	  const res = await wp.apiFetch(opts).catch(()=>[]);
	  const out = [];
	  (res||[]).forEach(p=>{
	    if (p.type === 'simple' && p.url){
	      out.push({ title: p.name + ' — Add to Cart', url: p.url });
	    } else if (p.type === 'variable' && Array.isArray(p.variations)) {
	      p.variations.forEach(v=>{
	        if (!v.in_stock) return;
	        const attrs = (v.attributes && Object.values(v.attributes).join(' / ')) || '';
	        out.push({ title: `${p.name}${attrs ? ' — ' + attrs : ''} — Add to Cart`, url: v.url || '' });
	      });
	    }
	  });
	  return out;
	}


	function bind(){
	  const pop = popover();
	  if (!pop) return;
	  const wrap = ensureContainer(pop);
	  const input = pop.querySelector('.block-editor-link-control__search-input input, .block-editor-link-control__field .components-text-control__input');
	  if (!input) return;

	  const handler = debounce(async ()=>{
	    const q = (input.value || '').trim();
	    if (q.length < 2){ render(wrap, []); return; } // keep hidden until user types
	    render(wrap, await fetchResults(q));
	  }, 250);

	  input.addEventListener('input', handler);
	  // no initial call; stays hidden until user types
	}
	new MutationObserver(()=>bind()).observe(document.body, { childList:true, subtree:true });
})();