;(function () {
    if (!window.wp || !wp.apiFetch) { return;
    }

    /* ===================== CONFIG ===================== */
    var DEBUG = false;                           // set true to log
    var MODAL_REINSERT_DELAYS  = [80, 220];      // light passes for jQuery-UI menu
    var WINDOW_QUIET_MS        = 2200;           // detach observer after this long w/ no mutations
    var WINDOW_KEYS_IDLE_MS    = 700;            // keep observer while user is still typing
    var WINDOW_REINSERT_DELAYS = [0, 64, 180, 450, 900]; // outlast multi-phase repaints
    var WINDOW_SQUELCH_MS      = 900;            // suppress fetch briefly after selection
    function log()
    {
        if (DEBUG) { try { console.log.apply(console, ['[EACL classic]'].concat([].slice.call(arguments))); } catch(e) {}
        } }

    /* ===================== REST NONCE ===================== */
    (function () {
        var nonce = (window.EACL && EACL.rest && EACL.rest.nonce) || (window.wpApiSettings && window.wpApiSettings.nonce);
        if (!nonce) { return;
        }
        wp.apiFetch.use(
            function (options, next) {
                options = options || {};
                options.headers = Object.assign({}, options.headers, { 'X-WP-Nonce': nonce });
                return next(options);
            }
        );
    })();

    /* ===================== UTILS ===================== */
    function $(sel, ctx)
    {
        return (ctx||document).querySelector(sel); }
    function $all(sel, ctx)
    {
        return Array.prototype.slice.call((ctx||document).querySelectorAll(sel)); }
    function isVisible(el)
    {
        return !!(el && el.offsetParent !== null); }
    function toRel(u)
    {
        if (!u) { return '';
        }
        if (u.charAt(0) === '/') { return u;
        }
        try{ var a=document.createElement('a'); a.href=u; var r=(a.pathname||'/')+(a.search||'')+(a.hash||''); return r.charAt(0)==='/'?r:'/'+r; }
        catch(e){ return u; }
    }
    function getDialogRoot(fromNode)
    {
        var n = fromNode || document.body;
        return n.closest ? (n.closest('#wp-link-wrap, #wp-link, .link-modal') || document.body)
                     : ( $('#wp-link-wrap') || $('#wp-link') || document.body );
    }
    function sigOf(items)
    {
        if (!items || !items.length) { return '0';
        }
        try{
            var parts = [];
            items.forEach(
                function (p) {
                    if (p.type === 'simple') { parts.push('S|' + (p.name||'') + '|');
                    } else if (p.type === 'variable') { parts.push('V|' + (p.name||'') + '|' + (p.variations ? p.variations.length : 0));
                    }
                }
            );
            return parts.join('::') + '::len=' + items.length;
        }catch(e){ return String(items.length); }
    }

    /* ===================== INJECT NATIVE-ISH STYLES (WINDOW) ===================== */
    (function ensureStyle()
    {
        if (document.getElementById('eacl-classic-style')) { return;
        }
        var css = `
        #wp-link-wrap .query-results li[data-eacl],
        #wp-link .query-results li[data-eacl],
        #wp-link-wrap #search-results li[data-eacl],
        #wp-link #search-results li[data-eacl],
        #wp-link-wrap .link-selector-results li[data-eacl],
        #wp-link .link-selector-results li[data-eacl]{ cursor:pointer; }

        #wp-link-wrap .query-results li[data-eacl]:hover,
        #wp-link .query-results li[data-eacl]:hover,
        #wp-link-wrap #search-results li[data-eacl]:hover,
        #wp-link #search-results li[data-eacl]:hover,
        #wp-link-wrap .link-selector-results li[data-eacl]:hover,
        #wp-link .link-selector-results li[data-eacl]:hover{ background:#f0f0f1; }
        #wp-link-wrap .query-results li[data-eacl]:hover .eacl-title,
        #wp-link .query-results li[data-eacl]:hover .eacl-title,
        #wp-link-wrap #search-results li[data-eacl]:hover .eacl-title,
        #wp-link #search-results li[data-eacl]:hover .eacl-title,
        #wp-link-wrap .link-selector-results li[data-eacl]:hover .eacl-title,
        #wp-link .link-selector-results li[data-eacl]:hover .eacl-title{ font-weight:600; }

        #wp-link-wrap .query-results li[data-eacl].eacl-selected,
        #wp-link .query-results li[data-eacl].eacl-selected,
        #wp-link-wrap #search-results li[data-eacl].eacl-selected,
        #wp-link #search-results li[data-eacl].eacl-selected,
        #wp-link-wrap .link-selector-results li[data-eacl].eacl-selected,
        #wp-link .link-selector-results li[data-eacl].eacl-selected{ background:#f0f0f1; }
        #wp-link-wrap .query-results li[data-eacl].eacl-selected .eacl-title,
        #wp-link .query-results li[data-eacl].eacl-selected .eacl-title,
        #wp-link-wrap #search-results li[data-eacl].eacl-selected .eacl-title,
        #wp-link #search-results li[data-eacl].eacl-selected .eacl-title,
        #wp-link-wrap .link-selector-results li[data-eacl].eacl-selected .eacl-title,
        #wp-link .link-selector-results li[data-eacl].eacl-selected .eacl-title{ font-weight:600; }
        `;
        var st = document.createElement('style');
        st.id = 'eacl-classic-style';
        st.type = 'text/css';
        st.appendChild(document.createTextNode(css));
        document.head.appendChild(st);
    })();

    /* ===================== URL / EDITOR HELPERS ===================== */
    function getUrlField(fromNode)
    {
        var dlg = getDialogRoot(fromNode);
        return $('#wp-link-url', dlg) || dlg.querySelector('input[type="url"], input[name="url"], input#url, input[name="wp-link-url"]');
    }
    function setUrlScoped(val, fromNode)
    {
        var uf = getUrlField(fromNode);
        if (!uf) { return false;
        }
        uf.value = toRel(val || '');
        uf.dispatchEvent(new Event('input',  { bubbles:true }));
        uf.dispatchEvent(new Event('change', { bubbles:true }));
        uf.dispatchEvent(new KeyboardEvent('keyup', { bubbles:true, key:'Enter' }));
        var sb = $('#wp-link-submit', getDialogRoot(fromNode)) || $('#wp-link-update', getDialogRoot(fromNode));
        if (sb) { sb.removeAttribute('disabled');
        }
        return true;
    }
    function clickLinkOptions(fromNode)
    {
        var dlg = getDialogRoot(fromNode);
        var btns = $all('button, a', dlg);
        for (var i=0;i<btns.length;i++){
            var t = (btns[i].textContent || '').trim().toLowerCase();
            if (!t) { continue;
            }
            if (t.includes('link options') || t.includes('options') || t.includes('advanced')) { btns[i].click(); return true; }
        }
        var gear = dlg.querySelector('.dashicons-admin-generic, .dashicons-editor-help');
        if (gear && gear.closest('button,a')) { gear.closest('button,a').click(); return true; }
        return false;
    }
    function ensureWindowThenSetUrl(val, fromNode)
    {
        if (setUrlScoped(val, fromNode)) { return;
        }
        if (!clickLinkOptions(fromNode)) { return;
        }
        var tries=0, intv=setInterval(
            function () {
                if (setUrlScoped(val, fromNode) || ++tries > 25) { clearInterval(intv);
                }
            }, 100
        );
    }
    function insertDirectToEditor(url)
    {
        var href = toRel(url);
        try {
            if (window.tinymce && tinymce.activeEditor) {
                tinymce.activeEditor.execCommand('mceInsertLink', false, { href: href });
                var close = $('#wp-link-cancel') || $('.ui-dialog-titlebar-close');
                if (close) { close.click();
                }
                return true;
            }
        } catch(e){}
        return false;
    }
    function setComboValue(input, val)
    {
        if (!input) { return;
        }
        try {
            input.value = toRel(val || '');
            input.dispatchEvent(new Event('input',  { bubbles:true }));
            input.dispatchEvent(new Event('change', { bubbles:true }));
            input.dispatchEvent(new KeyboardEvent('keyup', { bubbles:true, key:'Enter' }));
        } catch(e){}
    }

    /* ===================== VISUAL BADGE ===================== */
    function badge(text)
    {
        var b = document.createElement('span');
        b.textContent = text.toUpperCase();
        b.style.fontSize   = '10px';
        b.style.fontWeight = '600';
        b.style.lineHeight = '1';
        b.style.padding    = '2px 6px';
        b.style.borderRadius = '999px';
        b.style.border     = '1px solid #dcdcde';
        b.style.background = '#f6f7f7';
        b.style.color      = '#50575e';
        b.style.whiteSpace = 'nowrap';
        return b;
    }

    /* ===================== jQuery-UI DATA (Modal crash guard) ===================== */
    function setAutocompleteData(li, title, url)
    {
        var rel = toRel(url);
        if (window.jQuery) {
            try {
                jQuery(li).data(
                    'ui-autocomplete-item', {
                        label: title,
                        value: rel,
                        ID: 0,
                        permalink: rel
                    }
                );
            } catch(e){}
        }
    }

    /* ===================== WINDOW (Link Options) ===================== */
    function getWindowListInfo()
    {
        var dlg = getDialogRoot();
        var list = dlg.querySelector(
            '.query-results ul, .query-results ol,'+
            '#search-results ul, #search-results ol,'+
            '.link-selector-results ul, .link-selector-results ol'
        );
        if (list && isVisible(list)) return { list: list, container: list.parentNode, dlg: dlg };

        // Heuristic: list below the Search field (prevents inserting above headers)
        var search = $('#wp-link-search', dlg) || dlg.querySelector('input[type="search"]');
        if (search) {
            var sbox = search.getBoundingClientRect();
            var candidates = $all('ul, ol', dlg).filter(isVisible).filter(
                function (el) {
                    var r = el.getBoundingClientRect();
                    return r.top > (sbox.bottom + 8);
                }
            );
            if (candidates.length) return { list: candidates[0], container: candidates[0].parentNode, dlg: dlg };
        }
        return { list: null, container: null, dlg: dlg };
    }

    var windowObserver = null;
    var windowObsTarget = null;
    var windowQuietTimer = null;
    var windowKeysIdleTimer = null;
    var windowRaf = null;
    var lastWindowItems = [];
    var lastWindowSig = 'init';
    var windowSquelchUntil = 0;
    var currentWindowReq = 0; // request-id gate for Window fetches

    function detachWindowObserver()
    {
        if (windowObserver) { try { windowObserver.disconnect(); } catch(e){} }
        windowObserver = null;
        windowObsTarget = null;
        if (windowQuietTimer) { clearTimeout(windowQuietTimer); windowQuietTimer = null; }
        if (windowKeysIdleTimer) { clearTimeout(windowKeysIdleTimer); windowKeysIdleTimer = null; }
    }

    function scheduleQuietDetach()
    {
        if (windowQuietTimer) { clearTimeout(windowQuietTimer);
        }
        windowQuietTimer = setTimeout(detachWindowObserver, WINDOW_QUIET_MS);
    }
    function pokeKeysIdle()
    {
        if (windowKeysIdleTimer) { clearTimeout(windowKeysIdleTimer);
        }
        windowKeysIdleTimer = setTimeout(detachWindowObserver, WINDOW_KEYS_IDLE_MS);
    }

    function attachWindowObserverSmart()
    {
        var info = getWindowListInfo();
        if (!info.container) { return;
        }
        if (windowObsTarget === info.container && windowObserver) { return;
        }

        detachWindowObserver(); // clean previous

        windowObsTarget = info.container;
        windowObserver = new MutationObserver(
            function () {
                scheduleQuietDetach(); // keep alive slightly longer after each mutation
                if (windowRaf) { cancelAnimationFrame(windowRaf);
                }
                windowRaf = requestAnimationFrame(
                    function () {
                        reinsertWindowInline(true/*fromMutation*/); }
                );
            }
        );

        // Watch only direct children; Core typically swaps the UL/OL
        windowObserver.observe(info.container, { childList:true });
        scheduleQuietDetach();
    }

    // PERF: detach when tab hidden
    document.addEventListener(
        'visibilitychange', function () {
            if (document.hidden) { detachWindowObserver();
            }
        }
    );

    function currentEaclCount(list)
    {
        return list ? list.querySelectorAll('li[data-eacl]').length : 0;
    }
    function clearWindowInline(list)
    {
        if (!list) { return;
        }
        $all('li[data-eacl]', list).forEach(
            function (li) {
                li.remove(); }
        );
    }

    function selectOnly(li)
    {
        if (!li || !li.parentNode) { return;
        }
        $all('li[data-eacl].eacl-selected', li.parentNode).forEach(
            function (n) {
                n.classList.remove('eacl-selected'); n.removeAttribute('aria-selected'); }
        );
        li.classList.add('eacl-selected');
        li.setAttribute('aria-selected','true');
    }

    function makeWindowRow(title, url, scopeNode)
    {
        var PADDING_Y = 6, INDENT_X = 12;

        var li = document.createElement('li');
        li.setAttribute('data-eacl','1');
        li.setAttribute('role','option');
        li.setAttribute('tabindex','0');

        // Native-ish layout: title left, badges right
        li.style.display = 'flex';
        li.style.alignItems = 'center';
        li.style.justifyContent = 'space-between';
        li.style.gap = '12px';
        li.style.padding = PADDING_Y + 'px 0';

        var left = document.createElement('span');
        left.className = 'eacl-title';
        left.textContent = title;
        left.style.paddingLeft = INDENT_X + 'px';

        var right = document.createElement('span');
        right.className = 'eacl-tags';
        right.style.display = 'inline-flex';
        right.style.gap = '6px';
        right.appendChild(badge('PRODUCT'));
        right.appendChild(badge('ADD TO CART'));

        function activate(ev)
        {
            if (ev) { ev.preventDefault(); ev.stopPropagation(); if (ev.stopImmediatePropagation) { ev.stopImmediatePropagation();
            } }
            selectOnly(li);
            // Prevent any immediate re-fetch from URL field changes
            windowSquelchUntil = Date.now() + WINDOW_SQUELCH_MS;

            // Single-click insert now and next tick (wins any late handlers)
            setUrlScoped(url, scopeNode);
            setTimeout(
                function () {
                    setUrlScoped(url, scopeNode); }, 0
            );

            var uf = getUrlField(scopeNode); if (uf) { uf.focus();
            }
        }

        // Single-click via capture-phase mousedown; keep keyboard & click too
        li.addEventListener('mousedown', activate, true);
        li.addEventListener('click', activate, false);
        li.addEventListener(
            'keydown', function (e) {
                if (e.key==='Enter'||e.key===' ') { activate(e);
                } }, false
        );

        // Native-like hover/focus highlight
        li.addEventListener(
            'mouseenter', function () {
                selectOnly(li); }
        );
        li.addEventListener(
            'focus', function () {
                selectOnly(li); }, true
        );

        li.appendChild(left);
        li.appendChild(right);
        return li;
    }

    function renderWindowInline(items)
    {
        var info = getWindowListInfo();
        if (!info.list) { return false;
        }

        // If our rows are already present and the signature hasn't changed, skip re-render
        var desiredSig = sigOf(items);
        if (currentEaclCount(info.list) > 0 && desiredSig === lastWindowSig) { return true;
        }

        clearWindowInline(info.list);

        if (Array.isArray(items) && items.length) {
            var frag = document.createDocumentFragment();
            items.forEach(
                function (p) {
                    if (p.type === 'simple') { frag.appendChild(makeWindowRow(p.name, p.url, info.list));
                    } else if (p.type === 'variable' && Array.isArray(p.variations)) {
                        p.variations.forEach(
                            function (v) {
                                var attrs = v.attributes ? Object.values(v.attributes).join(' / ') : '';
                                frag.appendChild(makeWindowRow(p.name + (attrs ? ' — ' + attrs : ''), v.url, info.list));
                            }
                        );
                    }
                }
            );
            if (info.list.firstChild) { info.list.insertBefore(frag, info.list.firstChild);
            } else { info.list.appendChild(frag);
            }
        }

        lastWindowSig = desiredSig;
        return true;
    }

    function reinsertWindowInline()
    {
        var ok = renderWindowInline(lastWindowItems);
        if (!ok) { return;
        }
        WINDOW_REINSERT_DELAYS.forEach(
            function (d) {
                setTimeout(
                    function () {
                        renderWindowInline(lastWindowItems); }, d
                );
            }
        );
    }

    /* ===================== MODAL (TinyMCE combobox) ===================== */
    function isModalCombo(el)
    {
        return el && el.matches('input.ui-autocomplete-input[role="combobox"]')
           && el.id !== 'wp-link-url' && el.id !== 'wp-link-search';
    }
    function getModalMenu(combo)
    {
        if (!combo) { return null;
        }
        var owns = combo.getAttribute('aria-owns');
        var ul = owns ? document.getElementById(owns) : null;
        if (!ul) { ul = document.querySelector('.ui-autocomplete, .ui-menu');
        }
        return ul || null;
    }
    function clearModalInline(menu)
    {
        if (!menu) { return;
        }
        $all('li[data-eacl]', menu).forEach(
            function (li) {
                li.remove(); }
        );
    }

    function makeModalRow(title, url, combo)
    {
        var li = document.createElement('li');
        li.className = 'ui-menu-item';
        li.setAttribute('data-eacl','1');
        li.setAttribute('role','option');

        // Attach jQuery-UI data so WP core handlers don't crash on menuselect/menufocus
        setAutocompleteData(li, title, url);

        var div = document.createElement('div');
        div.className = 'ui-menu-item-wrapper';
        div.style.display = 'flex';
        div.style.alignItems = 'center';
        div.style.justifyContent = 'space-between';
        div.style.gap = '8px';

        var left = document.createElement('span');
        left.className = 'eacl-title';
        left.textContent = title;

        var right = document.createElement('span');
        right.className = 'eacl-tags';
        right.style.display = 'inline-flex';
        right.style.gap = '6px';
        right.appendChild(badge('PRODUCT'));
        right.appendChild(badge('ADD TO CART'));

        // Prevent jQuery-UI from stealing focus / double-select
        div.addEventListener(
            'mousedown', function (e) {
                e.preventDefault(); e.stopPropagation(); if (e.stopImmediatePropagation) { e.stopImmediatePropagation();
                }
            }, true
        );

        function activate(e)
        {
            e.preventDefault(); e.stopPropagation(); if (e.stopImmediatePropagation) { e.stopImmediatePropagation();
            }
            setComboValue(combo, url);
            if (!insertDirectToEditor(url)) { ensureWindowThenSetUrl(url, combo);
            }
        }
        div.addEventListener('click', activate, true);

        div.appendChild(left);
        div.appendChild(right);
        li.appendChild(div);
        return li;
    }

    function renderModalInline(items, combo)
    {
        var menu = getModalMenu(combo);
        if (!menu) { return false;
        }

        clearModalInline(menu);

        if (Array.isArray(items) && items.length) {
            var frag = document.createDocumentFragment();
            items.forEach(
                function (p) {
                    if (p.type === 'simple') { frag.appendChild(makeModalRow(p.name, p.url, combo));
                    } else if (p.type === 'variable' && Array.isArray(p.variations)) {
                        p.variations.forEach(
                            function (v) {
                                var attrs = v.attributes ? Object.values(v.attributes).join(' / ') : '';
                                frag.appendChild(makeModalRow(p.name + (attrs ? ' — ' + attrs : ''), v.url, combo));
                            }
                        );
                    }
                }
            );
            if (menu.firstChild) { menu.insertBefore(frag, menu.firstChild); } else { menu.appendChild(frag);
            }
        }
        return true;
    }

    /* ===================== FETCH + DEBOUNCE (with req-id gate) ===================== */
    var timer = null;

    function fetchNow(q, where, anchor)
    {
        if (where === 'window') { currentWindowReq++;
        }
        var myReqId = (where === 'window') ? currentWindowReq : 0;

        wp.apiFetch({ path: 'eacl/v1/search?s=' + encodeURIComponent(q) })
        .then(
            function (res) {
                if (where === 'window') {
                    if (myReqId !== currentWindowReq) { return; // stale response, ignore
                    }
                    lastWindowItems = res || [];
                    attachWindowObserverSmart();   // attaches and auto-detaches after quiet period
                    reinsertWindowInline();        // initial render + staged follow-ups
                } else {
                    if (!renderModalInline(res || [], anchor)) { /* no menu yet */ }
                    MODAL_REINSERT_DELAYS.forEach(
                        function (d) {
                            setTimeout(
                                function () {
                                       renderModalInline(res || [], anchor); }, d
                            ); }
                    );
                }
            }
        )
        .catch(
            function () {
                if (where === 'window') {
                    if (myReqId !== currentWindowReq) { return;
                    }
                    lastWindowItems = [];
                    attachWindowObserverSmart();
                    reinsertWindowInline();
                } else {
                    renderModalInline([], anchor);
                }
            }
        );
    }

    // Only the Window SEARCH field should trigger fetching (NOT the URL field)
    function isWindowSearch(el)
    {
        return el && el.id === 'wp-link-search'; }

    function schedule(q, where, anchor)
    {
        if (where === 'window' && Date.now() < windowSquelchUntil) { return; // suppress right after selection
        }

        if (timer) { clearTimeout(timer);
        }
        if (!q || q.length < 2) {
            if (where === 'window') {
                // Don’t clear rows on short input; just let them be and detach later
                pokeKeysIdle();
            } else {
                renderModalInline([], anchor);
            }
            return;
        }

        if (where === 'window') {
            attachWindowObserverSmart(); // ensure we watch repaints while typing
            pokeKeysIdle();              // keep observer alive while user is active
        }

        timer = setTimeout(
            function () {
                fetchNow(q, where, anchor); }, 160
        );
    }

    /* ===================== BINDINGS ===================== */
    // Disconnect observer when Window search blurs (perf)
    document.addEventListener(
        'blur', function (e) {
            var t = e && e.target;
            if (isWindowSearch(t)) { detachWindowObserver();
            }
        }, true
    );

    document.addEventListener(
        'focus', function (e) {
            var t = e && e.target; if (!t) { return;
            }
            if (isWindowSearch(t)) {       schedule((t.value||'').trim(), 'window', t);
            } else if (isModalCombo(t)) {    schedule((t.value||'').trim(), 'modal', t);
            }
        }, true
    );

    document.addEventListener(
        'input', function (e) {
            var t = e && e.target; if (!t) { return;
            }
            if (isWindowSearch(t)) {       schedule((t.value||'').trim(), 'window', t);
            } else if (isModalCombo(t)) {    schedule((t.value||'').trim(), 'modal', t);
            }
        }, true
    );

    document.addEventListener(
        'keyup', function (e) {
            var t = e && e.target; if (!t) { return;
            }
            if (isWindowSearch(t)) {       schedule((t.value||'').trim(), 'window', t);
            } else if (isModalCombo(t)) {    schedule((t.value||'').trim(), 'modal', t);
            }
        }, true
    );

    /* ===================== BOOT ===================== */
    (function boot()
    {
        var s = $('#wp-link-search');
        if (s && isVisible(s)) { schedule((s.value||'').trim(), 'window', s);
        }
    })();

})();
