<?php

/**
 * E2pdf Zip Helper
 * 
 * @copyright  Copyright 2017 https://e2pdf.com
 * @license    GPLv3
 * @version    1
 * @link       https://e2pdf.com
 * @since      0.00.01
 */
if (!defined('ABSPATH')) {
    die('Access denied.');
}

class Helper_E2pdf_SimpleXMLElement extends \SimpleXMLElement {

    /**
     * Add CDATA text in a node 
     * @param string $cdata_text The CDATA value  to add 
     */
    private function addCData($cdata_text) {
        $node = dom_import_simplexml($this);
        $no = $node->ownerDocument;
        $node->appendChild($no->createCDATASection($cdata_text));
    }

    /**
     * Create a child with CDATA value 
     * @param string $name The name of the child element to add. 
     * @param string $cdata_text The CDATA value of the child element. 
     */
    public function addChildCData($name, $cdata_text) {
        $child = $this->addChild($name);
        $child->addCData($cdata_text);
    }

    /**
     * Add SimpleXMLElement code into a SimpleXMLElement 
     * @param SimpleXMLElement $append 
     */
    public function appendXML($append) {
        if ($append) {
            if (strlen(trim((string) $append)) == 0) {
                $xml = $this->addChild($append->getName());
                foreach ($append->children() as $child) {
                    $xml->appendXML($child);
                }
            } else {
                $xml = $this->addChild($append->getName(), (string) $append);
            }
            foreach ($append->attributes() as $n => $v) {
                $xml->addAttribute($n, $v);
            }
        }
    }

}
