<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Plugin Name: E-Transfer Gateway
 * Description: Plugin that provides E-Transfer capabilities for Canadians.
 * Version: 1.0.0
 * Author: Infantryman
 * License: GPL version 2 or later - http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * @class 		WC_Gateway_emt
 * @extends		WC_Payment_Gateway
 * @since 3.9.0
 */
 
add_filter( 'woocommerce_payment_gateways', 'add_etransfer_gateway' );

add_action( 'plugins_loaded', 'woocommerce_eTransfer_init', 0 );

	/**
	 * Add the gateway to woocommerce
	 */
function add_etransfer_gateway( $methods ) {
	$methods[] = 'WC_Gateway_emt';
	return $methods;
}

function woocommerce_eTransfer_init() {

	if ( ! class_exists( 'WC_Payment_Gateway' ) ) {
    	return;
 	};
	// include this Gateway Class
	include_once( 'gateway-interac.php' );

	DEFINE ('PLUGIN_DIR', plugins_url( basename( plugin_dir_path( __FILE__ ) ), basename( __FILE__ ) ) . '/' );

	/**
	 * Email Money Transfer Gateway Class
	 */
	class WC_Gateway_emt extends WC_Payment_Gateway {

		public function __construct() {

	        // Register plugin information
		    $this->id = 'emt';
	        // Load plugin checkout icon
		    $this->icon = PLUGIN_DIR . 'images/e-transfer.jpg';
			$this->method_title = __( 'Email Money Transfer', 'emt_gateway' );
			$this->method_description = __( 'Add E-Tranfer capabilities to your website.', 'emt_gateway' );
		    $this->has_fields = true;

        	// Create plugin fields and settings
			$this->init_form_fields();
			$this->init_settings();

			// Get settings
			$this->title              = $this->get_option( 'title' );
			$this->description        = $this->get_option( 'description' );
			$this->enable_for_methods = $this->get_option( 'enable_for_methods', array() );

        	// Add hooks
			add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
			add_action( 'woocommerce_thankyou', array( $this, 'thankyou_page' ), 1 );

		}

      /**
       * Initialize Gateway Settings Form Fields.
       */
	    public function init_form_fields() {
	    	$shipping_methods = array();

			if ( is_admin() ) {
				foreach ( WC()->shipping()->load_shipping_methods() as $method ) {
					$shipping_methods[ $method->id ] = $method->get_method_title();
				}
			}

	    	$this->form_fields = array(
				'enabled' => array(
					'title'       => __( 'Enable EMT', 'emt_gateway' ),
					'label'       => __( 'Enable Email Money Transfer', 'emt_gateway' ),
					'type'        => 'checkbox',
					'description' => '',
					'default'     => 'no'
				),
				'title' => array(
					'title'       => __( 'Title', 'emt_gateway' ),
					'type'        => 'text',
					'description' => __( 'Payment method description that the customer will see on your checkout.', 'emt_gateway' ),
					'default'     => __( 'Email Money Transfer', 'emt_gateway' ),
				),
				'description' => array(
					'title'       => __( 'Description', 'emt_gateway' ),
					'type'        => 'textarea',
					'description' => __( 'Payment method instructions that the customer will see on your website.', 'emt_gateway' ),
					'default'     => __( 'After placing your order, please send an E-Transfer to example@domain.com (No question or password required). For tracking purposes, please include your order number in the E-Transfer transaction.', 'emt_gateway' ),
				),
				'enable_for_methods' => array(
					'title'             => __( 'Enable for Shipping Methods', 'emt_gateway' ),
					'type'              => 'multiselect',
					'class'             => 'wc-enhanced-select',
					'css'               => 'width: 450px;',
					'default'           => '',
					'description'       => __( 'If E-Transfer is only available for certain methods, set it up here. Leave blank to enable for all methods.', 'emt_gateway' ),
					'options'           => $shipping_methods,
					'custom_attributes' => array(
						'data-placeholder' => __( 'Select Shipping Methods', 'emt_gateway' )
					)
				),
	            'emt_order_status'   => array(
	                'title'          => __( 'Order Status', 'emt_gateway' ),
	                'type'           => 'select',
					'default'        => 'on-hold',
					'description' => __( 'Order status after it is submitted by customers', 'emt_gateway' ),
	                'options'        => array(
	                    'on-hold' => 'on-hold',
	                    'pending'  => 'Pending',
	                    'processing'  => 'Processing'

	                )
	            )
	 	   	);
	    }


        /**
		 * Check If The Gateway Is Available For Use
		 *
		 * @return bool
		 */
		public function is_available() {
			$order = null;

			if ( ! $this->enable_for_virtual ) {
				if ( WC()->cart && ! WC()->cart->needs_shipping() ) {
					return false;
				}

				if ( is_page( wc_get_page_id( 'checkout' ) ) && 0 < get_query_var( 'order-pay' ) ) {
					$order_id = absint( get_query_var( 'order-pay' ) );
					$order    = wc_get_order( $order_id );

					// Test if order needs shipping.
					$needs_shipping = false;

					if ( 0 < sizeof( $order->get_items() ) ) {
						foreach ( $order->get_items() as $item ) {
							$_product = $order->get_product_from_item( $item );

							if ( $_product->needs_shipping() ) {
								$needs_shipping = true;
								break;
							}
						}
					}

					$needs_shipping = apply_filters( 'woocommerce_cart_needs_shipping', $needs_shipping );

					if ( $needs_shipping ) {
						return true;
					}
				}
			}

			if ( ! empty( $this->enable_for_methods ) ) {
				// -------- Updated in ver. 1.0.1:
				// Apparently, in presence of other plugins, this plugin was called before woocommerce was initiated.
				// So I just added a few lines to check if WC()->session exists.
				if ( !is_object( WC() ) ) {
					return false;
				}
				if ( !is_object( WC()->session)) {
					return false;
				}
				//-------- end of update

				// Only apply if all packages are being shipped via local pickup
				$chosen_shipping_methods_session = WC()->session->get( 'chosen_shipping_methods' );

				if ( isset( $chosen_shipping_methods_session ) ) {
					$chosen_shipping_methods = array_unique( $chosen_shipping_methods_session );
				} else {
					$chosen_shipping_methods = array();
				}

				$check_method = false;

				if ( is_object( $order ) ) {
					if ( $order->get_shipping_method() ) {
						$check_method = $order->get_shipping_method();
					}

				} elseif ( empty( $chosen_shipping_methods ) || sizeof( $chosen_shipping_methods ) > 1 ) {
					$check_method = false;
				} elseif ( sizeof( $chosen_shipping_methods ) == 1 ) {
					$check_method = $chosen_shipping_methods[0];
				}

				if ( ! $check_method ) {
					return false;
				}

				$found = false;

				foreach ( $this->enable_for_methods as $method_id ) {
					if ( strpos( $check_method, $method_id ) === 0 ) {
						$found = true;
						break;
					}
				}

				if ( ! $found ) {
					return true;
				}
			}

			return parent::is_available();
		}


	    /**
	     * Process the payment and return the result
	     *
	     * @param int $order_id
	     * @return array
	     */
		public function process_payment( $order_id ) {

			$order = wc_get_order( $order_id );

			// Changed in 2.3
			$status = !empty($this->emt_order_status) ? $this->emt_order_status : 'on-hold';
			$order->update_status( $status );

			// Reduce stock levels
			// $order->reduce_order_stock(); changed to
			wc_reduce_stock_levels( $order_id );

			// Remove cart
			WC()->cart->empty_cart();


			// Return thankyou redirect
			return array(
				'result' 	=> 'success',
				'redirect'	=> $this->get_return_url( $order )
			);
	
	}
	}
}

