<?php
if (!defined( 'WPINC' )) die;

/**
 * @var $this Dynomapper\ContentImport
 * @var $accessToken
 */
?>
<style>
    .lds-ring {
        display: inline-block;
        position: relative;
        width: 62px;
        height: 62px;
    }
    .lds-ring div {
        box-sizing: border-box;
        display: block;
        position: absolute;
        width: 50px;
        height: 50px;
        margin: 6px;
        border: 6px solid #2271b1;
        border-radius: 50%;
        animation: lds-ring 1.2s cubic-bezier(0.5, 0, 0.5, 1) infinite;
        border-color: #2271b1 transparent transparent transparent;
    }
    .lds-ring div:nth-child(1) {
        animation-delay: -0.45s;
    }
    .lds-ring div:nth-child(2) {
        animation-delay: -0.3s;
    }
    .lds-ring div:nth-child(3) {
        animation-delay: -0.15s;
    }
    @keyframes lds-ring {
        0% {
            transform: rotate(0deg);
        }
        100% {
            transform: rotate(360deg);
        }
    }
    #import-loader{
        position:fixed;
        z-index:999999;
        left:0;
        top:0;
        right:0;
        bottom:0;
        background:rgba(0, 0, 0, .3);
        display: flex;
        align-items:center;
        justify-content:center;
    }

    #import-loader .loader-notice{
        background: #FFFFFF;
        box-shadow: 0 0 10px 0 rgba(0, 0, 0, .2);
        display: flex;
        width: 500px;
        align-items:center;
        padding: 10px 20px;
    }

    #import-loader .loader-notice .stat{
        display: block;
        margin-top: 10px;
        font-size: 1rem;
    }

    #import-loader #failed-message{
        display: block;
        color: red;
        margin-top: 10px;
    }
</style>

<div class="wrap">
    <h1>DYNO Mapper Content Import</h1>

    <div id="import-loader" style="display:none;">
        <div class="loader-notice">
            <div style="margin-right:15px;">
                <div class="lds-ring"><div></div><div></div><div></div><div></div></div>
            </div>
            <p style="font-size:1.1rem;">
                Running content import process... Please do not leave this page or close this window. <br/>
                <span class="stat">Imported pages: <span id="imported-pages-count">0</span></span>

                <span id="failed-message" style="display:none">
                    An error occurred while importing: <span id="failed-message-text"></span> <br/>
                    <a href="admin.php?import=<?php echo esc_attr($this->pluginId); ?>">Restart Import</a>
                </span>
            </p>
        </div>
    </div>

    <form method="post" action="" id="content-import-form">
        <?php wp_nonce_field('content-import-credentials') ?>

        <table class="form-table" role="presentation">
            <tbody>
            <tr>
                <th scope="row">
                    <label for="input-create-menu">Create Menu</label>
                </th>
                <td>
                    <label for="input-create-menu">
                        <input name="createMenu" type="checkbox" id="input-create-menu" value="1" checked>
                        Uncheck this if you do not want to create a menu
                    </label>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="input-menu-name">Menu Name</label>
                </th>
                <td>
                    <input name="menuName" type="text" id="input-menu-name" value="DYNO Mapper" maxlength="100" class="regular-text" />
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="input-inc-metadata">Include Metadata</label>
                </th>
                <td>
                    <label for="input-inc-metadata">
                        <input name="includeMetadata" type="checkbox" id="input-inc-metadata" value="1" checked>
                        Populate meta description and keywords for supported SEO plugins.
                        We currently support Yoast SEO and All in One SEO plugin.
                    </label>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="input-exclude-content">Do Not Import Content</label>
                </th>
                <td>
                    <label for="input-exclude-content">
                        <input name="excludeContent" type="checkbox" id="input-exclude-content" value="1">
                        Check this if you only want the page structure without the page contents.
                    </label>
                </td>
            </tr>
            </tbody>
        </table>
        <p class="submit">
            <input type="submit" name="submit" id="form-submit" class="button button-primary" value="Run Import">
        </p>
    </form>
</div>

<script type="text/javascript">
    window.addEventListener('DOMContentLoaded', function() {
        (function($, t) {
            const loader = $('#import-loader');
            const importedPagesEl = $('#imported-pages-count');
            const submitButton = $('#form-submit');
            const failedMessage = $('#failed-message');
            const failedMessageText = $('#failed-message-text');

            function updateLoop(params) {
                $.ajax({
                    url: 'admin-ajax.php?action=dynomapper-content-import.importProcessApi',
                    type: 'POST',
                    data: params,
                    timeout: 1200000,
                    success: function(data) {
                        if (data.error) {
                            failedMessageText.text(data.reason);
                            failedMessage.show();
                        } else {
                            importedPagesEl.text(data.pages);

                            if (data.finish) {
                                window.location.href = 'admin.php?import=dynomapper-content-import'
                            } else {
                                updateLoop();
                            }
                        }
                    },
                }).fail(function() {
                    failedMessageText.text('Received bad status.');
                    failedMessage.show();
                });
            }

            $('#content-import-form').submit(function(e) {
                e.preventDefault();
                loader.show();
                $(submitButton).prop('disabled', true);

                const form = $(this);

                updateLoop({
                    accessToken: t,
                    createMenu: form.find('#input-create-menu').is(':checked') ? 1 : 0,
                    menuName: form.find('#input-menu-name').val(),
                    includeMetadata: form.find('#input-inc-metadata').is(':checked') ? 1 : 0,
                    excludeContent: form.find('#input-exclude-content').is(':checked') ? 1 : 0
                });
            });
        })(jQuery, <?php echo json_encode($accessToken); ?>);
    });
</script>
