<?php
/**
 * @var $this Dynomapper\ContentImport
 * @var $clientIdValue
 * @var $clientSecretValue
 * @var $authBaseUrlValue
 * @var $importFinish
 * @var $saveError WP_Error|null
 */

if (!defined( 'WPINC' )) die;

?>
<div class="wrap">
    <h1>DYNO Mapper Content Import</h1>

    <?php if($importFinish): ?>
        <div class="notice notice-success">
            <p style="font-size:1.5rem">Project has been imported successfully!</p>
        </div>
    <?php endif ?>

    <?php if(!empty($saved)): ?>
        <div class="notice notice-success">
            <p>
                Credentials saved!
            </p>
        </div>
    <?php endif ?>

    <?php if(!empty($saveError)): ?>
        <div class="notice notice-error">
            <p>
                <?php echo implode('<br/>', array_map(function($msg) {
                    return esc_html($msg);
                }, $saveError->get_error_messages())); ?>
            </p>
        </div>
    <?php endif ?>

    <div class="notice notice-info">
        <p>
            To obtain credentials, login to <a href="https://app.dynomapper.com" target="_blank">DYNO Mapper</a> as main account,
            then navigate to Settings > Developer and generate a Content Import Key.
        </p>
    </div>

    <form method="post" action="admin.php?import=<?php echo esc_attr($this->pluginId); ?>">
        <?php wp_nonce_field('content-import-credentials') ?>
        <table class="form-table" role="presentation">
            <tbody>
                <tr>
                    <th scope="row">
                        <label for="input-client-id">Client Id</label>
                    </th>
                    <td>
                        <input name="clientId" type="text" id="input-client-id" value="<?php echo esc_attr($clientIdValue); ?>" class="regular-text">
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="input-client-secret">Client Secret</label>
                    </th>
                    <td>
                        <input name="clientSecret" type="password" id="input-client-secret" value="<?php echo esc_attr($clientSecretValue); ?>" class="regular-text">
                    </td>
                </tr>
                <?php if($this->devMode): ?>
                    <th scope="row">
                        <label for="input-base-url">Auth Base URL</label>
                    </th>
                    <td>
                        <input name="authBaseUrl" type="text" id="input-base-url" value="<?php echo esc_attr($authBaseUrlValue); ?>" class="regular-text">
                    </td>
                <?php endif ?>
            </tbody>
        </table>
        <p class="submit">
            <button type="submit" class="button button-primary">Apply</button>
            <span style="margin: 0 10px;">or</span>
            <button type="submit" name="start" value="1" class="button button-primary">Start Import</button>
        </p>
    </form>
</div>
