<?php
if ( ! defined( 'ABSPATH' ) ) exit;

// Add settings link to plugins page
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'dynatafo_add_settings_link' );
function dynatafo_add_settings_link( $links ) {
    $settings_link = '<a href="admin.php?page=dynatafo-info">' . __( 'Info', 'dynamic-tags-for-elementor' ) . '</a>';
    array_unshift( $links, $settings_link );
    return $links;
}

/**
 * Safe escaping for dynamic tag outputs
 * Use this in your tag render() methods for extra security
 */
function dynatafo_safe_render( $content ) {
    echo wp_kses_post( $content );
}