<?php
/**
 * DYNATAFO_Loader Class
 * Handles the registration of Dynamic Tag groups and individual tags.
 */

if ( ! defined( 'ABSPATH' ) ) exit;

class DYNATAFO_Loader {

    /**
     * Constructor
     */
    public function __construct() {
        add_action( 'elementor/dynamic_tags/register', [ $this, 'register_dynatafo_content' ] );
    }

    /**
     * Register All Dynamic Tag Content
     *
     * @param \Elementor\Core\DynamicTags\Manager $dynamic_tags_manager
     */
    public function register_dynatafo_content( $dynamic_tags_manager ) {
        
        $groups = [
            'dynatafo-post-group'    => esc_html__( 'Post (DTE)', 'dynamic-tags-for-elementor' ),
            'dynatafo-archive-group' => esc_html__( 'Archive (DTE)', 'dynamic-tags-for-elementor' ),
            'dynatafo-site-group'    => esc_html__( 'Site (DTE)', 'dynamic-tags-for-elementor' ),
            'dynatafo-media-group'   => esc_html__( 'Media (DTE)', 'dynamic-tags-for-elementor' ),
            'dynatafo-author-group'  => esc_html__( 'Author (DTE)', 'dynamic-tags-for-elementor' ),
        ];

        foreach ( $groups as $id => $title ) {
            $dynamic_tags_manager->register_group( $id, [ 'title' => $title ] );
        }


        // Register standard tags
        $standard_tags = [
            'DYNATAFO_Post_Title_Tag'     => 'dynamic-tags/class-dynatafo-post-title.php',
            'DYNATAFO_Post_Date_Tag'      => 'dynamic-tags/class-dynatafo-post-date.php',
            'DYNATAFO_Post_Excerpt_Tag'   => 'dynamic-tags/class-dynatafo-post-excerpt.php',
            'DYNATAFO_Post_URL_Tag'       => 'dynamic-tags/class-dynatafo-post-url.php',
            'DYNATAFO_Archive_Title_Tag'  => 'dynamic-tags/class-dynatafo-archive-title.php',
            'DYNATAFO_Site_Title_Tag'     => 'dynamic-tags/class-dynatafo-site-title.php',
            'DYNATAFO_Site_Tagline_Tag'   => 'dynamic-tags/class-dynatafo-site-tagline.php',
            'DYNATAFO_Author_Name_Tag'    => 'dynamic-tags/class-dynatafo-author-name.php',
            'DYNATAFO_Featured_Image_Tag' => 'dynamic-tags/class-dynatafo-featured-image.php',
        ];

        foreach ( $standard_tags as $class_name => $file_path ) {
            $full_path = DYNATAFO_PATH . $file_path;
            
            if ( file_exists( $full_path ) ) {
                require_once $full_path;
                
                if ( class_exists( $class_name ) ) {
                    $dynamic_tags_manager->register( new $class_name() );
                }
            }
        }
    }
}