<?php
/**
 * Admin Logic for Dynamic Tags for Elementor
 */

if ( ! defined( 'ABSPATH' ) ) exit;

class DYNATAFO_Admin {

    public function __construct() {
        add_action( 'admin_menu', [ $this, 'add_plugin_menus' ] );
        add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'force_dynamic_tags_enabled' ] );
    }
      
      public function force_dynamic_tags_enabled() {
          $script = "window.addEventListener('elementor/init', () => {
              // This tells the Elementor JS that dynamic tags are available
              if ( elementor.config && elementor.config.dynamicTags ) {
                  elementor.config.dynamicTags.enabled = true;
              }
          });";
          wp_add_inline_script( 'elementor-editor', $script );
      }

      
    /**
     * Create the Menu and Submenu
     */
    public function add_plugin_menus() {
        add_menu_page(
            esc_html__( 'Dynamic Tags', 'dynamic-tags-for-elementor' ),
            esc_html__( 'Dynamic Tags', 'dynamic-tags-for-elementor' ),
            'manage_options',
            'dynatafo-info',
            [ $this, 'render_info_page' ],
            'dashicons-tag',
            110
        );
    }

    /**
     * Render Information / Promo Page
     */
    public function render_info_page() {
        $activation_data = get_option( 'dynatafo_activation_data', [] );
        ?>
        <div class="wrap">
            <h1><?php esc_html_e( 'Dynamic Tags for Elementor', 'dynamic-tags-for-elementor' ); ?></h1>
            <div class="welcome-panel">
                <div class="welcome-panel-content" style="background: #ffc106; padding: 15px 20px; border-radius: 5px;">
                    <h2><?php esc_html_e( 'Welcome to Dynamic Tags for Elementor!', 'dynamic-tags-for-elementor' ); ?></h2>
                    <p class="about-description"><?php esc_html_e( 'Congratulations! You have successfully enabled dynamic content for Elementor Free.', 'dynamic-tags-for-elementor' ); ?></p>
                </div>
            </div>

            <div class="card" style="max-width: 100%;">
                <h3><?php esc_html_e( 'System Status (Logged on Activation)', 'dynamic-tags-for-elementor' ); ?></h3>
                <p><strong>WP Version:</strong> <?php echo esc_html( $activation_data['wp_version'] ?? 'N/A' ); ?></p>
                <p><strong>PHP Version:</strong> <?php echo esc_html( $activation_data['php_version'] ?? 'N/A' ); ?></p>
                <p><strong>Active Date:</strong> <?php echo esc_html( $activation_data['activation_date'] ?? 'N/A' ); ?></p>
            </div>
        </div>
        <?php
    }

}
