<?php
/**
 * Plugin Name: Dynamic Tags for Elementor
 * Description: Enables dynamic tag functionality for the free version of Elementor and allows creating custom tags.
 * Version: 1.0.2
 * Author: Md Mustafa Kamal Hossain
 * Text Domain: dynamic-tags-for-elementor
 * Elementor tested up to: 3.35.5  
 * Elementor Pro tested up to: 3.35.5
 * Domain Path: /languages
 * Requires Plugins: elementor
 * License: GNU General Public License v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) exit;


define( 'DYNATAFO_VERSION', '1.0.2' );
define( 'DYNATAFO_PATH', plugin_dir_path( __FILE__ ) );
define( 'DYNATAFO_URL', plugin_dir_url( __FILE__ ) );
define( 'DYNATAFO_BASENAME', plugin_basename( __FILE__ ) );


function dynatafo_activate() {
    require_once DYNATAFO_PATH . 'includes/class-dynatafo-activator.php';
    DYNATAFO_Activator::activate();
}
register_activation_hook( __FILE__, 'dynatafo_activate' );

function dynatafo_deactivate() {
    require_once DYNATAFO_PATH . 'includes/class-dynatafo-deactivator.php';
    DYNATAFO_Deactivator::deactivate();
}
register_deactivation_hook( __FILE__, 'dynatafo_deactivate' );

add_action( 'plugins_loaded', 'dynatafo_init_plugin' );

function dynatafo_init_plugin() {
    if ( ! did_action( 'elementor/loaded' ) ) {
        add_action( 'admin_notices', 'dynatafo_fail_load_out_of_elementor' );
        return; 
    }

    $is_pro_active = defined( 'ELEMENTOR_PRO_VERSION' );

    // Load the Tag Loader (Frontend/Editor logic)
    require_once DYNATAFO_PATH . 'includes/class-dynatafo-loader.php';
    new DYNATAFO_Loader( $is_pro_active );

    // Load the Admin UI (Settings/Promo Pages)
    if ( is_admin() ) {
        require_once DYNATAFO_PATH . 'includes/class-dynatafo-admin.php';
        new DYNATAFO_Admin();
    }
}

/**
 * Admin notice if Elementor is missing
 */
function dynatafo_fail_load_out_of_elementor() {
    $screen = get_current_screen();
    if ( isset( $screen->parent_base ) && 'plugins' === $screen->parent_base ) {
        echo '<div class="error"><p>' . esc_html__( 'Dynamic Tags for Elementor requires Elementor to be installed and active.', 'dynamic-tags-for-elementor' ) . '</p></div>';
    }
}