/**
 * Dynamic Number Insertion - Admin JavaScript (backward compatible)
 */
jQuery(function ($) {

    const sel = {
        addRow: '.dynin-add-row',
        ruleRowEditing: '.dynin-rule-row.editing',
        rulesTable: '.dynin-rules-table',
        inputOriginal: 'input[name*="dynin_original"], input[name="dynin_original"]',
        inputReplacement: 'input[name*="dynin_replacement"], input[name="dynin_replacement"]',
        inputUrl: 'input[name*="dynin_url"], input[name="dynin_url"]',
        addForm: '#add-rule-form',
        adminRoot: '#dynin-admin'
    };

    if ($(sel.addRow).length && !$(sel.ruleRowEditing).length) {
        $(sel.addRow).find('input[name="dynin_original"], input[name="dni_original"]').first().trigger('focus');
    }
    if ($(sel.ruleRowEditing).length) {
        $(sel.ruleRowEditing).find('input:first').trigger('focus');
    }

    $(document).on('input', `${sel.inputOriginal}, ${sel.inputReplacement}`, function () {
        const $inp = $(this);
        const v = ($inp.val() || '').toString();
        // Разрешаем цифры, пробелы, (), - . +
        const ok = v === '' || /^[\d\s()\-.+]+$/.test(v);
        $inp.toggleClass('dynin-input-error', !ok).toggleClass('dynin-input-ok', ok);
    });

    $(document).on('blur', sel.inputUrl, function () {
        const $inp = $(this);
        let v = ($inp.val() || '').toString().trim();
        if (!v) return;

        v = v.replace(/^https?:\/\/[^/]+/i, '');
        if (v.charAt(0) !== '/') v = '/' + v;
        if (!v.endsWith('/')) v = v + '/';

        $inp.val(v);
    });

    $(sel.addForm).on('submit', function (e) {
        let hasError = false;
        const $form = $(this);

        $form.find('input[type="text"]').each(function () {
            const $f = $(this);
            if (($f.val() || '').toString().trim() === '') {
                $f.addClass('dynin-input-error');
                hasError = true;
            }
        });

        if (hasError) {
            e.preventDefault();
            window.alert('Please fill in all fields.');
            return false;
        }
    });

    $(document).on('keydown', function (e) {
        if (e.key === 'Escape' || e.keyCode === 27) {
            if ($(sel.ruleRowEditing).length) {
                const base = $(sel.adminRoot).data('base-url');
                window.location.href = base || (window.location.pathname + '?page=dynamic-number-insertion');
            }
        }
    });

    setTimeout(function () {
        $('.notice-success').not('.is-dismissible').fadeOut('slow');
    }, 5000);

    if (window.location.hash) {
        const ruleId = window.location.hash.substring(1);
        $(`tr[data-rule-id="${ruleId}"]`)
            .addClass('dynin-row-highlight');
        // Плавное снятие подсветки
        setTimeout(() => {
            $(`tr[data-rule-id="${ruleId}"]`).removeClass('dynin-row-highlight');
        }, 2000);
    }

});