<?php 
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

abstract class Guaven_Dxtag_Meta_Box {

    /**
     * Set up and add the meta box.
     */
    public static function add() {
        $screens = [ 'gvn_dxtag_rule' ];
        foreach ( $screens as $screen ) {
            add_meta_box(
                'guaven_dxtag_box',          // Unique ID
                __('Parameters','guaven_dxtag'), // Box title
                [ self::class, 'html' ],   // Content callback, must be of type callable
                $screen                  // Post type
            );
        }
    }
 
 
    /**
     * Save the meta box selections.
     *
     * @param int $post_id  The post ID.
     */
    public static function save( int $post_id, $post, $is_update ) {

        if (!isset($_POST['guaven_dxtag_nonce']) && !wp_verify_nonce($_POST['guaven_dxtag_nonce'], 'guaven_dxtag_nonce'))
		return;

        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
            return;

        if (!current_user_can('edit_post', $post_id))
            return;

        Guaven_Dxtag_Meta_Box::update_rule_meta($post_id,$_POST);
       
    }
    
    /**
     * checks if the rule is unpublished - if yes, then all created taxonomy data by this rule should be deleted
     *
     * @param  mixed $new
     * @param  mixed $old
     * @param  mixed $post
     * @return void
     */
    function sync_term_data( $new, $old, $post ) {
        if (  ( $post->post_type == 'gvn_dxtag_rule' ) &&  ( $new != 'publish' ) && ( $old == 'publish' )) {
            $term_to_delete=get_term_by( 'slug',$post->post_name,'gvn_dxtag');
            if(!empty($term_to_delete->term_id)){
                wp_delete_term( $term_to_delete->term_id, 'gvn_dxtag');
            }
        } 
    }

    
    /**
     * update_rule_meta
     * updates metadata of the rule
     * @param  mixed $post_id
     * @param  mixed $post_data - data that comes via $_POST variable
     * @return void
     */
    public static function update_rule_meta( $post_id,$post_data ) {

        update_post_meta($post_id,'cron_update_this_dxtag',time());

        $old = get_post_meta($post_id, 'guaven_dxtag_rule', true);

        $new = array();
        $rules = $post_data['dxrule'];
        $values = $post_data['dxvalue'];
        $operands=$post_data['dxoperand']; 
        $count = count( $rules );
        for ( $i = 0; $i < $count; $i++ ) {
            if ( $rules[$i] != '' ) {
                $new[$i]['dxrule'] = stripslashes( strip_tags( $rules[$i] ) );
                $new[$i]['dxvalue'] = stripslashes( $values[$i] );
                $new[$i]['dxoperand'] = stripslashes( $operands[$i] );
            }
        }

        if ( !empty( $new ) && $new != $old ){
            update_post_meta( $post_id, 'guaven_dxtag_rule', $new );
        } elseif ( empty($new) && $old ) {
            delete_post_meta( $post_id, 'guaven_dxtag_rule', $old );
        }
    }

 
    /**
     * Display the meta box HTML to the user.
     *
     * @param \WP_Post $post   Post object.
     */
    public static function html( $post ) {
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/guaven_dxtag-admin-meta-box.php';
    }

    /**
	 * rule_selector
	 * returns the list of available rules for the rule creater admin page
	 * @return void
	 */
	public static function rule_selector(){
		return [
			'wp:post_title'=>__('Post Title','guaven_dxtag'),
			'wp:post_type'=>__('Post Type','guaven_dxtag'),
			'wp:meta_key'=>__('Meta Key','guaven_dxtag'),
            'wp:term'=>__('WP Term','guaven_dxtag'),
			'woocommerce:_price'=>__('WooCommerce: Price','guaven_dxtag'),
			'woocommerce:_sale_price'=>__('WooCommerce: Sale Price','guaven_dxtag'),
			'woocommerce:_stock_status'=>__('WooCommerce: Stock Status','guaven_dxtag'),
			'woocommerce:_stock'=>__('WooCommerce: Stock Quantity','guaven_dxtag'),
			'woocommerce:product_cat'=>__('WooCommerce: Product Category','guaven_dxtag'),
		];
	}
	
	/**
	 * operand_selector
	 * returns logical operands for the rule creater admin page
	 * @return void
	 */
	public static function operand_selector(){
		return [
            'is equal to'=>'=',
            'is not equal to'=>'!=',
            'is not less than'=>'>=',
            'is less than'=>'<',
            'is IN'=>'IN',
            'contains'=>'LIKE'
        ];
	}
}