<?php

/**
 *
 * @link              https://guaven.com/dxtag/
 * @since             1.0.0
 * @package           Guaven_dxtag
 *
 * @wordpress-plugin
 * Plugin Name:       DxTag - SEO-Boosting WooCommerce Listing Generator
 * Plugin URI:        https://guaven.com/dxtag/
 * Description:       The plugin generates dynamic taxonomy pages where it lists any kind posts, pages, products etc. under the rules you set.(f.e. price limits, stock quantity, some match in a post title etc.)
 * Version:           1.0.5
 * Author:            Guaven Labs
 * Author URI:        https://guaven.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       guaven_dxtag
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}


define( 'GUAVEN_DXTAG_VERSION', '1.0.4' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-guaven_dxtag-activator.php
 */
function activate_guaven_dxtag() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-guaven_dxtag-activator.php';
	Guaven_dxtag_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-guaven_dxtag-deactivator.php
 */
function deactivate_guaven_dxtag() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-guaven_dxtag-deactivator.php';
	Guaven_dxtag_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_guaven_dxtag' );
register_deactivation_hook( __FILE__, 'deactivate_guaven_dxtag' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-guaven_dxtag.php';

/**
 * Begins execution of the plugin.
 * @since    1.0.0
 */
function run_guaven_dxtag() {

	$plugin = new Guaven_dxtag();
	$plugin->run();

}
run_guaven_dxtag();
