<?php 
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

$guaven_dxtag_rule = get_post_meta($post->ID, 'guaven_dxtag_rule', true);
wp_nonce_field( 'guaven_dxtag_nonce', 'guaven_dxtag_nonce' );
?>
<script type="text/javascript">
		jQuery(document).ready(function( ){
			jQuery( '#add-row' ).on('click', function() {
				var row = jQuery( '.empty-row.custom-repeter-text' ).clone(true);
				row.removeClass( 'empty-row custom-repeter-text' ).css('display','table-row');
				row.insertBefore( '#repeatable-fieldset-one tbody>tr:last' );
				return false;
			});

			jQuery( '.remove-row' ).on('click', function() {
				jQuery(this).parents('tr').remove();
				return false;
			});
		});
	    </script>

	<table id="repeatable-fieldset-one" width="100%">
		<tbody>
			<?php
			$rules=Guaven_Dxtag_Meta_Box::rule_selector();
			$operands=Guaven_Dxtag_Meta_Box::operand_selector();

			//for repetitive use
			ob_start();
				?>
				<tr class="new_creater_rule_row">
					<td>
						<select name="dxrule[]" id="dxrule_1"  class="dxtag_rule_select ffff">
						<option value="">Select a rule</option>
						<?php 
							foreach($rules as $key=>$rule){
								echo '<option value="'.esc_attr($key).'">'.esc_attr($rule).'</option>'.PHP_EOL;
							}
						?>	
						</select>
				</td>
				<td>
					<select name="dxoperand[]"  class="dxtag_rule_operand fffff">
						<?php 
							foreach($operands as $key=>$operand){
								echo '<option value="'.esc_attr($operand).'">'.esc_attr($key).'</option>'.PHP_EOL;
							}
						?>	
					</select>
				</td>
					<td><input type="text"  name="dxvalue[]" value="" placeholder="Value" /></td>
					<td><a class="button  cmb-remove-row-button button-disabled" href="#">Remove</a></td>
				</tr>
			<?php 
			$empty_row=ob_get_clean();


			//for existing rules
			if ( $guaven_dxtag_rule ) :
				foreach ( $guaven_dxtag_rule as $field ) {
					?>
					<tr>
						<td>
							<select name="dxrule[]" class="dxtag_rule_select dxtag_rule_existing">
								<option value="">Select a rule</option>
							<?php 
								foreach($rules as $key=>$rule){
									echo '<option value="'.esc_attr($key).'" '.selected($field['dxrule'],$key,false).'>'.esc_attr($rule).'</option>'.PHP_EOL;
								}
							?>	
							</select>
						</td>
						<td>
							<select name="dxoperand[]"  class="dxtag_rule_operand dxtag_rule_new">
								<?php 
									foreach($operands as $key=>$operand){
										echo '<option value="'.esc_attr($operand).'" '.selected($field['dxoperand'],$operand,false).'>'.esc_attr($key).'</option>'.PHP_EOL;
									}
								?>	
							</select>
						</td>
						<td><input type="text"  name="dxvalue[]" value="<?php if ($field['dxvalue'] != '') echo esc_attr( $field['dxvalue'] ); ?>" placeholder="Value" /></td>
						<td><a class="button remove-row" href="#1">Remove</a></td>
					</tr>
					<?php
				}
			else :
			echo $empty_row;
			endif; 
			echo str_replace('class="new_creater_rule_row"','class="empty-row custom-repeter-text" style="display: none"',$empty_row);
			?>
		</tbody>
	</table>
	<p><a id="add-row" class="button" href="#">Add another</a></p>


	<br>
	<button class="dx_regenerate button btn  button-primary button-large" style="background:green" type="button" 
	title="RE-Assigns the rule tag to corresponding products" >Update Rule Tags</button>
	<div style="padding:10px 0px;" class="dx_regenerate_response"></div>
	<script>
		jQuery(document).ready(function(){
			jQuery(".dx_regenerate").on('click',function(){
				jQuery(".dx_regenerate").attr("disabled","disabled");
				jQuery.ajax( {
					url: "<?php echo site_url();?>/wp-json/app/v1/dx-rule-regenerator?rule_id=<?php echo $post->ID;?>",
					method: 'GET',
					beforeSend: function ( xhr ) {
						xhr.setRequestHeader( 'X-WP-Nonce', wpApiSettings.nonce );
					},
				}).done(function(data,status){
					tcolor=status=='success'?'green':'red';
					jQuery(".dx_regenerate").removeAttr("disabled");
					jQuery(".dx_regenerate_response").html('<span style="padding:10px 0px;font-size:20px;color:'+tcolor+'">'+data+'</span>');
				});
			});
		});
	</script><br>
	<div class="dxtag_infobox">
	<?php
	$term_exists=get_term_by('name',$post->post_title,'gvn_dxtag');	
	if(!empty($term_exists->term_id)){
		echo __('URL for the created DxTag: ','guaven_dxtag').'<a href="'.get_term_link( $term_exists->term_id, 'gvn_dxtag' ).'">'.get_term_link( $term_exists->term_id, 'gvn_dxtag' ).'</a>';
		

		echo '<br><br>
		
		<ul><li><b>';
		_e('You can directly use this URL anywhere you want.</li>','guaven_dxtag');
		echo '</b></li>';

		

		echo '<li>';
		echo __('Alternatively, as the plugin generates native WP custom tags, You can find and insert "Smart Collections" term tags in Menus, Widgets, Post Editor, etc.','guaven_dxtag');
		echo '</li>';

		echo '<li>';
		echo __('Also check your sitemap plugin to make sure you have added  "Smart Collections" terms to your sitemap','guaven_dxtag');
		echo '</li>';

		echo '<li>';
		echo __('You can edit desciption and other fields of created taxonomy term: ','guaven_dxtag').' <a href="'.admin_url('term.php?taxonomy=gvn_dxtag&tag_ID='.$term_exists->term_id).'">'.
			 admin_url('term.php?taxonomy=gvn_dxtag&tag_ID='.$term_exists->term_id).'</a>';
		echo '</li>';

		echo '</ul>';

	}
	else 
	echo '<b>'.__('Once You save/publish the rule, URL for the created dynamic tag will appear here','guaven_dxtag').'</b>';
	?>
	</div>
	<br><br>
	<div class="dxtag_infobox">
	<?php _e('Additional Notes','guaven_dxtag'); 
	echo '<br>';
	_e('- Value field should be like {taxonomy}:{slug_value} if you choose "WP Term" rule. f.e. product_cat:shoes  or category:news etc.','guaven_dxtag');
	echo '<br>';
	_e('- To use <i>OR</i> operand in Value field, you can use | separator. For example: <i>product | product_variation</i>','guaven_dxtag');
	echo '<br>';
	_e('- To see how the rule works you need to publish it. To keep rule draft, private, pending etc. equals "not publishing" it yet.','guaven_dxtag');
	echo '<br>';
	_e('- Once you published the rule, simply click to UPDATE RULE TAGS button above.','guaven_dxtag');
	echo '<br>';
	_e('- If you unpublish/delete already published rule, then related taxonomy term will be deleted as well.','guaven_dxtag');
	echo '<br>';
	_e('- If  URL for the DxTag gives 404 not found error, just fo to Settings->Permalinks, and click to SAVE button. This will rebuild rewrite rules.','guaven_dxtag');
	?>
	</div>


	<?php echo Guaven_dxtag_Admin::dxtag_footer_help_text();