<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://guaven.com
 * @since      1.0.0
 *
 * @package    Guaven_dxtag
 * @subpackage Guaven_dxtag/admin/partials
 */
?>

<div class="dxtag_container">

<h1>DxTag Settings</h1>

<?php 
if(isset($_GET["dxtag_onboard"])){
    ?>
<div id="dxtag_onboard" >
    <h2>Welcome on-board</h2>
    <p ><?php 
    echo __('By using DxTag tool you can auto-create dynamyc listing pages (with sidebar filters if your theme supports it) 
    which is great for SEO, UX and E-Commerce Sale Boost.','guaven_dxtag');
    ?>
    <br>
    <?php 
    /* translators: %s here is admin URL where we list already created custom rules.*/
     echo sprintf( __('To get started, you can directly go to %s pages where we prepared 
     <b>pre-installed samples for you</b>.','guaven_dxtag') ,'<a href="edit.php?post_type=gvn_dxtag_rule">'.__('Manage existing Rules','guaven_dxtag').'</a>');
    ?>
    <br>
    <?php 
    /* translators: %s here is admin URL where we create our custom rules.*/
     echo sprintf( __('To create your new rule you can use <b>%1$s</b> button below. For more help, read our 
     %2$s
     or just %3$s','guaven_dxtag') ,
     __('Create new rule','guaven_dxtag'),
     '<a href="https://guaven.com/dxtag/" target="_blank">'.__('Docs','guaven_dxtag').'</a> ',
     '<a href="https://guaven.com/contact/solution-request/"  target="_blank">'.__('contact us','guaven_dxtag').'.</a>'
    );
    ?>
    </p>
</div>

    <?php 
}
?>

<p><a class="button button-primary" href="post-new.php?post_type=gvn_dxtag_rule"><?php _e('Create new rule','guaven_dxtag') ?></a></p>
or
<p><a class="button btn" href="edit.php?post_type=gvn_dxtag_rule"><?php _e('Manage existing Rules','guaven_dxtag') ?></a></p>


<hr>
<h3><?php _e('Setting fields','guaven_dxtag');?></h3>
<form action="?page=guaven_dxtag_settings" method="post"  onSubmit="return confirm('Are you sure to change the parent SLUG of all DxTag pages?');">

<?php wp_nonce_field( 'guaven_dxtag_settingsnonce', 'guaven_dxtag_settingsnonce' );?>

<label for="guaven_dxtag_tagslug"><?php _e( 'Tag Slug' ); ?></label>
<input type="text" id="guaven_dxtag_tagslug" name="guaven_dxtag_tagslug" value="<?php echo esc_attr(get_option( 'guaven_dxtag_tagslug' )); ?>">
<input type="submit" class="button" value="Save">
</p><br>
<div class="dxtag_infobox">
- <?php _e('For example, for default WordPress post tags this slug is a"tag", and an URL has <i>DOMAIN/tag/name</i> structure.  
The same for dynamic tags - just set any desired name. <br>
Examples: <i>listing, collections, morehere, pick, additional,</i> etc.
Default value is <b>"dxtag"</b>.','guaven_dxtag');?>
<br>
- <?php _e('If you face 404 error in your newly created collections, just go to Settings->Permalinks and click to update button - that will flush your permalinks cache.','guaven_dxtag');?>
</div>

</form>
<?php echo Guaven_dxtag_Admin::dxtag_footer_help_text();?>
</div>